/*-----------------------------------------
   PATHCLP2.C -- Paths and Clipping
                 (c) Charles Petzold, 1994
  -----------------------------------------*/

#include <windows.h>
#include <stdlib.h>
#include <math.h>

#define TWOPI (2 * 3.14159)

char szClass [] = "PathClp2" ;
char szTitle [] = "PathClp2: Paths and Clipping" ;

void PaintRoutine (HWND hwnd, HDC hdc, int cxArea, int cyArea)
     {
     HRGN  hRgn [3] ;
     INT   i, x, y, iAngle, iOffset ;
     POINT pt [5] ;

               // Set up an isotropic display area

     SetMapMode (hdc, MM_ISOTROPIC) ;
     SetWindowExtEx   (hdc, 2000, 1000, NULL) ;
     SetViewportExtEx (hdc, cxArea, -cyArea, NULL) ;

               // Define points on a pentagon used for the stars

     for (i = 0 ; i < 5 ; i++)
          {
          iAngle = 90 + 72 * i ;

          pt[2 * i % 5].x = (INT) (450 * cos (TWOPI * iAngle / 360)) ;
          pt[2 * i % 5].y = (INT) (450 * sin (TWOPI * iAngle / 360)) ;
          }

               // Loop through the two figures

     for (x = 0 ; x < 2 ; x++)
          {
          SetPolyFillMode (hdc, x ? WINDING : ALTERNATE) ;

          SetViewportOrgEx (hdc, (2 * x + 1) * cxArea / 4, cyArea / 2, NULL) ;

                    // Create the path

          BeginPath  (hdc) ;
          MoveToEx   (hdc, pt[0].x, pt[0].y, NULL) ;
          PolylineTo (hdc, pt + 1, 4) ;
          CloseFigure (hdc) ;
          EndPath (hdc) ;

                    // Convert to a region

          hRgn [x] = PathToRegion (hdc) ;
          }

               // Combine the regions and select the clipping area

     hRgn [2] = CreateRectRgn (0, 0, 0, 0) ;

     CombineRgn (hRgn [2], hRgn [0], hRgn [1], RGN_OR) ;

     SelectClipRgn (hdc, hRgn [2]) ;

     for (i = 0 ; i < 3 ; i++)
          DeleteObject (hRgn [i]) ;

               // Draw Bezier splines

     SetMapMode (hdc, MM_TEXT) ;
     SetViewportOrgEx (hdc, 0, 0, NULL) ;

     iOffset = (cxArea + cyArea) / 4 ;

     for (y = -iOffset ; y < cyArea + iOffset ; y++)
          {
          pt[0].x = 0 ;
          pt[0].y = y ;

          pt[1].x = cxArea / 3 ;
          pt[1].y = y + iOffset ;

          pt[2].x = 2 * cxArea / 3 ;
          pt[2].y = y - iOffset ;

          pt[3].x = cxArea ;
          pt[3].y = y ;

          SelectObject (hdc, CreatePen (PS_SOLID, 1,
               RGB (rand () % 256, rand () % 256, rand () % 256))) ;

          PolyBezier (hdc, pt, 4) ;

          DeleteObject (SelectObject (hdc, GetStockObject (BLACK_PEN))) ;
          }
     }
