/*---------------------------------------
   BMPPEN.C -- Bitmap Pen Demo
               (c) Charles Petzold, 1994
  ---------------------------------------*/

#define OEMRESOURCE
#include <windows.h>

char szClass [] = "BmpPen" ;
char szTitle [] = "BmpPen: Bitmap Pen Demo" ;

void PaintRoutine (HWND hwnd, HDC hdc, int cxArea, int cyArea)
     {
     HBITMAP  hbm ;
     LOGBRUSH lb ;

     SetMapMode (hdc, MM_ANISOTROPIC) ;
     SetWindowExtEx (hdc, 100, 100, NULL) ;
     SetViewportExtEx (hdc, cxArea, cyArea, NULL) ;

     hbm = LoadBitmap (NULL, (PSTR) OBM_CLOSE) ;

     lb.lbStyle = BS_PATTERN ;
     lb.lbColor = 0 ;
     lb.lbHatch = (LONG) hbm ;

     SelectObject (hdc,
          ExtCreatePen (PS_GEOMETRIC | PS_SOLID, 25, &lb, 0, NULL)) ;

     Ellipse (hdc, 25, 25, 75, 75) ;

     DeleteObject (
          SelectObject (hdc,
               GetStockObject (BLACK_PEN))) ;

     DeleteObject (hbm) ;
     }
