/*----------------------------------------
   LNFRAME.C -- Inside-Frame Pen Demo
                (c) Charles Petzold, 1993
  ----------------------------------------*/

#include <windows.h>

char szClass [] = "LnFrame" ;
char szTitle [] = "LnFrame: Inside-Frame Pen Demo" ;

void PaintRoutine (HWND hwnd, HDC hdc, int cxArea, int cyArea)
     {
     SetMapMode (hdc, MM_ANISOTROPIC) ;
     SetWindowExtEx (hdc, 100, 100, NULL) ;
     SetViewportExtEx (hdc, cxArea, cyArea, NULL) ;

     SelectObject (hdc, GetStockObject (NULL_BRUSH)) ;

               // Solid Wide Pen

     SelectObject (hdc,
          CreatePen (PS_SOLID, 10, RGB (196, 64, 196))) ;

     Rectangle (hdc, 10, 10, 40, 40) ;
     Ellipse   (hdc, 60, 10, 90, 40) ;

               // Inside-Frame Wide Pen

     DeleteObject (
          SelectObject (hdc,
               CreatePen (PS_INSIDEFRAME, 10, RGB (196, 64, 196)))) ;

     Rectangle (hdc, 10, 60, 40, 90) ;
     Ellipse   (hdc, 60, 60, 90, 90) ;

               // Stock Pen

     DeleteObject (
          SelectObject (hdc,
               GetStockObject (BLACK_PEN))) ;

     Rectangle (hdc, 10, 10, 40, 40) ;
     Rectangle (hdc, 60, 10, 90, 40) ;

     Rectangle (hdc, 10, 60, 40, 90) ;
     Rectangle (hdc, 60, 60, 90, 90) ;
     }
