{$X+}
Program XMSTest;
USES crt, XMS;
CONST
  NumVars     = 131072;   { 131072 total no of variables in array }
  BytesPerVar = 4;        { ie. 2 for integers, 4 for LongInts ...}
VAR
  I       : LongInt;
  Result  : LongInt;
  Hdl     : Word;          { Handle for Extended memory allocated }
  HiMemOK : boolean;
BEGIN
  ClrScr;
  HiMemOK := XMSDriverLoaded;
  WriteLn('HIMEM.SYS Driver Loaded=', HiMemOK);
  IF NOT HiMemOK THEN Halt;
  WriteLn('Total Extended Memory: ', XMSTotalMemoryAvailable, ' KB');
  WriteLn('Largest Free Extended Memory Block: ',
           XMSLargestBlockAvailable, ' KB');

  {Allocate Memory - Hdl is memory block handle or identifier}
  Hdl := XMSAllocateBlock((NumVars * BytesPerVar + 1023) DIV 1024);
         {1023 to Round Up to next KB}
  WriteLn((NumVars * BytesPerVar + 1023) DIV 1024,'KB Handle=',Hdl);
  WriteLn('Total Extended Memory Available After Allocation: ',
          XMSTotalMemoryAvailable, ' KB');

  { Fill the variables with 1 ... NumVars for exercise }
  WriteLn('Filling Memory Block ');
  FOR I := 1 TO NumVars DO
    BEGIN
      { parameters in Move Data are - Address of Data to Move
                                    - Number of Bytes
                                    - Memory Handle
                                    - Offset in XMS Area }
      IF NOT XMSMoveDataTo(@I, BytesPerVar, Hdl, (I - 1) *
        BytesPerVar) THEN
        WriteLn('Error on Move to XMS: ',I,' Error: ', XMSErrorCode);
      IF I MOD 1024 = 0 THEN Write(I:6,^M);
    END;
  WriteLn;
  { Now read a couple of locations just to show how}
  I := 1;  { First Element }
  IF NOT XMSGetDataFrom(Hdl, (I - 1) * BytesPerVar,
    BytesPerVar, @Result) THEN
    WriteLn('Error on XMSGetDataFrom')
    ELSE WriteLn('XMS Data [',I,']=',Result); { Print it }
  I := NumVars;  { Last Element }
  IF NOT XMSGetDataFrom(Hdl, (I - 1) * BytesPerVar, BytesPerVar,
    @Result) THEN
    WriteLn('Error on XMSGetDataFrom')
    ELSE WriteLn('XMS Data [',I,']=',Result); { Print it }

  WriteLn('Release status=', XMSReleaseBlock(Hdl));
  WriteLn('Press a key.');
  ReadKey;
END.
