;---------------------------------------------------------------------
; DD.SC                                                 Paradox 3.5
; Create a table structure dictionary for the current directory.
;---------------------------------------------------------------------
IF NOT ISFILE("DD.DB")                ; If file not found, error
   THEN
   QUIT "File DD.DB not found."
ELSE
   EMPTY "DD"                        ; Empty the dictionary table
   MESSAGE "DD: Creating table structure dictionary.."
ENDIF
CANVAS OFF
SETDIR DIRECTORY()                     ; Get rid of temporary tables
                                       ;  and clear workspace
MENU {Tools} {Info}
{Inventory} {Tables} {}                ; Get a list of tables in current
RENAME "List" "Tables"                 ;  directory and rename it
QUERY
 Tables | Name       |                 ; Removes List and Dd from the
 delete | List OR Dd |                 ;   table of table names
ENDQUERY
DO_IT!                                 ; Do the query
MOVETO 1                               ; Move to first image on workspace
CLEARIMAGE                             ; Remove the query image
numrec = NRECORDS("Tables")            ; Get number of tables
FOR count FROM 1 TO numrec             ; Loop through each entry
   MOVETO "Tables"                     ; Move to the "Tables" Image
   MOVETO RECORD count                 ; Move to the next record
   tabname = [name]                    ; Assign table name to tabname
   MENU {Tools} {Info} {Structure}     ; Get the structure of the table
   SELECT tabname                      ;   in table STRUCT
   QUERY                               ; Insert the table name, field
                                       ;   and field type into DD table
       Dd     | Table Name | Field Name | Field Type |
       insert | ~tabname   | _fn        | _ft        |

       Struct | Field Name | Field Type |
              | _fn        | _ft        |
   ENDQUERY
   DO_IT!                              ; Do the query
ENDFOR
DELETE "Tables"                        ; Remove the table of tables
SETDIR DIRECTORY()                     ; Get rid of temporary tables
                                       ;  and clear workspace
CANVAS ON
MESSAGE "DD: Finished..."
VIEW "DD"                              ; View the Dictionary table
