// findfile.h

#if !defined(FINDFILE_H)
#define FINDFILE_H

#include<dos.h>
#include<dir.h>
#include<string.h>
#include"stddefs.h"
#include"compiler.h"

class FindFile
    {
    struct ffblk F;
    int notfound;
    int nomore;

public:
    FindFile(char *filename, unsigned type);
    int FindNext(void);
    int NotFound(void)      {   return notfound;    }
    int Found(void)         {   return !notfound;   }
    char *Name(void)        {   return F.ff_name;   }
    long Size(void)         {   return F.ff_fsize;  }
    };

class RecursiveFileFind
    {
    char rffdirspec[80], rfffilespec[13];
    BOOL keycheck, eatkey;

    BOOL rff(char *dirspec, char *filespec);
    virtual void PostResults(char *,struct ffblk *) = 0;

public:
    RecursiveFileFind(void)
        {
        *rffdirspec = *rfffilespec = '\0';
        }

    RecursiveFileFind(char *dspec, char *fspec)
        {
        Init(dspec,fspec);
        rff(rffdirspec,rfffilespec);
        }

    void Init(char *dspec, char *fspec, BOOL keychecking = FALSE)
        {
        strcpy(rffdirspec,dspec);
        strcpy(rfffilespec,fspec);
        keycheck = keychecking;
        eatkey = FALSE;
        }

    BOOL Run(void)
        {
        return rff(rffdirspec,rfffilespec);
        }

    BOOL Run(char *dirspec, char *filespec)
        {
        return rff(dirspec,filespec);
        }

    void SetKeyCheck(void)
        {
        keycheck = TRUE;
        }
    void SetEatKey(void)
        {
        keycheck = eatkey = TRUE;
        }
    };

#endif





