// file.h

#if !defined(FILE_H)
#define FILE_H

#include<stdio.h>
#include<string.h>
#include<dir.h>
#include<iostream.h>
#include<io.h>
#include"findfile.h"
#include"stddefs.h"

class File
    {
    FILE *fp;
    char *name;
    int linelen;
    char *linebuffer;
    char mode[5];
    int MAXBUF;

    void Init(void);
    void InitLineBuffer(void);
    void SetLineBuffer(void);

public:
    File(char *newname);
    File(void)                      {   Init();             }
    ~File(void);
    void SetName(char *newname);
    int Open(char *m);
    void Close(void);
    void SetLineLen(int len)        {   linelen = len;      }
    char *GetLine(void);
    int Delete(void);
    int Move(char *movedir);
    int Copy(char *newfile);
    void Reset(void)                {   rewind(fp);         }
    int ReadAt(long offset, int size, void *buf);
    int Read(int size, void *buf);
    int _fRead(int size, void far *buf, char *nearbuf);
    int Write(int size, void *buf);
    int _fWrite(int size, void far *buf, char *nearbuf);
    int WriteAt(long offset, int size, void *buf);
    long CurPosition(void)          {   return ftell(fp);   }
    int Offset(long offset)         {   return fseek(fp,offset,SEEK_SET);   }
    long Size(void);
    char *GetName(void)             {   return name;        }
    int Flush(void)                 {   return fflush(fp);  }
    BOOL IsOpen(void)               {   return (fp ? TRUE : FALSE); }
    };
#endif



            



