***********************************************************************
* PROCEDURE Rec2Rec( nToArea )                           Clipper 5.01
* Copy current record in current work area to current
* record in destination workarea
***********************************************************************
PROCEDURE Rec2Rec( nToArea )
LOCAL i, nFCnt:= FCOUNT()              && Get field count
nFromArea:= SELECT()                   && Get current work area

SELECT ( nToArea )                     && Select destination work area

FOR i:= 1 TO nFCnt                     && Loop through, copying fields
   FIELDPUT( i, ( nFromArea )->( FIELDGET( i ) ) )
NEXT

SELECT ( nFromArea )                   && Return to from work area
RETURN                                 && Return to caller

***********************************************************************
* FUNCTION Rec2Array()                                   Clipper 5.01
* Copy record from current work area into an array
***********************************************************************
FUNCTION Rec2Array()
LOCAL nFCnt:= FCOUNT()                 && Get field count
LOCAL i, aArray[ nFCnt ]               && Create the array

FOR i:= 1 TO nFCnt                     && Loop through, storing each
   aArray[ i ]:= FIELDGET( i )         && field in an array element
NEXT
RETURN aArray                          && Return the array

***********************************************************************
* PROCEDURE Array2Rec( aArray )                          Clipper 5.01
* Copy an array to the current record in the current work area
***********************************************************************
PROCEDURE Array2Rec( aArray )
AEVAL( aArray, {| v, i | FIELDPUT( i, v ) } )    && Write the array
RETURN
