;**********************************************************************
; COLOR.SC                  Paradox procedure to pop-up a color chart
;**********************************************************************

CREATELIB "X:\\PDOXPRIV\\Mylib"            ; Create library

;----------------------------------------------------------------------
; ClrChrt()
; Paradox Procedure to draw a color/attrib chart
;----------------------------------------------------------------------
PROC CLOSED ClrChrt()
   USEVARS Autolib
   q = 0
   i = 0
   n = 0

   CANVAS OFF
   Box(4, 5, 21, 73, "", 127, True)  ; Draw box for chart

   @ 5, 7
   FOR i FROM 0 to 15                        ; outer loop - does rows
      FOR n FROM 0 to 15                     ; inner loop - does columns
         STYLE ATTRIBUTE q                   ; set attribute (color)
                                    ; write attribute code in attribute color
         @ ROW(),COL() ?? FORMAT("W4,EZ",q)

         q = q + 1                           ; increment attribute
      ENDFOR                                 ; loop inside
      @ROW() + 1, 7                          ; increment row
   ENDFOR                                    ; loop outside
   STYLE ATTRIBUTE 113
   @ 4, 29 ?? " Paradox Color Chart "

   CANVAS ON                                 ; display canvas
   n = GETCHAR()                             ; hold until user presses
                                             ; a key.
ENDPROC

;----------------------------------------------------------------------
; Box (TROW, TCOL, BROW, BCOL, char, color, shadow)
; Paradox procedure to draw a filled box with optional drop shadow.
;----------------------------------------------------------------------
PROC CLOSED Box (TROW, TCOL, BROW, BCOL, char, color, shadow)
   tlc      = SUBSTR(char, 1, 1)
   top      = SUBSTR(char, 2, 1)
   trc      = SUBSTR(char, 3, 1)
   side     = SUBSTR(char, 4, 1)
   blc      = SUBSTR(char, 5, 1)
   brc      = SUBSTR(char, 6, 1)
   fillchar = SUBSTR(char, 7, 1)

   wide    = BCOL - TCOL - 2
   high    = BROW - TROW - 1
   i       = 0

   IF shadow = TRUE THEN           ; Draw shadow or don't
      PAINTCANVAS ATTRIBUTE 0+7 TROW+1, TCOL+1, BROW+1, BCOL+1
   ENDIF

   STYLE ATTRIBUTE color           ; Set color as passed in 'color' parm

   ; Draw each box row as a string made up of the box chars
   ; and the fillchar. First, the top row, then a loop to do all
   ; the interim rows - and finally the bottom row.

   @TROW, TCOL ?? tlc + FILL(top,wide) + trc

   FOR i FROM 1 TO high
           @TROW + i, TCOL ?? side + FILL(fillchar,wide) + side
   ENDFOR

   @BROW, TCOL ?? blc + FILL(top, wide) + brc
ENDPROC

WRITELIB "X:\\PDOXPRIV\\Mylib" ClrChrt, Box
