/***************************************************************************

   File:    save.c

   Date:    5/31/91

   CFGSAVE 1.0 Copyright (c) 1991 Gene Kavner
   First published in PC Magazine, October 29, 1991

***************************************************************************/


/***************************************************************************
                              Includes
***************************************************************************/
#include <windows.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <stdio.h>
#include <time.h>
#include <dos.h>
#include <io.h>

#include "save.h"

/***************************************************************************
                              Globals
***************************************************************************/
HWND        hwndTop, hProgMan;
HANDLE      hGlobalInstance;
FARPROC     lpOldProgmanProc;
WORD        fGlobalState = DONT_INTERCEPT_QUERYENDSESSION;


/***************************************************************************
                              WinMain
***************************************************************************/
int PASCAL WinMain (hInst, hPreInst, lpszCmdLine, nCmdShow)
HANDLE hInst, hPreInst;
LPSTR lpszCmdLine;
int nCmdShow;
{
   static FARPROC    lpfnSaveProc;

   WORD              wVersion;
   WNDCLASS          wcSave;
   MSG               msg;
   int               iIndex;


   /* obtain version number of this Windows environment */
   wVersion = GetVersion();

   /* make sure this is Windows v3.0; if not, display warning and exit CfgSave */
   if (wVersion != 0x0003) {
      char szText[150], szText1[150];

      wsprintf(szText, "You are attempting to run CfgSave v3.0 on Windows v%d.%d; ",
                wVersion&0xff, wVersion>>8);

      wsprintf(szText1, "Please download CfgSave v%d.%d from PC Magnet",
                        wVersion&0xff, wVersion>>8);

      strcat (szText, szText1);

      MessageBox(NULL, szText, "CfgSave v3.0", MB_OK | MB_ICONSTOP);
      return(FALSE);
   }

   if (!hPreInst) {
      wcSave.lpszClassName = SAVE_CLASS;
      wcSave.hInstance = hGlobalInstance = hInst;
      wcSave.lpfnWndProc = SaveProc;
      wcSave.hCursor = NULL;
      wcSave.hIcon = LoadIcon (hInst, "SaveIcon");
      wcSave.lpszMenuName = NULL;
      wcSave.hbrBackground = GetStockObject(BLACK_BRUSH);
      wcSave.style = CS_HREDRAW | CS_VREDRAW;
      wcSave.cbClsExtra = 0;
      wcSave.cbWndExtra = 0;
      if (!RegisterClass(&wcSave)) {
         return FALSE;
      }
   }
   else
      return FALSE;     // if another version of CfgSave is running, just exit

   /* create a hidden window that will receive WM_QUERYENDSESSION message */
   hwndTop = CreateWindow (SAVE_CLASS, SAVE_APPNAME,
                  WS_OVERLAPPEDWINDOW,
                  0, 0, CW_USEDEFAULT, CW_USEDEFAULT,
                  NULL, NULL, hInst, NULL);


   /* modal loop */
   while (GetMessage (&msg, NULL, NULL, NULL)) {
      TranslateMessage(&msg);
      DispatchMessage(&msg);
   }

   return TRUE;
}





/***************************************************************************
                              SaveProc
***************************************************************************/
LONG FAR PASCAL SaveProc(hwnd, messg, wParam, lParam)
HWND hwnd;
unsigned messg;
WORD wParam;
LONG lParam;
{
   FARPROC           lpProgmanProc;
   HMENU             hMainMenu, hSubMenu;

   switch (messg) {

   case WM_CREATE:
      /* obtain handle to the Program Manager window */
      hProgMan = FindWindow(NULL, "Program Manager");

      /* if handle exists, ProgMan must be present, otherwise no ProgMan */
      if (hProgMan) {
         PostMessage(hwnd, ACCESS_PROGMAN, NULL, NULL);
      }
      else {
         /* set timer to check Progman existence every half a second */
         SetTimer (hwnd, ID_TIMER, 500, NULL);
      }
      break;

   case WM_TIMER:
      /* obtain handle to the Program Manager window */
      hProgMan = FindWindow(NULL, "Program Manager");

      /* if handle exists, ProgMan must be present, otherwise no ProgMan */
      if (hProgMan) {
         PostMessage(hwnd, ACCESS_PROGMAN, NULL, NULL);
         KillTimer (hwnd, ID_TIMER);
      }
      break;


   case ACCESS_PROGMAN:

      /*************************/
      /* modify ProgMan's menu */
      /*************************/

      /* obtain handle to Program Manager's menu */
      hMainMenu = GetMenu (hProgMan);
      if (!hMainMenu) {                /* make sure ProgMan has menu */
         MessageBeep(NULL);
         break;
      }

      /* get handle to a 'File' popup */
      hSubMenu = GetSubMenu (hMainMenu, 0);

      /* insert 'Save Configuration' menu item and a separator bar */
      InsertMenu(hSubMenu, 6, MF_BYPOSITION | MF_ENABLED, ID_SAVE, "&Save Configuration");
      InsertMenu(hSubMenu, 6, MF_BYPOSITION | MF_ENABLED | MF_SEPARATOR, NULL, NULL);

      /***************************/
      /* subclass Progman Window */
      /***************************/

      /* produce a pointer to this app's instance of the New Program Manager proc */
      if (!(lpProgmanProc=MakeProcInstance((FARPROC)NewProgmanProc,hGlobalInstance))) {
         MessageBeep(NULL);
         break;
      }

      /* obtain a pointer to the Program Manager's current window procedure */
      lpOldProgmanProc = (FARPROC) GetWindowLong (hProgMan, GWL_WNDPROC);

      /* modify Program Manager's window procedure */
      SetWindowLong (hProgMan, GWL_WNDPROC, (LONG) lpProgmanProc);
      break;


   case WM_QUERYENDSESSION:
      /* if we are currently intercepting WM_QUERYENDSESSION messages,
         return NULL (abort Windows exit); otherwise return TRUE (continue
         Windows exit) */
      if (fGlobalState == INTERCEPT_QUERYENDSESSION) {
         return NULL;
      }
      else {
         return TRUE;
      }
      break;


   case WM_DESTROY:
      /* set Program Manager's window proc to be its original window proc */
      SetWindowLong (hProgMan, GWL_WNDPROC, (LONG) lpOldProgmanProc);
      PostQuitMessage(0);
      break;

   default:
      return (DefWindowProc(hwnd, messg, wParam, lParam));
      break;
   }
   return (0L);
}




/***************************************************************************
                              NewProgmanProc
***************************************************************************/
LONG FAR PASCAL NewProgmanProc(hwnd, messg, wParam, lParam)
HWND hwnd;
unsigned messg;
WORD wParam;
LONG lParam;
{
   switch (messg) {
   case WM_COMMAND:
      if (wParam == ID_SAVE) {

         /* start hooking WM_CREATE and WM_QUERYENDSESSION messages */
         SetMessageHook(hwndTop);

         /* intercept WM_QUERYENDSESSION messages so that Windows would not
            be able to exit */
         fGlobalState=INTERCEPT_QUERYENDSESSION;

         /* send a WM_CLOSE msg to ProgMan, causing it to initiate Windows Exit */
         SendMessage(hProgMan, WM_CLOSE, NULL, NULL);

         /* at this point, Config has been saved and we can end hooking messages
            and stop intercepting WM_QUERYENDSESSION messages */
         CancelMessageHook();
         fGlobalState=DONT_INTERCEPT_QUERYENDSESSION;

         return (0L);
      }
      break;

   default:
      break;
   }
   return (CallWindowProc (lpOldProgmanProc, hwnd, messg, wParam, lParam));
}
