Code Box:

2DIR.C
COMPLETE LISTING



// 2DIR.C: Display 2 Directories.

#include<stdio.h>
#include<dos.h>
#include<stdlib.h>
#include<string.h>
#include<direct.h>
#include<graph.h>

#define DriveLet(str)   (*str - 'A' + 1)
#define DIRNAMELEN  67
#define MAXFILES    1024

char *orgdir = NULL;
char full_names[MAXFILES][13];
long sizes[MAXFILES], lenfiles1 = 0L, lenfiles2 = 0L;
unsigned dates[MAXFILES], times[MAXFILES];
int numfiles1, numfiles2;

void terminate(void);
void display_direntry(int x1);
void read_files_info(int mx);
void setdir(char *dirname);
void process_dir(char *dirname);

void main(int argc, char *argv[])
    {
    int x1, x2;
    char dirname1[DIRNAMELEN], dirname2[DIRNAMELEN];

    if(argc != 3)
        {
        puts("Usage: 2dir <dirname> <dirname>");
        exit(0);
        }

    strupr(argv[1]);
    strupr(argv[2]);
    orgdir = getcwd(NULL, DIRNAMELEN);  // save original directory
    
    // switch to first dir
    process_dir(argv[1]);

    // switch to 2nd dir and do the same..
    process_dir(argv[2]);

    // display the directories...
    _clearscreen(_GCLEARSCREEN);
    sprintf(dirname1,"Directory %s",argv[1]);
    sprintf(dirname2,"Directory %s",argv[2]);
    printf("%-40s%-40s",dirname1,dirname2);

    x1 = 0;
    x2 = numfiles1;
    if(x2 > numfiles2)
        numfiles2 = x2;

    while(x1 < numfiles1 || x2 < numfiles2)
        {
        if(x1 < numfiles1)
            {
            display_direntry(x1);
            lenfiles1 += sizes[x1];
            x1++;
            }
        else
            printf("\n%37s","");
        if(x2 < numfiles2)
            {
            display_direntry(x2);
            lenfiles2 += sizes[x2];
            x2++;
            }
        }
    if(numfiles1 > (numfiles2-numfiles1))
        printf("\n");
    if(x1 == numfiles1)
        printf("%5u file(s) occupying %ld bytes",numfiles1,lenfiles1);
    printf("        ");
    if(x2 == numfiles2)
        printf("%5u file(s) occupying %ld bytes",
            numfiles2-numfiles1,lenfiles2);
    terminate();
    }

void process_dir(char *dirname)
    {
    unsigned drive, numdrives;
    char *original;

    if(dirname[1] == ':')
        {
        drive = DriveLet(dirname);
        _dos_setdrive(drive, &numdrives);
        original = getcwd(NULL, DIRNAMELEN-1);
        }

    if(chdir(dirname))
        {
        printf("\n        Directory %s Does Not Exist\n", dirname);
        setdir(original);
        free(original);
        terminate();
        }

    read_files_info(numfiles1);

    setdir(original);
    setdir(orgdir);
    }


// displays each entry
void display_direntry(int i)
    {
    char *exten, m;
    unsigned xdate, xtime, hour;

    if(exten = strchr(full_names[i],'.'))
        {
        *exten = '\0';
        exten++;
        }
    else
        exten = "   ";
    
    xdate = dates[i];
    xtime = times[i];
    if( (hour = (xtime >> 11)) > 12)
        {
        hour -= 12;
        m = 'p';
        }
    else
        m = 'a';
    if(hour == 0)
        hour = 12;

    printf("%s%-8s %-3s %8ld %2u-% 02u-%02u %2u:%02u%c",
        (i < numfiles1) ? "\n" : "     ",
        full_names[i], exten, sizes[i],
        (xdate >> 5) & 0x000f, (xdate & 0x001f), (xdate >> 9) + 80,
        hour, (xtime >> 5) & 0x3f, m);
    }
    
// resets all directories and terminates
void terminate(void)
    {
    setdir(orgdir);
    printf("\n");
    exit(0);
    }

// sets drive and directory
void setdir(char *dirname)
    {
    unsigned numdrives, drive;

    if(dirname && dirname[1] == ':')
        {
        drive = DriveLet(dirname);
        _dos_setdrive(drive, &numdrives);
        chdir(dirname);
        }
    }

// reads each directory
void read_files_info(int mx)
    {
    int i = mx, status;
    struct find_t fileinfo;

    status = _dos_findfirst("*.*",
                    (_A_NORMAL | _A_RDONLY | _A_ARCH), &fileinfo);
    while(!status)
        {
        strcpy(full_names[i], fileinfo.name);
        sizes[i] = fileinfo.size;
        dates[i] = fileinfo.wr_date;
        times[i] = fileinfo.wr_time;

        i++;
        if(i >= MAXFILES)
            {
            puts("Too many directory entries for 2dir!\n");
            terminate();
            }

        status = _dos_findnext(&fileinfo);
        }
    if(mx == 0)
        numfiles1 = i;
    else
        numfiles2 = i;
    }


Figure C: 2DIR displays two directories from any drive on the screen for easy comparison. 