/*===========================================================================*/
/*                                                                           */
/* File    : SELECT.C                                                        */
/*                                                                           */
/* Purpose : Routines to implement an outline for dragging and stretching a  */
/*           graphical object.                                               */
/*                                                                           */
/* History : Most of this is from the SELECT example in the MS Win 3.0 SDK.  */
/*                                                                           */
/*===========================================================================*/

#include <windows.h>
#include "ico.h"


VOID PASCAL StartSelection(hWnd, ptCurrent, lpSelectRect, idTool)
  HWND   hWnd;
  POINT  ptCurrent;
  LPRECT lpSelectRect;
  int    idTool;
{
  if (lpSelectRect->left != lpSelectRect->right ||
      lpSelectRect->top  != lpSelectRect->bottom)
    ClearSelection(hWnd, lpSelectRect, idTool);

  lpSelectRect->left   = ptCurrent.x;
  lpSelectRect->top    = ptCurrent.y;
  lpSelectRect->right  = ptCurrent.x;
  lpSelectRect->bottom = ptCurrent.y;
  SetCapture(hWnd);
}


VOID PASCAL UpdateSelection(hWnd, ptCurrent, lpSelectRect, idTool)
  HWND   hWnd;
  POINT  ptCurrent;
  LPRECT lpSelectRect;
  int    idTool;
{
  HDC hDC;
  short OldROP;

  hDC = GetDC(hWnd);

  OldROP = SetROP2(hDC, R2_NOTXORPEN);


  switch (idTool)
  {
    case ID_OPENRECT :
    case ID_FILLRECT :
    case ID_SELECT   :
      MoveTo(hDC, lpSelectRect->left, lpSelectRect->top);
      LineTo(hDC, lpSelectRect->right, lpSelectRect->top);
      LineTo(hDC, lpSelectRect->right, lpSelectRect->bottom);
      LineTo(hDC, lpSelectRect->left, lpSelectRect->bottom);
      LineTo(hDC, lpSelectRect->left, lpSelectRect->top);

      LineTo(hDC, ptCurrent.x, lpSelectRect->top);
      LineTo(hDC, ptCurrent.x, ptCurrent.y);
      LineTo(hDC, lpSelectRect->left, ptCurrent.y);
      LineTo(hDC, lpSelectRect->left, lpSelectRect->top);
      break;

    case ID_LINE     :
      MoveTo(hDC, lpSelectRect->left, lpSelectRect->top);
      LineTo(hDC, lpSelectRect->right, lpSelectRect->bottom);
      MoveTo(hDC, lpSelectRect->left, lpSelectRect->top);
      LineTo(hDC, ptCurrent.x, ptCurrent.y);
      break;

    case ID_CIRCLE   :
    case ID_FILLCIRC :
      MoveTo(hDC, lpSelectRect->left, lpSelectRect->top);
      Ellipse(hDC, lpSelectRect->left, lpSelectRect->top,
                   lpSelectRect->right, lpSelectRect->bottom);
      Ellipse(hDC, lpSelectRect->left, lpSelectRect->top,
                   ptCurrent.x, ptCurrent.y);
      break;
  }

  SetROP2(hDC, OldROP);
  lpSelectRect->right = ptCurrent.x;
  lpSelectRect->bottom = ptCurrent.y;
  ReleaseDC(hWnd, hDC);
}


VOID PASCAL EndSelection(ptCurrent, lpSelectRect)
  POINT  ptCurrent;
  LPRECT lpSelectRect;
{
  lpSelectRect->right  = ptCurrent.x;
  lpSelectRect->bottom = ptCurrent.y;
  ReleaseCapture();
}


VOID PASCAL ClearSelection(hWnd, lpSelectRect, idTool)
  HWND   hWnd;
  LPRECT lpSelectRect;
  int    idTool;
{
  HDC hDC;
  short OldROP;

  hDC = GetDC(hWnd);

  OldROP = SetROP2(hDC, R2_NOTXORPEN);

  switch (idTool)
  {
    case ID_OPENRECT :
    case ID_FILLRECT :
    case ID_SELECT   :
      MoveTo(hDC, lpSelectRect->left,  lpSelectRect->top);
      LineTo(hDC, lpSelectRect->right, lpSelectRect->top);
      LineTo(hDC, lpSelectRect->right, lpSelectRect->bottom);
      LineTo(hDC, lpSelectRect->left,  lpSelectRect->bottom);
      LineTo(hDC, lpSelectRect->left,  lpSelectRect->top);
      break;

    case ID_LINE     :
      MoveTo(hDC, lpSelectRect->left,  lpSelectRect->top);
      LineTo(hDC, lpSelectRect->right, lpSelectRect->bottom);
      break;

    case ID_CIRCLE   :
    case ID_FILLCIRC :
      Ellipse(hDC, lpSelectRect->left, lpSelectRect->top,
                   lpSelectRect->right, lpSelectRect->bottom);
      break;
  }

  SetROP2(hDC, OldROP);
  ReleaseDC(hWnd, hDC);
}


VOID PASCAL SortRect(LPRECT lpRect)
{
  int t;
  
  if (lpRect->top > lpRect->bottom)
  {
    t = lpRect->top;
    lpRect->top = lpRect->bottom;
    lpRect->bottom = t;
  }

  if (lpRect->left > lpRect->right)
  {
    t = lpRect->left;
    lpRect->left = lpRect->right;
    lpRect->right = t;
  }
}
