/*===========================================================================*/
/*                                                                           */
/* File    : OPENFILE.C                                                      */
/*                                                                           */
/* Purpose : Provides the File/Open and File/Save dialog boxes.              */
/*                                                                           */
/* History : This came from the MS Win 3.0 SDK                               */
/*                                                                           */
/*===========================================================================*/

#include <stdlib.h>
#include <ctype.h>
#include <dos.h>
#include <fcntl.h>
#include <io.h>
#include <sys\types.h>
#include <sys\stat.h>
#include <string.h>
#include <windows.h>
#include "ico.h"

#define ID_EDIT        100
#define ID_PATH        101
#define ID_LISTBOX     102
#define ID_DIRLISTBOX  103

void SeparateFile(LPSTR, LPSTR, LPSTR);
void UpdateListBox(HWND);
void ChangeDefExt(PSTR, PSTR);
void UpdateSaveasListBox(HWND);
int  ICORead(HWND, char *);



char DefPath[128];
char DefSpec[13] = "*.ico";
char DefExt[13] = ".ico";


BOOL FAR PASCAL OpenFileDlgProc(hDlg, message, wParam, lParam)
  HWND hDlg;
  unsigned message;
  WORD wParam;
  LONG lParam;
{
  char szBuf[128];
  char OpenName[128];

  switch (message)
  {
    case WM_INITDIALOG:                          /* message: initialize    */
      strcpy(DefSpec, "*.ico");
      strcpy(DefExt,  "*.ico");
      UpdateListBox(hDlg);
      SetDlgItemText(hDlg, ID_EDIT, DefSpec);
      SendDlgItemMessage(hDlg,                   /* dialog handle          */
                         ID_EDIT,                /* where to send message  */
                         EM_SETSEL,              /* select characters      */
                         NULL,                   /* additional information */
                         MAKELONG(0, 0x7FFF));   /* entire contents        */
      SetFocus(GetDlgItem(hDlg, ID_EDIT));
      return FALSE;   /* Indicates the focus is set to a control */


    case WM_COMMAND:
      switch (wParam)
      {
        case ID_LISTBOX:
           switch (HIWORD(lParam))
           {
             case LBN_SELCHANGE:
               /* If item is a directory name, append "*.*" */
               if (DlgDirSelect(hDlg, szBuf, ID_LISTBOX)) 
                 strcat(szBuf, DefSpec);
               SetDlgItemText(hDlg, ID_EDIT, szBuf);
               SendDlgItemMessage(hDlg, ID_EDIT, EM_SETSEL, NULL,
                                                 MAKELONG(0, 0x7FFF));
               break;

             case LBN_DBLCLK:
               goto openfile;
           }
           return TRUE;

        case ID_DIRLISTBOX:
           switch (HIWORD(lParam))
           {
             case LBN_SELCHANGE:
               /* If item is a directory name, append "*.*" */
               if (DlgDirSelect(hDlg, szBuf, ID_DIRLISTBOX)) 
                 strcat(szBuf, DefSpec);
               SetDlgItemText(hDlg, ID_EDIT, szBuf);
               SendDlgItemMessage(hDlg, ID_EDIT, EM_SETSEL, NULL,
                                                 MAKELONG(0, 0x7FFF));
               break;

             case LBN_DBLCLK:
               goto openfile;
               break;
           }
           return TRUE;

         case IDOK:
openfile:
           GetDlgItemText(hDlg, ID_EDIT, OpenName, 128);
           if (strchr(OpenName, '*') || strchr(OpenName, '?'))
           {
             SeparateFile(szBuf, DefSpec, OpenName);
             if (szBuf[0])
               strcpy(DefPath, szBuf);
             ChangeDefExt(DefExt, DefSpec);
             UpdateListBox(hDlg);
             return TRUE;
           }
           if (!OpenName[0])
           {
             MessageBox(hDlg, "No filename specified.", "Error",
                                                        MB_OK | MB_ICONHAND);
             return TRUE;
           }

           /*
              Add the extension to the file name if it doesn't have
              an extension already
           */
           if (strchr(OpenName, '.') == NULL)
             strcat(OpenName, DefExt);

           ICORead(hWndEdit, OpenName);

           EndDialog(hDlg, IDOK);
           return TRUE;

         case IDCANCEL:
           EndDialog(hDlg, IDCANCEL);
           return TRUE;
      }
    }
    return FALSE;
}


void UpdateListBox(hDlg)
  HWND hDlg;
{
  char str[80];

  strcpy(str, DefPath);
  strcat(str, DefSpec);
  DlgDirList(hDlg, str, ID_LISTBOX, ID_PATH, 0x0000);
  DlgDirList(hDlg, "*.*", ID_DIRLISTBOX, 0, 0xC010);
  SetDlgItemText(hDlg, ID_EDIT, DefSpec);
  SendDlgItemMessage(hDlg, ID_EDIT, EM_SETSEL, NULL, MAKELONG(0, 0x7FFF));
}


void ChangeDefExt(Ext, Name)
  PSTR Ext, Name;
{
  PSTR pTptr;

  if ((pTptr = strchr(Name, '.')) != NULL)
    if (!strchr(pTptr, '*') && !strchr(pTptr, '?'))
      strcpy(Ext, pTptr);
}


void SeparateFile(lpDestPath, lpDestFileName, lpSrcFileName)
  LPSTR lpDestPath, lpDestFileName, lpSrcFileName;
{
  LPSTR lpTmp;
  char  cTmp;

  /*
     Scan backwards until we find a '\' or a drive designator
  */
  lpTmp = lpSrcFileName + (long) lstrlen(lpSrcFileName);
  while (*lpTmp != ':' && *lpTmp != '\\' && lpTmp > lpSrcFileName)
    lpTmp = AnsiPrev(lpSrcFileName, lpTmp);

  if (*lpTmp != ':' && *lpTmp != '\\')
  {
    lstrcpy(lpDestFileName, lpSrcFileName);
    lpDestPath[0] = '\0';
    return;
  }

  /*
    Copy the actual file name or file spec into pDestFileName
  */
  lstrcpy(lpDestFileName, lpTmp + 1);
  cTmp = *(lpTmp + 1);

  /*
    Copy the root part of the path into lpDestPath
  */
  lstrcpy(lpDestPath, lpSrcFileName);
  *(lpTmp + 1) = cTmp;

  lpDestPath[(lpTmp - lpSrcFileName) + 1] = '\0';
}



BOOL FAR PASCAL SaveAsDlgProc(hDlg, message, wParam, lParam)
  HWND hDlg;
  unsigned message;
  WORD wParam;
  LONG lParam;
{
  char szBuf[128];
  char OpenName[128];
  int  id;
  char *pDot;


  switch (message)
  {
    case WM_INITDIALOG:                          /* message: initialize    */
      DlgDirList(hDlg, "*.*", ID_DIRLISTBOX, ID_PATH, 0xC010);
      SetDlgItemText(hDlg, ID_EDIT, DefSpec);
      SendDlgItemMessage(hDlg,                   /* dialog handle          */
                         ID_EDIT,                /* where to send message  */
                         EM_SETSEL,              /* select characters      */
                         NULL,                   /* additional information */
                         MAKELONG(0, 0x7FFF));   /* entire contents        */
      SetFocus(GetDlgItem(hDlg, ID_EDIT));
      return FALSE;   /* Indicates the focus is set to a control */


    case WM_COMMAND:
      switch (wParam)
      {
        case ID_DIRLISTBOX:
           switch (HIWORD(lParam))
           {
             case LBN_SELCHANGE:
               if (DlgDirSelect(hDlg, szBuf, ID_DIRLISTBOX)) 
                 strcat(szBuf, DefSpec);
               SetDlgItemText(hDlg, ID_EDIT, szBuf);
               SendDlgItemMessage(hDlg, ID_EDIT, EM_SETSEL, NULL,
                                                 MAKELONG(0, 0x7FFF));
               break;
             case LBN_DBLCLK:
               GetDlgItemText(hDlg, ID_EDIT, OpenName, 128);
               SeparateFile(szBuf, DefSpec, OpenName);
               if (szBuf[0])
                 strcpy(DefPath, szBuf);
               strcat(DefPath, DefSpec);
               DlgDirList(hDlg, szBuf, ID_DIRLISTBOX, ID_PATH, 0xC010);
               break;
           }
           return TRUE;

         case IDOK:
openfile:
           GetDlgItemText(hDlg, ID_EDIT, OpenName, 128);
           if (strchr(OpenName, '*') || strchr(OpenName, '?'))
           {
             MessageBox(hDlg, "Illegal filename specified.", "Error",
                                                        MB_OK | MB_ICONHAND);
             return TRUE;
           }
           if (!OpenName[0])
           {
             MessageBox(hDlg, "No filename specified.", "Error",
                                                        MB_OK | MB_ICONHAND);
             return TRUE;
           }

           ICOWrite(OpenName, IconInfo.hBitmapBits);
           strcpy(IconInfo.szFilename, OpenName);
           EndDialog(hDlg, IDOK);
           return TRUE;

         case IDCANCEL:
           EndDialog(hDlg, IDCANCEL);
           return TRUE;
      }
      return TRUE;
  }

  return FALSE;
}


/****************************************************************************/
/*                                                                          */
/* Function :  About                                                        */
/*                                                                          */
/* Purpose  :  Dialog box proc for the about box.                           */
/*                                                                          */
/* Returns  : TRUE if we processed the message, FALSE if not.               */
/*                                                                          */
/****************************************************************************/
BOOL FAR PASCAL About(HWND hDlg, unsigned message, WORD wParam, LONG lParam)
{
  switch (message)
  {
    case WM_INITDIALOG:
      return TRUE;

    case WM_COMMAND:
      if (wParam == IDOK)
      {
        EndDialog(hDlg, TRUE);
        return TRUE;
      }
      break;
  }
  return FALSE;
}


