@echo off
echo .
echo This batch file is a sample of how you can rename a user object.
echo .
goto end

@echo off
echo  .
echo  Purpose:  Rename an existing User object name to a new object name.
echo  .
echo  .             = Description =       = Type =         = Sample =
echo  Parameter: 1  Old network name      common           dsmith
echo  Parameter: 2  New network name      common           djones
echo  Parameter: 3  Default container     distinguished    mercury.hq.dart
echo  Parameter: 4  Default server        common           mercury
echo  .
echo  Note:  if the sample does not have a leading period (.) then don't
echo  use one.  (use exactly the same syntax.)
echo  .

if [%1] == [] goto end
if [%2] == [] goto error
if [%3] == [] goto error
if [%4] == [] goto error

Rem  If user object does not exist then 'error' out.
n4object %1 "/c=user" /i
if errorlevel 1 goto error

Rem  If user object does exist then 'error' out.
n4object %2 "/c=user" /i
if not errorlevel 1 goto error

Rem  If server object does not exist then 'error' out.
n4object %4 "/c=ncp server" /i
if errorlevel 1 goto error

echo  .  Press anykey to start the 'add' or else CTRL-C
pause

rem  Log the command parameter used to help in later debugging.
nlogmsg h:\ren-me.log "%1 %2 %3 %4"

@echo on

map i:=%4/sys:
map j:=%4/vol1:
if not exist i:\public\*.* goto error

I:
CD\

Rem  Rename the NDS object to the new network name.

n4objmgr rename %1.%3 %2

:loop
n4object %2.%3 /i
if errorlevel 1 pause
if errorlevel 1 goto loop

Rem  Rename the user's L: (personal) drive subdirectory

I:
cd\
cd I:\usr
rendir %1 %2

Rem  Rename the user's Email (MHS) directory

I:
cd\
cd I:\mhs\mail\users
rendir %1 %2

h:
cd\

goto exit

:error
@echo off
echo  Error occurred!

:exit

rem  To 'authenticate' to Venus for Office Logic.
map k:=venus/sys:

@echo off
echo .
echo Ok, now, you will need to:
echo RCONSOLE to server IO, 
echo     Load NGMAdmin
echo     Delete the old network name from the correct Passive server.
echo     Add the new network name user to the correct Passive server.
echo LOGIC GLOBAL /SE
echo     Replace the old name with the new network name.
echo .

h:
cd \logic

:end
