
/****************************************************************************
*   Function:    int sockwn(int fd, char *ptr, int nbytes)                  *
*   Operation:   to write n bytes to the socket fd                          *
*   Returns:     the number of bytes written, or -1 for error               *
*   Parameters:  fd, socket file descriptor                                 *
*                ptr, address of character array to write                   *
*                nbytes, the actual number of bytes from array to write     *
****************************************************************************/

extern int errno;

# include <io.h>
#include <time.h>

int sockwn(fd, ptr, nbytes)
  register int fd;
  register char *ptr;
  register int nbytes;
{
  int nleft, nwritten;
  long itimer, ctimer;

  nleft = nbytes;
  while (nleft > 0) {
    time(&itimer);	/* Reset initial timer */
timingit:
    nwritten = write(fd, ptr, nleft);
    if (nwritten < 0) {
      if (errno == 35) {
	time(&ctimer);	/* Reset current timer */
	if (ctimer > itimer + 5) {	/* Too long? */
	  return (-1);
	} else {
	  goto timingit;	/* else...  */
	}
      } else {
	return (-1);	/* Real error! */
      }
    }
    nleft -= nwritten;
    ptr += nwritten;
  }
  return (nbytes - nleft);
}
