/********************************************************************/
/*   SPAWNO v2.0      XMS/disk swapping replacement for spawn...()  */
/*   (c) Copyright 1990 Ralf Brown  All Rights Reserved 	    */
/*								    */
/*   May be freely copied provided that this copyright notice is    */
/*   not altered or removed.					    */
/********************************************************************/

#include "spawno.h"
#include <alloc.h>
#include <errno.h>

extern int errno ;
extern char *__spawn_env ;
char * pascal __spawn_search(const char *) ;
int pascal __spawn_buildenv(const char **) ;

int _Cdecl spawnlpeo(const char *overlay_path,const char *prog_name,...)
{
   char *prog_path = __spawn_search(prog_name) ;
   int retval ;
   void *env ;

   if (prog_path)
      {
      va_start((void *)env,1) ;
      while (*((char *)env))  /* find NULL terminating list of program args */
	 va_arg(env,void *) ;
      va_arg(env,void *) ;    /* point at pointer to list of env variables */
      retval = __spawnv(overlay_path,prog_path,_va_ptr,__spawn_buildenv(*(char ***)env)) ;
      va_end(env) ;
      free(__spawn_env) ;
      return retval ;
      }
   else
      {
      errno = ENOENT ;	/* not found-- _doserrno was set by __spawn_search() */
      return -1 ;
      }
}

