!	SZ -- print the sizes of X.OUT executables.
!	Copyright (C) 1998,2000 Nils M Holm
!	See the file LICENSE for conditions of use.

#r5;

interface	readpacked(3) = 11;

const	XHMAGIC = 0, XLMAGIC = 1, XFLAGS = 2, XLTEXT = 3, XLDATA = 4,
	XLBSS = 5, XLSYM = 6, XHDR = 8;

const	EXECMAGIC_HI=	6514,
	EXECMAGIC_LO=	1060;


error(msg) do
	select(1,2);
	writes("SZ: error: ");
	writes(msg);
	newline();
	halt;
end


writek(a, b, c) do
	ie ((a>>2) + (b>>2) + (c>>2) + 3 >= 8192) do
		writes(ntoa((a>>10) + (b>>10) + (c>>10), 0));
		writes("K");
	end
	else do
		writes(ntoa(a+b+c, 0));
	end
end


do
	var	buf::XHDR*2, hdr[XHDR];
	var	i;

	if (readpacked(0, buf, XHDR*2) \= XHDR*2) 
		error("short header");
	for (i=0, XHDR)
		hdr[i] := buf::(i*2+1)<<8 | buf::(i*2);
	if (hdr[XHMAGIC] \= EXECMAGIC_HI \/ hdr[XLMAGIC] \= EXECMAGIC_LO)
		error("magic match failed");
	writes("text="); writes(ntoa(hdr[XLTEXT], 0));
	writes(" data="); writes(ntoa(hdr[XLDATA], 0));
	writes(" bss="); writes(ntoa(hdr[XLBSS], 0));
	writes(" sym="); writes(ntoa(hdr[XLSYM], 0));
	writes(" size="); writek(hdr[XLTEXT], hdr[XLDATA], hdr[XLBSS]);
	newline();
end
