/*
 *	MKVFONT -- create vector font files from VF descriptions.
 *	Copyright (C) 1995 Nils M. Holm
 */

#ifdef plan9
#include <u.h>
#include <libc.h>
void exit(r) {
	exits(r? "mkvfont": 0);
}
#else
#define exits	return
#include <stdlib.h>
#endif
#include <stdio.h>

#include "gfx.h"


int main(argc, argv)
int	argc;
char	**argv;
{
	FILE	*in, *out;
	int	i, j, k, buf[256], c, x, y;
	char	ignore[256];

	if (argc != 5) {
		fprintf(stderr, "Usage: mkvfont x y VFD-file VF-file\n");
		exit(1);
	}

	x = atoi(argv[1]);
	y = atoi(argv[2]);

	if ((in = fopen(argv[3], "r")) == NULL) {
		fprintf(stderr, "mkvfont: %s: cannot open\n", argv[1]);
		exit(1);
	}

	if ((out = fopen(argv[4], "wb")) == NULL) {
		fprintf(stderr, "mkvfont: %s: cannot create\n", argv[2]);
		exit(1);
	}

	fprintf(out, GFX_MAGIC);
	fprintf(out, "%c%c", (uchar) x, (uchar) y);

	for (i=32; i<128; i++) {
		while ((c = getc(in)) == ';' || c == '\n') {
			fgets(ignore, 256, in);
		}
		if (feof(in)) break;
		fscanf(in, "\n%d", &buf[0]);
		for (j=0; j<buf[0]; j++) {
			fscanf(in, "\n %d", &k);
			buf[j+1] = (k >= 100)? 0x80: 0;
			if (k>=100) k -= 100;
			buf[j+1] |= ((k/10)<<4);
			while (k>=10) k -= 10;
			buf[j+1] |= k;
		}
		for (k=0; k<=j; k++) {
			fprintf(out, "%c", buf[k]);
		}
	}

	fclose(in);
	fclose(out);

	exits(0);
}
