;;------------------------------------------------
;;
;;	Fast Video Routines for DOS
;;	Copyright (C) 1995 Nils M. Holm
;;	Modified for use with T3X, 1997.
;;	See LICENSE for conditions of use.
;;
;;------------------------------------------------


		.MODEL	LARGE


		.DATA

		PUBLIC	_vio_base, _vio_cols, _vio_lines, _vio_x, _vio_y
		PUBLIC _vio_attr

_vio_base	DW	?
_vio_cols	DW	?
_vio_lines	DW	?
_vio_x		DW	?
_vio_y		DW	?
_vio_attr	DW	?


		.CODE

		PUBLIC	_vio_init, _vio_move, _vio_sync, _vio_color,
		PUBLIC	_vio_putc, _vio_puts, _vio_clear, _vio_clreol,
		PUBLIC	_vio_index, _vio_revind, _vio_getc, _vio_sync
		PUBLIC	_vio_mono, _vio_query, _vio_reinit, _vio_end


vio_addr:
		mov	ax,_vio_y
		mov	cx,_vio_cols
		shl	cx,1
		mul	cx
		mov	di,_vio_x
		shl	di,1
		add	di,ax
		ret


PROC _vio_init
		push	bp
		push	si
		push	di
		xor	ax,ax
		mov	_vio_cols,80
		mov	_vio_lines,25
		mov	_vio_x,ax
		mov	_vio_y,ax
		mov	_vio_attr,0700h
		mov	ax,0f00h
		int	10h
		cmp	al,7
		jz	ismono
		mov	_vio_base,0b800h
		cmp	al,26h
		jz	is80x60
		cmp	al,2
		jae	isega
		mov	_vio_cols,40
		jmp	endinit
is80x60:	mov	_vio_lines,60
		jmp	endinit
isega:		push	es
		xor	ax,ax
		mov	es,ax
		mov	al,es:[0484h]
		xor	ah,ah
		inc	ax
		mov	_vio_lines,ax
		pop	es
		jmp	endinit
ismono:		mov	_vio_base,0b000h
endinit:	pop	di
		pop	si
		pop	bp
		ret
		ENDP


PROC _vio_end
		ret
		ENDP


PROC _vio_reinit
		ret
		ENDP


PROC _vio_mono
		mov	ax,0f00h
		int	10h
		cmp	al,2
		jz	mono
		cmp	al,7
		jz	mono
		xor	ax,ax
		ret
mono:		mov	ax,1
		ret
		ENDP


PROC _vio_move
		push	bp
		mov	bp,sp
		mov	ax,[bp+6]
		mov	_vio_x,ax
		mov	ax,[bp+8]
		mov	_vio_y,ax
		pop	bp
		ret
		ENDP


PROC _vio_sync
		push	bp
		push	si
		push	di
		mov	ax,0200h
		xor	bx,bx
		mov	dx,_vio_x
		mov	cx,_vio_y
		xchg	cl,ch
		or	dx,cx
		int	10h
		pop	di
		pop	si
		pop	bp
		ret
		ENDP


PROC _vio_color
		push	bp
		mov	bp,sp
		mov	ax,[bp+6]
		xchg	al,ah
		mov	_vio_attr,ax
		pop	bp
		ret
		ENDP


int_putc:
		cmp	al,08h
		jnz	nobs
		cmp	_vio_x,0
		jz	endputc
		dec	_vio_x
		sub	di,2
		ret
nobs:		cmp	al,09h
		jnz	notab
		push	ax
		mov	al,20h
dotab:		call	int_putc
		test	_vio_x,07h
		jnz	dotab
		pop	ax
		sub	di,2
		ret
notab:		cmp	al,0Ah
		jnz	nolf
		inc	_vio_y
		call	vio_addr
		ret
nolf:		cmp	al,0Dh
		jnz	nocr
		mov	_vio_x,0
		call	vio_addr
		ret
nocr:		mov	es:[di],ax
		inc	_vio_x
		add	di,2
		mov	cx,_vio_x
		cmp	cx,_vio_cols
		jb	endputc
		mov	_vio_x,0
		inc	_vio_y
		push	ax
		call	vio_addr
		pop	ax
endputc:
		ret


PROC _vio_putc
		push	bp
		mov	bp,sp
		push	si
		push	es
		mov	ax,_vio_base
		mov	es,ax
		call	vio_addr
		mov	ax,[bp+6]
		or	ax,_vio_attr
		call	int_putc
		pop	es
		pop	si
		pop	bp
		ret
		ENDP


PROC _vio_puts
		push	bp
		mov	bp,sp
		push	si
		push	di
		push	es
		mov	ax,_vio_base
		mov	es,ax
		call	vio_addr
		mov	ax,_vio_attr
		mov	si,[bp+6]
		cld
nextps:		push	es
		mov	es,[bp+8]
		mov	al,es:[si]
		inc	si
		pop	es
		or	al,al
		jz	endps
		call	int_putc
		jmp	nextps
endps:
		pop	es
		pop	di
		pop	si
		pop	bp
		ret
		ENDP


PROC _vio_clear
		push	bp
		push	si
		push	di
		mov	ax,0600h
		xor	cx,cx
		mov	dx,_vio_lines
		mov	dh,dl
		or	dx,_vio_cols
		sub	dx,0101h
		mov	bx,_vio_attr
		int	10h
		xor	ax,ax
		mov	_vio_x,ax
		mov	_vio_y,ax
		pop	di
		pop	si
		pop	bp
		ret
		ENDP


PROC _vio_clreol
		push	bp
		push	si
		push	di
		push	es
		mov	ax,_vio_base
		mov	es,ax
		call	vio_addr
		mov	ax,32
		or	ax,_vio_attr
		mov	cx,_vio_cols
		sub	cx,_vio_x
		jz	endcl
		cld
doclr:		stosw
		loop	doclr
endcl:		pop	es
		pop	di
		pop	si
		pop	bp
		ret
		ENDP


PROC _vio_index
		push	bp
		mov	bp,sp
		push	si
		push	di
		mov	ax,0601h
		mov	ch,[bp+6]
		xor	cl,cl
		mov	dh,[bp+8]
		mov	dl,4fh
		mov	bx,_vio_attr
		int	10h
		pop	di
		pop	si
		pop	bp
		ret
		ENDP


PROC _vio_revind
		push	bp
		mov	bp,sp
		push	si
		push	di
		mov	ax,0701h
		mov	ch,[bp+6]
		xor	cl,cl
		mov	dh,[bp+8]
		mov	dl,4fh
		mov	bx,_vio_attr
		int	10h
		pop	di
		pop	si
		pop	bp
		ret
		ENDP


PROC _vio_getc
		push	bp
		push	si
		push	di
		xor	ax,ax
		int	16h
		or	al,al
		jz	isext
		xor	ah,ah
		jmp	retch
isext:		xchg	al,ah
		or	ax,100h
retch:		pop	di
		pop	si
		pop	bp
		ret
		ENDP


PROC _vio_query
		mov	ax,0100h
		int	16h
		jz	none
		xor	ax,ax
		dec	ax
		ret
none:		xor	ax,ax
		ret
		ENDP


		END

