#!/bin/sh

PREP=no

rm -f TXTRN.ERR TXCG.ERR TXPP.ERR

if [ x$1 = x-P ]; then
	PREP=yes
	shift
fi

if [ x$1 = x ]; then
	echo "Usage: tc file"
	exit 1
fi

name=`basename $1 .t`

if [ -e ${name}.s ]; then
	echo "tc: preserving file: ${name}.s"
	exit 1
fi

if [ x$PREP = xyes ]; then
	../compiler/txpp <$1 >${name}.tpp
	if [ -f TXTRN.ERR ]; then rm TXTRN.ERR ${name}.tpp; exit; fi
	../compiler/txx ../build/txtrn.tcode <${name}.tpp >${name}.tcode
	rm ${name}.tpp
else
	../compiler/txx ../build/txtrn.tcode <$1 >${name}.tcode
fi
if [ -f TXTRN.ERR ]; then rm TXTRN.ERR ${name}.tcode; exit; fi
../compiler/txx ../build/txcg386.tcode <${name}.tcode >${name}.s
if [ -f TXCG.ERR ]; then rm TXCG.ERR ${name}.s; exit; fi
rm ${name}.tcode
if [ $? != 0 ]; then
	echo "tc: error in compilation"
	exit 1
fi

as -o ${name}.o ${name}.s
X=$?
rm ${name}.s
if [ $X != 0 ]; then exit; fi

ld -o ${name} ${name}.o ../native/libtx.a /usr/lib/libc.a 
rm ${name}.o
strip ${name}
