/****************************************************************************
*
*						  Protected Mode Library
*
*                   Copyright (C) 1994 SciTech Software.
*							All rights reserved.
*
* Filename:		$RCSfile: memtest.c $
* Version:		$Revision: 1.1 $
*
* Language:		ANSI C
* Environment:	any
*
* Description:	Test program to determine just how much memory can be
*				allocated with the compiler in use. Compile and link
*				with the appropriate command line for your DOS extender.
*
*				Functions tested:	malloc()
*
* $Id: memtest.c 1.1 1994/03/10 09:05:43 kjb release $
*
****************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <conio.h>
#include "pmode.h"

void main(void)
{
	char *p;
	unsigned long allocs;

	printf("Program running in ");
	switch (_PMODE_modeType) {
		case PMODE_realMode:
			printf("real mode.\n\n");
			break;
		case PMODE_286:
			printf("16 bit protected mode.\n\n");
			break;
		case PMODE_386:
			printf("32 bit protected mode.\n\n");
			break;
        }

	for (allocs = 0; ; allocs++) {
		if ((p = malloc(1024)) != 0) {			/* in 1k blocks */
			memset(p, 0, 1024); /* touch every byte 			*/
			*p = 'x';           /* do something, anything with	*/
			p[1023] = 'y';      /* the allocated memory      	*/

			printf("Allocated %lu bytes\r", allocs << 10);
            }
		else
			break;
        if (kbhit() && (getch() == 0x1B))
            break;
		}

    printf("\n\nAllocated total of %lu bytes\n", allocs << 10);
}
