/*
 * MultiMail offline mail reader
 * resource class

 Copyright (c) 1996 Toth Istvan <stoty@vma.bme.hu>
 Copyright (c) 1998 William McBrine <wmcbrine@clark.net>

 Distributed under the GNU General Public License.
 For details, see the file COPYING in the parent directory. */

#ifndef RESOURCE_H
#define RESOURCE_H

#include <stdio.h>

const int	homeDir = 0,
		mmHomeDir = 1,
		PacketDir = 2,
		WorkDir = 3,
		UncompressCommand = 4,
		PacketName = 5,
		UserName = 6,
		BBSName = 7,
		SysOpName = 8,
		ReplyDir = 9,
		LoginName = 10,
		AliasName = 11,	
		CompressCommand = 12,
		UpWorkDir = 13,
		editor = 14,
		SaveDir = 15,
		AddressFile = 16,
		TaglineFile = 17,
		arjUncompressCommand = 18,
		zipUncompressCommand = 19,
		lhaUncompressCommand = 20,
		unknownUncompressCommand = 21,
		arjCompressCommand = 22,
		zipCompressCommand = 23,
		lhaCompressCommand = 24,
		unknownCompressCommand = 25,
		qwkBBSID = 26,
		sigFile = 27,
		oldPacketName = 28,
		noOfResources = oldPacketName + 1;

class resource
{
	char basedir[256];

	struct resource_struct {
		char *value;
		int  val;
	} resourceData[noOfResources];

	void mmEachInit(int, const char *);
	void subPath(int, const char *);
	void initinit();
	void mmHomeInit();
	void parseConfig(FILE *);
	const char *fixPath(const char *);
	int checkPath(const char *, int);
	int taglineCheck();
	int verifyPaths();
	int createNewConfig(const char *);
 public:
	resource();
	~resource();
	const char *get(int);
	void set(int, const char *);

	int getValue(int);
	void setValue(int, int);
};
	  
#endif
