/*
 * MultiMail offline mail reader
 * most class definitions for the interface

 Copyright (c) 1996 Kolossvary Tamas <thomas@tvnet.hu>
 Copyright (c) 1997 John Zero <john@graphisoft.hu>
 Copyright (c) 1998 William McBrine <wmcbrine@clark.net>

 Distributed under the GNU General Public License.
 For details, see the file COPYING in the parent directory. */

#ifndef INTERFACE_H
#define INTERFACE_H

#define USE_SHADOWS	// "Shadowed" windows

#include "../mmail/mmail.h"

extern "C" {
#include <signal.h>
#include CURS_INC
}

#include "mmcolor.h"

enum direction {UP, DOWN, PGUP, PGDN, HOME, END};
enum statetype {packetlist, arealist, threadlist, letterlist, letter, 
		 letter_help, littlearealist};

#ifdef SIGWINCH
extern void sigwinchHandler(int);
#endif

extern int isoconvert;	// ISO8859-1 <--> CP437 (DOS) conversion?

#define TAGLINE_LENGTH 76

class tagline
{
 public:
 	tagline();
 	tagline *next;
 	char text[TAGLINE_LENGTH + 1];
};

class ShadowedWin
{
	WINDOW *shadow;
 public:
	WINDOW *win;

	ShadowedWin(int, int, int, int, chtype, int = 0);
	~ShadowedWin();
	void touch();
	int getstring(int, int, char *, int, int, int);
};

class InfoWin : public ShadowedWin
{
 public:
	WINDOW *info;

	InfoWin(int, int, int, int, chtype, int = 0, int = 3, int = 2);
	~InfoWin();
	void touch();
};

class ListWindow
{
 protected:
	InfoWin *list;
  	int list_max_y, list_max_x;
	int position;	//the first element in the window
	int active;	//this is the highlited	
	int oldPos;	//position at last Draw()
	int oldActive;	//active at last Draw()

	void checkPos(int);
	virtual int NumOfItems() {return 0;};
	virtual void oneLine(int) {};
 public:
 	ListWindow();
	void Draw();		//refreshes the window
	virtual void ReDraw();	//apply touchwin on the windoz
	void Move(direction);	//scrolloz
	void ForceRedraw();
};

class Interface
{
	WINDOW *screen;
	ListWindow *currList;
 	statetype state;	
	char Key;
	int unsaved_reply, any_read;

	void init_colors();
	void screen_init();
 	void select();
	void reedit();
	void addressbook();
	void kill_letter();
	void kill_packet();
	void kill();
	void redraw();
 	void search();
	void save();
	void help();
	void ReplyPacket();  		//warns & call create_reply_packet
	void create_reply_packet();	//do the job
	void enterletter(int);
#ifdef SIGWINCH
	void resize();
#endif
 public:
 	Interface();
	~Interface();
	ListWindow *activeList();
	void screentouch();
	int WarningWindow(const char *, const char *, const char *);
 	int back();		//returns 1 if we have to quit the program
	void RIGHT_ARROW();
 	void LEFT_ARROW();
	void ikeypad(direction); //handle various keypad keys
	statetype active();
	void KeyHandle();
#ifdef SIGWINCH
	void sigwinch();
#endif
};

class Welcome
{
 	ShadowedWin *window;
 public:
 	void MakeActive();
 	void Delete();
	void ReDraw();
};

class Person
{
 public:
 	Person *next;
 	char name[30];
 	net_address netmail_addr;

	Person();
};

class AddressBook : public ListWindow
{
	Person *highlighted, **people;
	int NumOfPersons, keyEnd;

	void AddressFromLetter();
	void oneLine(int);
	void ReDraw();
  	int NumOfItems();
 	void ReadFile();
 	void DestroyChain();
 	void SetLetterThings();
 public:
	AddressBook();
	void MakeActive(int = 0);
#ifdef SIGWINCH
	void sigwinch();
#endif
};

class TaglineWindow : public ListWindow
{
  	int nodraw, NumOfTaglines, keyEnd;
	tagline head;

	void ReadFile();
	void DestroyChain();
	void oneLine(int);
	void ReDraw();
	void RandomTagline();
 	int NumOfItems();
  	const char *getTextOf(int); 
 public:
 	TaglineWindow(int = 0);
 	virtual ~TaglineWindow();
 	void EnterTagline(char * = NULL);
#ifdef SIGWINCH
	void sigwinch();
#endif
};

class LittleAreaListWindow : public ListWindow
{
 	char key;
	int disp;

	void oneLine(int);
 public:
 	LittleAreaListWindow(char);
 	virtual ~LittleAreaListWindow();
	int NumOfItems();
};

class AreaListWindow : public ListWindow
{
 	ShadowedWin *info;
	int mode;
	char format[40], format2[40], *lineBuf;

	void oneLine(int);
 public:
	void ResetActive();
 	void MakeActive();
 	void Delete();
	void Select();
	void ReDraw();
	void FirstUnread();
 	int NumOfItems();
};

class PacketListWindow : public ListWindow
{
	void oneLine(int);
 public:
	PacketListWindow();
	virtual ~PacketListWindow();
 	void MakeActive();
 	void Delete();
	void Select();
	void ReList();
	int NumOfItems();
};

class LetterListWindow : public ListWindow
{
	char format[40], *lineBuf;

	void oneLine(int);
 public:
	void MakeActive();
	void Delete();
	void Select();
	void FirstUnread();
	void NextUnread();
	void PrevUnread();
	int NumOfItems();
};

class Line
{
 public:
	Line *next;
	char *text;
	unsigned length;

 	Line(int);
	~Line();
};

class LetterWindow
{
 	WINDOW *header, *text, *statbar;
 	Line **linelist;
	char key, tagline[82], To[30];
 	int letter_in_chain;	//0 = no letter in chain
	int position;		//which row is the first in the text window
	int NumOfLines;
	int dont_inc_pos;
	int x, y;		//dimensions of the window, set by MakeActive
	int replyto_area;
	net_address NM;

	void lineCount();
	void oneLine(int);
	void netAdd(char *);
	int HeaderLine(ShadowedWin *, char *, int, int, int);
	int EnterHeader(char *, char *, char *, int *);
	void QuoteText(const char *);
	void DestroyChain();
	void editletter(const char *);
	long reconvert(const char *);
	void write_to_file(FILE *);
 public:
 	void MakeActive();
 	void Delete();
	void MakeChain(int);
 	void Draw();
 	void DrawHeader();
 	void DrawBody();
	void ReDraw();
	void Next();
	void Previous();
	void Move(direction);
	void NextDown();
	void Save(int);
	int EnterLetter();
	void StatToggle(int);
	net_address PickNetAddr();
	void ansi_dump();
	void set_Letter_Params(int, char);
	void set_Letter_Params(net_address *, const char *);
	void set_Tagline(const char *);
	void GetTagline();
	int EditLetter();
};

class HelpWindow
{
 	WINDOW *menu;
	ShadowedWin *menu2;
	int active;
 public:
	HelpWindow();
	void newHelpMenu();
	void packetlist();
 	void arealist();
 	void threadlist();
 	void letterlist();
 	void reply_area_letterlist();
 	void letter();
 	void reply_area_letter();
 	void Delete();
 	void redraw();
};

class AnsiLine
{
 private:
	AnsiLine *next;
	AnsiLine *prev;
 public:
	AnsiLine *getnext(int = 0);
	AnsiLine *getprev();
	chtype *text;
	unsigned length;
 	AnsiLine(int = 0, AnsiLine * = NULL);
	~AnsiLine();
};

class AnsiWindow
{
	int colorsused[64];
	char escparm[256];	//temp copy of ESC sequence parameters
	const char *title;
	unsigned char *source;
 	WINDOW *header, *text, *statbar, *animtext;
 	AnsiLine *head, *curr, **linelist;
	int position;		//which row is the first in the window
	int NumOfLines;
	int x, y;		//dimensions of the window
	int cpx, cpy, lpy;	//ANSI positions
	int spx, spy;		//stored ANSI positions
	int ccf, ccb, cfl, cbr, crv;	//colors and attributes
	int oldcolorx, oldcolory;
	int anim;		//animate mode?
	int ansiAbort;
	chtype attrib;		//current attribute

	void Clear(WINDOW *);
	void Scroll(WINDOW *, int);
 	void Draw();
 	void DrawHeader();
	void oneLine(int);
 	void DrawBody();
	void ReDraw();
	void Move(direction);
	int getparm();
	void colreset();
	void colorset();
	unsigned char *escfig(unsigned char *);
	void posreset();
	void checkpos();
	void update(unsigned char);
	void ResetChain();
	void MakeChain(unsigned char *);
	void DestroyChain();
	void animate();
	void statupdate();
 public:
	AnsiWindow(unsigned char *, const char *);
	~AnsiWindow();
	void KeyHandle();
#ifdef SIGWINCH
	void sigwinch();
#endif
};

#ifdef SIGWINCH
extern AnsiWindow *currAnsi;
extern AddressBook *currAddr;
extern TaglineWindow *currTagw;
#endif

#endif
