/*

   CMDLINE.H

   (c) 1995 Oliver Kraus
*/

#ifndef _CMDLINE_H
#define _CMDLINE_H

#ifdef _MSC_VER
#pragma warning(disable:4131)
#ifndef DO_PROTO
#define DO_PROTO
#endif
#endif

#include <stdlib.h>
#ifndef _MAX_PATH
#define _MAX_PATH 1024
#endif

#define CL_ERR_STRING "\1"

#define CL_TYP_NONE   0
#define CL_TYP_ON     1
#define CL_TYP_OFF    2
#define CL_TYP_LONG   3
#define CL_TYP_PATH   4
#define CL_TYP_STRING 5
#define CL_TYP_SET    6

#define CL_ENTRY_LAST { CL_TYP_NONE, NULL, NULL, 0 }

struct _cl_entry_struct
{
   int typ;
   char *name;
   void *var_ptr;
   size_t var_size;
};
typedef struct _cl_entry_struct cl_entry_struct;

#define CL_FILE_MAX 8

extern char cl_file_list[CL_FILE_MAX][_MAX_PATH];
extern int cl_file_cnt;

#ifdef DO_PROTO
int cl_Do(cl_entry_struct *list, int argc, char *argv[]);
int cl_String(cl_entry_struct *list, char *s);
#else
extern int cl_Do();
extern int cl_String();
#endif

#endif
