/*****************************************************************************
*   "Irit" - the 3d polygonal solid modeller.				     *
*									     *
* Written by:  Gershon Elber				Ver 0.2, Mar. 1990   *
******************************************************************************
*   General, visible to others, definitions of Objects module.		     *
*****************************************************************************/

/*****************************************************************************
*   Prototype for visible function in the Objects module.		     *
*****************************************************************************/

#ifndef	OBJECTS_H
#define	OBJECTS_H

void SetUpPredefObjects(void);
ObjectStruct *GetNthList(ObjectStruct *ListObj, RealType *Rn);
ObjectStruct *AppendLists(ObjectStruct *ListObj1, ObjectStruct *ListObj2);
void SnocList(ObjectStruct *PObj, ObjectStruct *ListObj);
ObjectStruct *GetObject(char *ObjName);
void FreeObject(ObjectStruct *PObj);
void DeleteObject(ObjectStruct *PObj, int Free);
void InsertObject(ObjectStruct *PObj);
void PrintObject(ObjectStruct *PObj);
void PrintObjectList(ObjectStruct *PObj);
ObjectStruct *GenPolyObject(char *Name, PolygonStruct *Pl, ObjectStruct *Pnext);
ObjectStruct *GenCrvObject(char *Name, CagdCrvStruct *Crv, ObjectStruct *Pnext);
ObjectStruct *GenSrfObject(char *Name, CagdSrfStruct *Srf, ObjectStruct *Pnext);
ObjectStruct *GenCtlPtObject(char *Name, CagdPointType PtType,
		CagdRType *CagdCoords, RealType *Coords, ObjectStruct *Pnext);
ObjectStruct *GenNumObject(char *Name, RealType *R, ObjectStruct *Pnext);
ObjectStruct *GenVecObject(char *Name, RealType *Vec0, RealType *Vec1,
					RealType *Vec2, ObjectStruct *Pnext);
ObjectStruct *GenMatObject(char *Name, MatrixType Mat, ObjectStruct *Pnext);
ObjectStruct *CopyObject(ObjectStruct *Dest, ObjectStruct *Src,	int CopyAll);
VertexStruct *CopyVList(VertexStruct *Src);
PolygonStruct *CopyPolygonList(PolygonStruct *Src);

#endif	/* OBJECTS_H */

