/******************************************************************************
* CagdBbox.c - Handle freeform cuves and surfaces bounding boxes.	      *
*******************************************************************************
* Written by Gershon Elber, Jan. 92.					      *
******************************************************************************/

#include "cagd_loc.h"

static void CagdPointsBBox(CagdRType **Points, int Length, CagdBBoxStruct *BBox);

/******************************************************************************
* Computes a bounding box around a freeform curve.			      *
******************************************************************************/
void CagdCrvBBox(CagdCrvStruct *Crv, CagdBBoxStruct *BBox)
{
    CagdCrvStruct
	*E3Crv = CagdCoerceCrvTo(Crv, CAGD_PT_E3_TYPE);
    int Length = E3Crv -> Length;
    CagdRType
	**Points = E3Crv -> Points;

    CagdPointsBBox(Points, Length, BBox);

    CagdCrvFree(E3Crv);
}

/******************************************************************************
* Computes a bounding box around a freeform surface.			      *
******************************************************************************/
void CagdSrfBBox(CagdSrfStruct *Srf, CagdBBoxStruct *BBox)
{
    CagdSrfStruct
	*E3Srf = CagdCoerceSrfTo(Srf, CAGD_PT_E3_TYPE);
    int Length = E3Srf -> ULength * E3Srf -> VLength;
    CagdRType
	**Points = E3Srf -> Points;

    CagdPointsBBox(Points, Length, BBox);

    CagdSrfFree(E3Srf);
}

/******************************************************************************
* Computes a bounding box around a freeform surface.			      *
******************************************************************************/
static void CagdPointsBBox(CagdRType **Points, int Length, CagdBBoxStruct *BBox)
{
    int i;

    BBox -> Min[0] = BBox -> Min[1] = BBox -> Min[2] = INFINITY;
    BBox -> Max[0] = BBox -> Max[1] = BBox -> Max[2] = -INFINITY;

    for (i = 0; i < Length; i++) {
	if (BBox -> Min[0] > Points[X][i])
	    BBox -> Min[0] = Points[X][i];
	if (BBox -> Min[1] > Points[Y][i])
	    BBox -> Min[1] = Points[Y][i];
	if (BBox -> Min[2] > Points[Z][i])
	    BBox -> Min[2] = Points[Z][i];

	if (BBox -> Max[0] < Points[X][i])
	    BBox -> Max[0] = Points[X][i];
	if (BBox -> Max[1] < Points[Y][i])
	    BBox -> Max[1] = Points[Y][i];
	if (BBox -> Max[2] < Points[Z][i])
	    BBox -> Max[2] = Points[Z][i];
    }
}

/******************************************************************************
* Merge (union) two bounding boxes into one.				      *
******************************************************************************/
void CagdMergeBBox(CagdBBoxStruct *DestBBox, CagdBBoxStruct *SrcBBox)
{
    int i;

    for (i = 0; i < 3; i++) {
	if (DestBBox -> Min[0] > SrcBBox -> Min[i])
	    DestBBox -> Min[0] = SrcBBox -> Min[i];
	if (DestBBox -> Max[0] < SrcBBox -> Max[i])
	    DestBBox -> Max[0] = SrcBBox -> Max[i];
    }
}

