int14	equ	1	; comment out to remove int14 routines
codeseg	segment para public 'CODE'
dataseg	segment para public 'DATA'
	extrn	_PSP_:word, $MEMRY:word
	old_com_int	dd 0
dataseg	ends
	public old_vector_,myds
old_vector_	label word
old_vector	dd	0
myds	dw	0

assume cs:codeseg,ds:dataseg
extrn	c_handler_:near
public	setup_int14_,restore_int14_,service
	; service interrupts
service	proc	near
snoop:
	; we've got a call we're worried about
	; push registers in opposite of the order they'll appear as formal
	; parameters to this program
	push	es	; last
	push	ds	;
	push	di	;
	push	si	;
	push	dx	;
	push	cx	;
	push	bx	;
	push	ax	;
	mov	ax,cs:myds
	mov	ds,ax
	mov	es,ax
	sti			; enable interrupts
	call c_handler_
	pop	ax		; restore registers
	pop	bx
	pop	cx
	pop	dx
	pop	si
	pop	di
	pop	ds
	pop	es
	iret		; get outa here
service	endp


ifdef int14
	; set up the interrupt service handler
setup_int14_	proc	near
	push	es
	mov	cs:myds,ds
	nop
	mov	ah,35H
	mov	al,14H							; offset of interrupt service
	int 21H
	mov	word	ptr cs:old_vector,bx
	mov	word	ptr cs:old_vector+2,es
	pop	es
	push	ds
	mov	ax,cs
	mov	ds,ax
	mov	dx,offset service
	mov	ah,25H
	mov	al,14H
	int	21H
	pop	ds
	ret										; done
setup_int14_	endp

restore_int14_	proc	near
	push	ds
	mov	dx,word ptr cs:old_vector
	mov	ax,word ptr cs:old_vector+2
	mov	ds,ax
	mov	ah,25H
	mov	al,14H
	int 21H
	pop	ds
	ret
restore_int14_	endp

	public	call_rom_
call_rom_	proc	near
	push	bp
	mov	bp,sp
	mov	ax,[bp+4]	; get ax parm
	mov	dx,[bp+6]
	mov	cx, word ptr cs:old_vector
	or	cx, word ptr cs:old_vector+2
	jnz chain_call
	int 14
	jmp outahere
chain_call:
	pushf
	call dword ptr cs:old_vector
outahere:
	pop	bp
	ret
call_rom_	endp

	public	terminate_
terminate_	proc	near
	;calculate memory size in paragraphs
	mov		dx,$MEMRY
	add		dx,15		;bump to next even paragraph
	mov		cx,4		;move 4 places right
	shr		dx,cl		;
	mov	ax,_PSP_		; first paragraph of my program allocation
	mov	cx,ds			; current data segment
	sub	cx,ax			; subtract psp from ds to get size of psp
	add	dx,cx			; add to number of paragraphs in data segment
	mov		al,0		;exit code of 0
	mov		ah,31H		;terminate and stay resident
	int		21H			;go do it
	ret					;should never return!!!
terminate_	endp
endif

	; core routines for communications
	
	extrn comserv_:near
comservice	proc	near
	push	es	; last
	push	ds	;
	push	di	;
	push	si	;
	push	dx	;
	push	cx	;
	push	bx	;
	push	ax	;
	mov	ax,cs:myds
	mov	ds,ax
	mov	es,ax
	sti			; enable interrupts
	call comserv_
	pop	ax		; restore registers
	pop	bx
	pop	cx
	pop	dx
	pop	si
	pop	di
	pop	ds
	pop	es
	iret		; get outa here
comservice	endp

	public	setup_comint_
setup_comint_	proc	near
	push	bp
	mov	bp,sp
	push	es		; es used in get vector call
	mov	al,4[bp]	; pick up int num
	mov	ah,35H		; get vector
	int 21H
	; store it away
	mov	word ptr old_com_int,bx
	mov	word ptr old_com_int+2,es
	pop	es			; restore es
	; set up new vector
	mov	ah,25H
	mov	al,4[bp]	; pick up int num again
	push	ds		; ds used in set vector call
	mov	dx,cs		; get segment
	mov	ds,dx		;
	mov	dx,offset comservice	; get offset
	int 21H			; go do it
	pop	ds			; restore ds
	pop	bp
	ret
setup_comint_	endp

	public	restore_comint_
restore_comint_	proc	near
	push	bp
	mov	bp,sp
	push	ds
	lds	dx,old_com_int
	mov	al,4[bp]	; pick up int num
	mov	ah,25H		; set vector
	int 21H
	pop	ds
	pop	bp
	ret
restore_comint_	endp

	public	cli_,sti_
cli_	proc	near
	cli
	ret
cli_	endp

sti_	proc	near
	sti
	ret
sti_	endp

codeseg	ends
	end
