Unit sbtlkgr3;
  { SPEECH OUTPUT UNIT FOR TALKING BALANCE 1 PROGRAM.  USES
    THE CREATIVE LABS SOUND BLASTER SOUND CARD AND THE
    TEXT-TO-SPEECH ENGINE "SBTALKER"; CAN ALSO DRIVE OTHER
    SPEECH DEVICES. }

  { IF YOU WANT TO USE THE CREATIVE LABS SOUND BLASTER SOUND CARD
    AND THE TEXT-TO-SPEECH ENGINE "SBTALKER" YOU MUST USE THIS UNIT. }

  (* If you want to compile the balance program with this unit,
     you must also have the unit SBC_TP7.TPU, which is part of
     the Creative Labs Developer Kit for Turbo Pascal V. 7,
     available from Creative Labs, Inc.

     If you want to compile the balance program without investing
     in a Developer Kit for the Sound Blaster, use unit BalTalk0
     instead of sbtlkgr3.

     The two speech output units behave in identical fashion if
     the SBTalker program has not been loaded before running the
     Talking Balance program.  *)

{Copyright 1992-1996 East Carolina University, Greenville, NC, USA. }
{ Author: David Lunney, Professor of Chemistry, ECU }

(*      ADDRESS: Department of Chemistry
                 East Carolina University
                 Greenville, NC 27858-4353
                 USA


        INQUIRIES REGARDING THIS PROGRAM SHOULD BE DIRECTED
        TO DAVID LUNNEY AT chlunney@ecuvm.cis.ecu.edu OR
        LUNNEY@DELPHI.COM                                            *)


(*  This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    A COPY OF THE GNU GENERAL PUBLIC SOFTWARE LICENSE HAS BEEN
    PROVIDED WITH THIS PROGRAM IN THE FILE "LICENSE.TXT"       *)

    { No Warranty.  EAST CAROLINA UNIVERSITY DISCLAIMS AND MAKES NO
    REPRESENTATIONS AND EXTENDS NO WARRANTIES, EITHER EXPRESS OR
    IMPLIED. THERE ARE NO EXPRESS OR IMPLIED WARRANTIES OF
    MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  The User
    shall assume all liability for all damages whatsoever that may or
    do arise from the User's use, inability to use, performance, or
    storage of SBTLKGR3.  East Carolina University shall not be
    liable to the User for any loss, claims, damages or demands
    whatsoever made by the User or made against the User by any other
    party, due to or arising from the performance of, use of, and/or
    inability to use SBTLKGR3 by the User and/or anyone else. }


{ modified to look for file containing port for
  external synth    dl 7-25-96 }

{ modified to drive an external synth   dl 7-96, 8-96 }

Interface

Uses crt, DOS, sbc_tp7, txtutil4, filutil4, dosfunks;
{ The unit sbc_tp7.tpu is in the Creative Labs Sound Blaster
  Developer Kit for Turbo Pascal V. 7.  To compile the
  Talking Balance 1 program without sbc_tp7.tpu, use speech
  output unit BalTalk0.pas INSTEAD of sbtlkgr3.pas dl 9-6-96  }

{ adapted to write outputs to a port 7-25-96 dl }

(**** global variables ****)

Const
  Control_X: Char = #24;   { Control_X added by dl 10-27-96 }
  ESC: Char = #27;    { added by dl 10-27-96 }
  FlushDelay: word = 200; { delay in ms after flushing synth buffer }

Type
  String4 = String[4];

Var
  NoBlast, NoWrites, TalkToPort, Serial, Parallel, GoodTalkDev,
  TalkReddy, Accent, Flushable, NoParams, BadParams, FlushIt: Boolean;
  FlushChar: Char; { char that flushes buffer on synth; dl 10-28-96 }
  flushstring: String; { string that flushes buffer on synth; dl 10-29-96 }
  talkdev: Text;
  talkdevname: String4;
  OldMode: Word;
  xfil: text; { debug file }

Procedure GetSynthParam2;
Procedure FlushTalkBuffer(wait: word);
Procedure Talkit101(tlkstg: String);
Procedure InitBalTalk(dataport: String4);
Procedure ResetAccent;


Implementation

Procedure FlushTalkBuffer(wait: word);
Begin
  Write(talkdev, flushstring);
  delay(wait); { delay to give synth time to recover }
End;

Procedure SetParmVars;
Begin
  BadParams := False;
  NoParams := False;
  flushable := True;
  flushstring := flushchar;
End;

Procedure GetSynthParam2;
Var
  i, len, flushbyte: Byte;
  parmstring: String;
  fchar, tstchar: Char;

Begin
  Accent := False;
  Flushable := False;
  NoParams := True;
  BadParams := False;
  If ParamCount = 0 Then Exit;
  parmstring := ParamStr(1);
  If ParamCount > 1 Then
    For i := 2 To ParamCount Do  parmstring := parmstring + ParamStr(i);

  { get rid of brackets }
  If Pos('[', parmstring) > 0 Then EatChar('[', parmstring);
  If Pos(']', parmstring) > 0 Then EatChar(']', parmstring);

  len := Length(parmstring);
  tstchar := parmstring[1];

  If len = 1 Then
  Begin
    AllCaps(parmstring);
    fchar := parmstring[1];
    flushbyte := Ord(fchar) - 64;
    FlushChar := Chr(flushbyte);
    SetParmVars;
    Exit;
  End;

  If UpCase(tstchar) = 'A' Then
  Begin
    AllCaps(parmstring);
    If Pos('ACC', parmstring) > 0 Then
    Begin
      Accent := True;
      flushchar := Control_X;
      SetParmVars;
      Exit;
    End;
  End;

  If UpCase(tstchar) = 'C' Then
  Begin
    AllCaps(parmstring);
    If Pos('CTRL', parmstring) > 0 Then
    Begin
      fchar := parmstring[len];
      flushbyte := Ord(fchar) - 64;
      FlushChar := Chr(flushbyte);
      SetParmVars;
      Exit;
    End;
  End;

  If UpCase(tstchar) = 'E' Then
  Begin
    For i := 1 To 3 Do parmstring[i] := UpCase(parmstring[i]);
    If Pos('ESC', parmstring) > 0  Then
    Begin
      If len > 3 Then
      Begin
        flushchar := ' '; { dummy }
        SetParmVars;
        flushstring := Copy(parmstring, 4, len-3);
        flushstring := ESC + flushstring;
        Exit;
      End;
    End;
  End;
  { got this far? bad params! }
  BadParams := True;
End;

Procedure SetTextMode40;
  Begin
    ClrScr;
    HighVideo;
    TextMode(CO40);
  End;

Procedure ResetTextMode;
  Begin
    TextMode(3);
    NormVideo;
  End;

Procedure SayHalting;
  Var
    dum: Char;
  Begin
    WriteLn;
    WriteLn('      SEE FILE "README.BAL" FOR');
    WriteLn('      INSTRUCTIONS ON SETTING UP');
    WriteLn('      THE PROGRAM WITH A SPEECH');
    WriteLn('             SYNTHESIZER.');
    WriteLn;
    WriteLn('           HALTING PROGRAM.');
    WriteLn;
    WriteLn('            PRESS ANY KEY.');
    Repeat Until KeyPressed;
    dum := ReadKey;
    If Ord(dum) = 0 Then dum := ReadKey;
    ResetTextMode;
    Halt;
  End;

Procedure CheckDevStatus(DevStg: String; Serial: Boolean;
             Var GoodDev, InReddy, OutReddy: Boolean);
  { borrowed from unit PortStuf dl 8-15-96 }
  Var
    Handl: Word;
    AcCode: String2;
    Filerr: Boolean;

  Begin
    If Serial Then AcCode := 'RW' Else  AcCode := 'WO';
    OpenDOSFile (DevStg, AcCode, Handl, Filerr);
    If ((CheckDev (Handl)) And (Not Filerr))
    Then GoodDev := True Else GoodDev := False;
    If Not GoodDev Then
    Begin
      OutReddy := False;
      InReddy := False;
      Exit;
    End
    Else
    Begin
      { check ready status }
      OutReddy := CheckDevOutReddy (Handl);
      InReddy := CheckDevInReddy (Handl);
    End;
    CloseDOSFile (handl);
  End;

Function CheckLegalTalkPort(tlkdev, dataport: String4): Boolean;
  Var
    InReddy, OutReddy: Boolean;

  Begin
    If Length(tlkdev) = 0 Then
    Begin
      GotoXY(5,9);
      WriteLn(^G, 'FILE "TALKPORT.DAT" CONTAINS NO');
      GotoXY(5,11);
      WriteLn('PORT NAME FOR THE SPEECH DEVICE.');
      SayHalting;
    End;
    If tlkdev = dataport Then
    Begin
      CheckLegalTalkPort := False;
      GotoXY(1, 8);
      Write(^G, ^G);
      WriteLn('    FILE "TALKPORT.DAT" CONTAINS THE');
      WriteLn('    SAME PORT AS THE BALANCE:  ', dataport, '.');
      WriteLn('      THE BALANCE AND THE SPEECH' );
      WriteLn('    DEVICE CANNOT USE THE SAME PORT!');
      SayHalting;
    End
    Else
    Begin
      CheckLegalTalkPort := False;
      If tlkdev = 'COM1' Then CheckLegalTalkPort := True
      Else If tlkdev = 'COM2' Then CheckLegalTalkPort := True
      Else If tlkdev = 'COM3' Then CheckLegalTalkPort := True
      Else If tlkdev = 'COM4' Then CheckLegalTalkPort := True
      Else If tlkdev = 'LPT1' Then CheckLegalTalkPort := True
      Else If tlkdev = 'LPT2' Then CheckLegalTalkPort := True
      Else If tlkdev = 'LPT3' Then CheckLegalTalkPort := True
      Else
      Begin
        GotoXY(1, 10);
        WriteLn('    FILE "TALKPORT.DAT" CONTAINS');
        WriteLn('      AN ILLEGAL PORT NAME FOR');
        WriteLn('      THE SPEECH DEVICE: ', tlkdev, '.');
        SayHalting;
      End;
    End;
    { made it this far? must be legal. }
    If tlkdev[1] = 'C' Then Serial := True Else  Serial := False;
    CheckDevStatus(tlkdev, Serial, GoodTalkDev, InReddy, OutReddy);
    If Not OutReddy Then
    Begin
      GotoXY(1, 10);
      WriteLn('     THE SPEECH DEVICE (IF ANY)');
      WriteLn('      CONNECTED TO PORT ', tlkdev);
      WriteLn('            IS NOT READY.');
      SayHalting;
    End;
  End;

Procedure ResetAccent;
  Var
    setupstring: String;
  Begin
    setupstring  := ESC + '=' + 'R'; { reset }
    Write(talkdev, setupstring);
    Delay(2000); { wait for message }
  End;

Procedure SetUpAccent;
  Var
    setupstring: String;
  Begin
    setupstring  := ESC + '=' + 'R'; { reset }
    Write(talkdev, setupstring);
    Delay(2000); { wait for message }
    setupstring  := ESC + '=' + 'M'; { enable ctl-X as instant flush }
    Write(talkdev, setupstring);
    Delay(300);
    setupstring  := ESC + '=' + 'F'; { enable CR as instant speech }
    Write(talkdev, setupstring);
    Delay(300);
    WriteLn(talkdev, 'Accent set up for balance program.');
  End;

Procedure OpenTalkPort2;
  Begin
    Assign(talkdev, talkdevname);
    Rewrite(talkdev);
    GotoXY(1,10);
    WriteLn('    SENDING SPEECH OUTPUT TO');
    WriteLn;
    WriteLn('  DEVICE CONNECTED TO PORT ', talkdevname);
    If Accent Then SetUpAccent;
    TalkReddy := True;
    TalkToPort := True;
    NoBlast := True;
    Delay(4000);
    ResetTextMode;
  End;

Procedure  GetTalkPortData(dataport: String);
 { reads a port for speech synth }
  Var
    tlkportfile: Text;
    OKport: Boolean;
    dumstg: String;

  Begin
    TalkToPort := False;
    TalkReddy := False;
    If CheckFileExists2('TALKPORT.DAT') Then
    Begin
      Assign(tlkportfile, 'TALKPORT.DAT');
      Reset(tlkportfile);
      ReadLn(tlkportfile, dumstg);
      Close(tlkportfile);
    End Else Exit;
    eatblanks(dumstg);
    allcaps(dumstg);
    talkdevname := Copy(dumstg, 1, 4);
    If CheckLegalTalkPort(talkdevname, dataport) Then OpenTalkPort2;
  End;

Procedure Talkit101(tlkstg: String);
{ var NoBlast allows debugging without loading the SBPro speech driver. }
{ exits if not ready for speech. dl 8-9-96 }
Begin
  If ((Not TalkReddy) Or (Length(tlkstg) = 0)) Then Exit;
  If Not NoBlast Then sbts_say(tlkstg)
  Else If TalkToPort Then WriteLn(talkdev, tlkstg);
End;

Procedure InitSBSettings2;
  Var
    NormTone, NormVol, NormPitch, NormSpeed: Integer;
  Begin
    NormTone  :=  0;  {0 or 1; 0 = bass, 1 = treble }
    NormVol   :=  5;  { 0 to 9; default = 5 }
    NormPitch :=  7;  { 0 to 9; default = 5 }
    NormSpeed :=  7;  { 0 to 9; default = 5 }
    sbts_settings(0, NormTone, NormVol, NormPitch, NormSpeed);
  End;

Procedure InitBalTalk(dataport: String4);
  Var
    TalkErr: Integer;

  Begin
    SetTextMode40;
    OldMode := LastMode;
    TalkReddy := False;
    TalkToPort := False;
    TalkErr := sbts_init;
    If TalkErr =  0 Then
    Begin
      NoBlast := True;
      GotoXY(5,4);
      WriteLn('NO SOUND BLASTER SPEECH DRIVER.');
      GotoXY(2,6);
      WriteLn('LOOKING FOR SPEECH SYNTHESIZER DATA.');
      GetTalkPortData(dataport);
    End
    Else
    Begin
      InitSBSettings2;
      talkit101('Sound blaster speech initialized.');
      TalkReddy := True;
      NoBlast := False;
      TalkToPort := False;
      Flushit := False; { added dl 10-96 }
      ResetTextMode;
    End;
  End;
End.

