/*
 *	initshow.c  --  screen setup for ega graphics.
 *
 *	4 june 1989  Olle Olsson
 */

#include <graphics.h>
#include <stdlib.h>

/* externally supplied error exit */
void error( char *format, ... );

/* globals */
int grmode;			/* graphic mode */
int max_x_coord;		/* max x */
int max_y_coord;		/* max y */


void initshow()
{
int g_driver, g_mode, g_error;

/* get the graphics driver linked in  (not loaded at runtime) */
if ((g_error = registerbgidriver( EGAVGA_driver )) < 0)
	error( "Registerbgidriver: %s", grapherrormsg( g_error ) );

/* any graphics hardware ? */
detectgraph( &g_driver, &g_mode );

if (g_driver < 0)
	error( "No graphics hardware detected" );

/* use EGA HI mode */
g_driver = EGA;
g_mode = EGAHI;
/*initgraph( &g_driver, &g_mode, "C:\\TURBOC\\BGI" );*/
initgraph( &g_driver, &g_mode, "" );
if ((g_error = graphresult()) < 0)
	error( "Initgraph: %s", grapherrormsg( g_error ) );

/* set some globals */
grmode = getgraphmode();
max_x_coord = getmaxx();
max_y_coord = getmaxy();
}

void endshow()
{
/*gm_hide();*/
closegraph();
}

/*
void box( int x0, int y0, int x1, int y1, int color )
{
setcolor( color );
moveto( x0, y0 );
lineto( x0, y1 );
lineto( x1, y1 );
lineto( x1, y0 );
lineto( x0, y0 );
}
*/

