/*
 *	gmtc.h -- genious mouse C interface (Turbo C)
 *
 *
 *	2 oct 1988  Olle
 */

/* button depressed bits for gm_status.gm_pbuttton */
#define GM_PLEFT   0x01
#define GM_PRIGHT  0x02
#define GM_PMIDDLE 0x04

/* button number parameter for gm_press() and gm_release() */
#define GM_LEFT   0
#define GM_RIGHT  1
#define GM_MIDDLE 2

/* gm_getpos(), gm_press(), gm_release() and gm_getmickey() return values */
struct gm_status
	{
	int  gm_xpos;	 /* horizontal position */
	int  gm_ypos;	 /* vertical position */
	int  gm_count;	 /* button press/release count */
        char gm_pbutton; /* button status bit set for: GM_PRIGHT,.. */
	};

/* struct to define graphics cursor gm_defg() */
struct gm_gcurs
	{
	int gm_hhot;	/* horizontal hot spot -16..16, upper left is (0,0) */
	int gm_vhot;	/* vertical hot spot in the same manner */
	int gm_scmask[16];	/* screen mask: 16 words */
	int gm_cumask[16];	/* cursor mask: 16 words */
	};

/* struct to define area for conditional hide cursor gm_chide() */
struct gm_chbox
	{
	int xlow;	/* horizontal minimum */
	int ylow;	/* vertical minimum */
	int xhigh;	/* horizontal maximum */
	int yhigh;	/* vertical maximum */
	};

/* genious mouse functions */
int gm_init( void );
void gm_show( void );
void gm_hide( void );
void gm_getpos( struct gm_status *stat );
void gm_setpos( int row, int col );
void gm_press( int button, struct gm_status *stat  );
void gm_release( int button, struct gm_status *stat );
void gm_hlimit( int min, int max );
void gm_vlimit( int min, int max );
void gm_defg( struct gm_gcurs *gcurs );
void gm_deft( int hard, int scstart, int scstop );
void gm_getmickey( struct gm_status *stat );
void gm_event( int mask, int (*func)() );
void gm_lpon( void );
void gm_lpoff( void );
void gm_setmpr( int hrat, int vrat );
void gm_chide( struct gm_chbox *box );
void gm_setspl( int limit );

/* others */
void gm_boxin( int cols, int rows, int color, int box[] );