/*
 *	getkey.c  --  input function(s) for mouse and keyboard with menu.
 *		      Use in graphics mode only.
 *
 *	Menus start at (0, 0).
 *
 *	2 july 1989  Olle.
 */

#include <graphics.h>
#include <conio.h>
#include "gmtc.h"
#include "getkey.h"

/* Mouse button character for gotkey(). (Should have setup function.) */
#define EDIT_CH ' '

/* current menu */
static menudescr *menup;

/* kbhit() doesn't seem to detect characters from ungetch(), use a local flag */
static int haskey;

int getkey( struct gm_status *gp )
{
register int *cp;
register char **s;
register int x;

/* wait for a button or a key */
do
	{
	if (kbhit() || haskey)
		{
		haskey = 0;
		return (getch());
		}
	gm_getpos( gp );
	}
while (!gp -> gm_pbutton);

/* a button, check the menu */
if (menup) if (gp -> gm_ypos < menup -> row)
	{
	/* in the menu area, which entry ? */
        x = gp -> gm_xpos;
	for (s = menup -> item, cp = menup -> col; *s; ++s, ++cp)
		{
		if (x < *cp)
	               	return (*s[0]);
	        }

	/* loop fall-through means outside the menu */
	}

/* zero means a button */
return (0);
}

void showmenu( menudescr *mp )
{
register char *s;
register int i;

/* show the menu and fill in the coordinates */
moveto( 0, 0 );

for (i = 0; s = mp -> item[i]; ++i)
	{
	/* gputs() clears the background; don't do that */
	/*gputs( " " ); */
	/*gputs( s ); */
	outtext( " " );
	outtext( s );

	/* graphic mode coordinate */
	mp -> col[i] = getx();
	}

/* save the position of the end of the last item */
mp -> col[i] = getx();
mp -> row = textheight( "A" );

/* remember the menu */
menup = mp;
}

void nomenu()
{
register int i;
struct fillsettingstype fis;

/* remove the menu (if there is one) */
if (!menup)
	return;
 
/* (this is as gputs()) */
/* assume TOP_TEXT & LEFT_TEXT justification */

/* get fill settings */
getfillsettings( &fis );

/* setup for character erase */
setfillstyle( SOLID_FILL, getbkcolor() );

/* find the end x of the last menu item */
for (i = 0; menup -> item[i]; ++i);

/* fill with the background color */
bar( 0, 0, menup -> col[i]  - 1, textheight( "A" ) - 1 );

/* restore fill settings */
setfillstyle( fis.pattern, fis.color );

/* and now, there is no menu */
menup = 0;
}
	
void wbup()
{
struct gm_status gs;

/* wait for all buttons to be up */
do
	{
	gm_getpos( &gs );
	}
while (gs.gm_pbutton);

/* clear the button press counters */
gm_press( GM_LEFT, &gs );
gm_press( GM_RIGHT, &gs );
}

int gotkey()
{
struct gm_status gs;

/* check keyboard and mouse */
if (kbhit()) return (1);

/* kbhit() fix */
if (haskey)
	{
	return (1);
	}

/* if a button was pressed make it look like EDIT_CH */
gm_press( GM_LEFT, &gs );
if (gs.gm_count > 0)
	{
	ungetch( EDIT_CH );
	++haskey;
	return (1);
	}

gm_press( GM_RIGHT, &gs );
if (gs.gm_count > 0)
	{
	ungetch( EDIT_CH );
	++haskey;
	return (1);
	}

return (0);
}

