/* $ chips.cpp 07/09/99 11:03 $
 * Chipsets specific initialization code for VFlat. Revision 1.02
 *
 * Copyright (C) 1999  Dmitry Uvarov <mit@pc2o205a.pnpi.spb.ru>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Special thanx for beta testing to:
 *       - Sandy Bugai for testing and help in fixing SiS code
 *
 * Revision history:
 *     1.00 - 1.01 -  Fixed bug with Trident initialization routine.
 *     1.01 - 1.02 -  Fixed bug with SiS.
 */

/*
 *  Currently support the following chipsets:
 *
 * S3           (Has driver) Tested OK!  (ViRGE 3D, TRIO 64v+)
 * TRIDENT      (Has driver) Tested OK!
 * TSENG        (Has driver) Tested OK!  (TSeng ET6000) Driver not tested!
 * CIRRUS       (Has driver) Tested OK!  (Cirrus 5465)
 * ATI          (Has driver) Tested OK!                 Driver not tested!
 * ARK          (Has driver) !Not Tested                Driver not tested!
 * COMPAQ       (No driver)  !Not Tested
 * OAK          (No driver)  !Not Tested
 * SIERRA       (No driver)  !Not Tested
 * ACER         (No driver)  !Not Tested
 * VIDEO7       (No driver)  !Not Tested
 * SiS          (Has driver) Tested OK!
 * Paradise     (No driver)  !Detection not implemented
 */

void S3_enable()
  {
     /* Unlock S3 extended registers */
     writeportbyte(0x3D4, 0x38, 0x48);
     writeportbyte(0x3D4, 0x39, 0xA5);
     /* write to Linear Address Window Control Register */
     writeportbyte(0x3D4, 0x58, readportbyte(0x3D4, 0x58) | 0x10);
  }

void Trident_enable()
  {
     /* Enable New Mode Registers */
     readportbyte(0x3C4,0x0B);
     /* enable extended registers */
     writeportbyte(0x3C4,0x0E, readportbyte(0x3C4,0x0E) | 0x80);
     /* write to Configurable Linear Addressing Register */
     writeportbyte(0x3D4,0x21, readportbyte(0x3D4,0x21) | 0x20);
  }

void TSeng_enable()
  {
    /* write to Video System Configuration 1 Register */
    writeportbyte(0x3D4,0x36,  readportbyte(0x3D4,0x36) | 0x10);
  }

void Cirrus_enable()
  {
    /* write to CPU Base Address Control Register */
    writeportbyte(0x3CE,0x0D,  readportbyte(0x3CE,0x0D) | 0x10);
  }

void ATI_enable()
  {
    /* write to ATI Register */
    writeportbyte(0x1CE,0x0AC, readportbyte(0x1CE,0x0AC) | 01);
  }

void ACER_enable()
  {
    writeportbyte(0x3CE,0x17,  readportbyte(0x3CE,0x17) | 0x80);
  }

void ARK_enable()
  /* FIXME: can't get it work on one model of ARK i have tested. */
  {
    /* Enable extended registers */
    writeportbyte(0x3C4,0x1D,  readportbyte(0x3C4,0x1D) | 1);
    /* linear frame buffer size 4 MB */
    writeportbyte(0x3C4,0x12,  readportbyte(0x3C4,0x12) | 0x03);
    /* Enable access to whole video memory and enable LFB */
    writeportbyte(0x3C4,0x10,  readportbyte(0x3C4,0x10) | 0x13);
//    writeportbyte(0x3C4,0x10,  readportbyte(0x3C4,0x10) | 0x10);
  }

void COMPAQ_enable()
  {
//    outpw(0x23C7,  inpw(0x23C7) | 4);  /* ?? */
  }

void OAK_enable()
  {
    /* write to Video Memory Mapping Register */
    writeportbyte(0x3DE,0x05,  readportbyte(0x3DE,0x05) | 1);
  }

/*?? how i can detect this ??*/
/*3D4 29h?? */
void Paradise_enable()
  {
    /* unlock Paradise Extended Registers */
    writeportbyte(0x3C4,0x06,  0x48);
    /* write to Video Memory Mapping Register */
    writeportbyte(0x3C4,0x14,  readportbyte(0x3C4,0x14) | 0x30); /*?? set both bits ??*/
  }

void Sierra_enable()
  {
    writeportbyte(0x3CE,0x05,  readportbyte(0x3CE,0x05) | 0x80);
  }

void SiS_enable()
  {
      writeportbyte(0x3C4,0x6,  readportbyte(0x3C4,0x6) | 0x80);
  }

void Video7_enable()
  {
    /* write to Miscellaneous Control 2 Register */
    writeportbyte(0x3C4,0x0C8,  readportbyte(0x3C4,0x0C8) | 0x40);
  }

/****************************************************************************
 *                                                                          *
 *                      DETECTION      PROCEDURES                           *
 *                                                                          *
 ***************************************************************************/
ibool Video7_detect()
  {
     /* this detection routine completely ripped from FreeBE driver */
     byte old = readportbyte(0x3C4, 6);
     writeportbyte(0x3C4, 6, 0x0EA);   /* enable BIOS extentions */

     RMREGS regs;
     memset(&regs,0,sizeof(RMREGS));
     regs.eax = 0x6F00;            /* installation check */
     regs.ebx = 0x0000;
     PM_RealModeInt(0x10, &regs);
     word _bx = regs.ebx & 0xFFFF;
     if ((_bx != 0x5637) && (_bx != 0x4850)) {
        writeportbyte(0x3C4, 6, old);
        return FALSE;
     } else return TRUE;
  }
