#include <stdio.h>

/*
 * simple ascii to rayshade height field converter.
 * reads standard in, writes standard out.
 * each number must be on a line by itself.
 *
 * Rusty Wright
 * rusty@garnet.berkeley.edu
 */

#ifdef __WATCOMC__
#include <fcntl.h>
#endif

main(int argc,char **argv) {
	char	buf[BUFSIZ];
	int	length, line;
	float	height;


	if (argc!=1) {
		printf("Convert ascii file to .hf file for RayShade.\n\n");
		printf("usage:  a2hf < infile > outfile\n\n");
		exit(1);
		}

#ifdef __WATCOMC__
		setmode(stdin->_handle,O_BINARY);
		setmode(stdout->_handle,O_BINARY);
#endif

	if (fgets(buf, sizeof(buf), stdin) == NULL) {
		fprintf(stderr, "premature eof on stdin\n");
		exit(1);
	}

	line = 1;

	if (sscanf(buf, "%d", &length) != 1) {
		fprintf(stderr, "format error line %d\n", line);
		exit(1);
	}

	if (fwrite((char *) &length, sizeof(length), 1, stdout) != 1) {
		perror("write");
		exit(1);
	}

	while (fgets(buf, sizeof(buf), stdin) != NULL) {
		line++;

		if (sscanf(buf, "%g", &height) != 1) {
			fprintf(stderr, "format error line %d\n", line);
			exit(1);
		}

		if (fwrite((char *) &height, sizeof(height), 1, stdout) != 1) {
			perror("write");
			exit(1);
		}
	}

	exit(0);
}
