/*
    Copyright (C) 1996,99  Marian Krivos
    nezmar@internet.alcatel.sk

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    declarations for widgets

*/

//
//	WIDGETS.CC		20.11.1998
//
//	FileDialog();
//

#ifndef _WIDGETS_H_
#define _WIDGETS_H_

#ifdef __WATCOMC__
#ifdef __DOS__
#include <direct.h>
#else
#include <dirent.h>
#endif // dos
#else
#include <dirent.h>
#endif // watcom

#include <unistd.h>
#include "fastgl.h"

#define	FDIALOG_OPEN	1
#define	FDIALOG_SAVE	2
#define	FDIALOG_MODAL	4
#define	FDIALOG_SAVEDIR	8

class ListBox {
		void (*kresli)(int,int,int,int,void *);
        Window *wnd;
		void   *dataptr;
	public:
		void draw(void);
		int x,y,polx,poly,curr,count,fpol,onew,oneh,cx,cy;
		// flag bit 0 set if x+1 is down (other x+1 is right)
        int GetCurrent(void) { return curr; }
        int GetFirstVisible(void) { return fpol*polx; }
		int GetSize(void) { return count; }
		void SetSize(int);
		ListBox(int xs, int ys, int wpol, int hpol, int w, int h, int cnt, void (*drawone)(int,int,int,int,void *), Window *wind, void *data=0)
		{
			dataptr = data;
			x    = xs;
			y    = ys;
			cx   = 0; // obe v polozkach
			cy   = 0;
			onew = w;
			oneh = h;
            wnd  = wind;
			polx = wpol;
			poly = hpol;
			curr = fpol = 0;
			count= cnt;
			kresli = drawone;
		 	draw();
		}
        void Resize(int kolko);
		void SetToItem(int);
		void SetToItemRel(int);
		void RedrawItem(void)
		{
			kresli(x+cx*onew, y+cy*oneh, curr, 1, dataptr);
		}
		void Up(void);
		void Down(void);
		void Right(void);
		void Left(void);
		int  Test(int, int);
};

//
// filename length max. 63 chars
// max. visible is 20 chars
//
class FileDialog
{
		static  char path[256];
		static  char tmppath[256];
		char 	filename[256];
		char	*filter;
		int 	mode;
		int		files;
		int		maxfiles;
		void 	(*fileselect)(char *);
		void	reload(void);
		static Window	*wnd;
		EditBox *nameEBox;
		struct 	dirent *filebuffer;
		char	*memory;
		ListBox *list;
		PushButton *ok, *cancel, *mkdir, *up, *down;
		static	FileDialog *instance;
		int		Selected(void);
		void	Refresh(char *);
	public:
		FileDialog(void (*filesel)(char *), char *dir=0, char *flt=0, char *namewnd="File Dialog", int m=FDIALOG_OPEN, int ink=0, int paper=PM);
		~FileDialog()
		{
			if (list) delete list;
			if (memory) delete memory;
			if (wnd) if (wnd->GetStatus() & WEXIST) delete wnd;
			instance = 0;
		}
		char	*GetDir(void) { return path; }
		char	*GetName(void) { return filename; }
		void	SetDir(char *d) { strcpy(path, d); reload(); }
		void	SetFilter(char *f) { filter=f; reload(); }
		void	SetMode(int m) { mode=m; }
		static  void myproc(GuiEvent *p);
		static  void drawone(int,int,int,int,void *);
};

class ProgressBar
{
		int		steps, value;
		Window	*wnd;
		int		fg,bg;
		int		x,y,w,h,sirka;
	public:
		void	draw(void);
		void	setProgress(int a) { if (a>=0 && a<=steps) value = a; draw(); }
		int		progress(void) { return value; }
		ProgressBar(Window *w, int xx, int yy, int ww, int hh, int s);
};

#endif
