//
//
//

#include <fastgl.h>
#include <widgets.h>

#include "rad_def.h"
#include "rad_type.h"
#include "rad_sym.h"

// increment number of items in wform and update display & data
void Projekt::PridajWidget(void)
{
	if (!change_only)
	{
		lBox->SetSize(Items()+1);
		lBox->SetToItem(Okno[curr].items++);
	} else lBox->RedrawItem();
	Redraw(&prj->Okno[prj->curr]);
	set_colors(0,CGRAY2);
	mWnd->printf(464,4,"List of %3d Objects\n",lBox->GetSize());
}

static void dummy(int x, int y, int ind, int, void *data)
{
	Window *p = (Window *)data;
	set_colors(IM,PM);
	p->printf(x,y,"item %d\n", ind);
}

void Projekt::DrawWidget(Wind *w, int i)
{
	static int ii=1;
 	static double dd=1;
	static char ss[256];
	int oldf=-1;
	ListBox *lb;
	Accel *p = w->table+i;

	if (prj->font) oldf = set_font(prj->font-1);
	
	switch(p->type)
	{
		case RAD_PUSHBUTTON:
			w->form->AddPushButton(p->x, p->y, p->w, p->h, p->name, p->key);
			break;
		case RAD_CHECKBUTTON:
			w->form->AddCheckButton(p->x, p->y, p->name, p->key);
			break;
		case RAD_POINTBUTTON:
			w->form->AddPointButton(p->x, p->y, p->name, p->key);
			break;
		case RAD_EDITBOX1:
			if (p->flags&ACCF_TRANSP) w->form->AddEditBox(p->x, p->y, p->w, p->h, p->name, p->key, &ii, 0, p->min, p->max);
			else w->form->AddEditBox(p->x, p->y, p->w, p->h, p->name, p->key, &ii);
			break;
		case RAD_EDITBOX2:
			if (p->flags&ACCF_TRANSP) w->form->AddEditBox(p->x, p->y, p->w, p->h, p->name, p->key, &dd, 0, p->mind, p->maxd);
			else w->form->AddEditBox(p->x, p->y, p->w, p->h, p->name, p->key, &dd);
			break;
		case RAD_EDITBOX3:
			w->form->AddEditBox(p->x, p->y, p->w, p->h, p->name, p->key, ss);
			break;
		case RAD_SLIDEBAR:
			w->form->AddSlideBarH(p->x, p->y, p->w, p->h, p->key, &ii);
			break;
		case RAD_MENU:
			w->form->AddBaseMenu(p->name, p->key);
			break;

		case RAD_LISTBOX:
			lb = new ListBox(p->x, p->y, p->ww, p->hh, p->w, p->h, p->ww*p->hh, dummy, w->form, w->form);
			AddToWidgets(lb, RAD_LISTBOX);
			break;

		case RAD_STRING:
			if (p->flags&ACCF_TRANSP) w->form->WindowText(p->x, p->y, p->name);
			else w->form->WindowText(p->x, p->y, p->name, p->ink, p->paper);
			break;
		case RAD_BOX:
			if (p->flags&ACCF_TRANSP) w->form->WindowBox(p->x, p->y, p->w, p->h);
			else w->form->WindowBox(p->x, p->y, p->w, p->h, p->ink);
			break;
		case RAD_RECT:
			if (p->flags&ACCF_TRANSP) w->form->WindowRect(p->x, p->y, p->w, p->h);
			else w->form->WindowRect(p->x, p->y, p->w, p->h, p->ink);
			break;
		case RAD_LINE:
			if (p->flags&ACCF_TRANSP) w->form->WindowLine(p->x, p->y, p->w, p->h);
			else w->form->WindowLine(p->x, p->y, p->w, p->h, p->ink);
			break;
		case RAD_CIRCLE:
			if (p->flags&ACCF_TRANSP) w->form->WindowDrawCircle(p->x, p->y, p->w);
			else w->form->WindowDrawCircle(p->x, p->y, p->w, p->ink);
			break;
		case RAD_FILLCIRCLE:
			if (p->flags&ACCF_TRANSP) w->form->WindowFillCircle(p->x, p->y, p->w);
			else w->form->WindowFillCircle(p->x, p->y, p->w, p->ink);
			break;
	}
	if (oldf != -1) set_font(oldf);
}

static void Select(Window *wn, int x, int y, int w, int h)
{
	set_ppop(_GNOT);
	wn->WindowRect(x,y,w,h);
	wn->WindowRect(x+1,y+1,w-2,h-2);
	set_ppop(_GSET);
}

void AssignSize(Accel &table, int &X, int &Y, int &W, int &H)
{
	int var = 0, a = -1;

	if (table.type == RAD_LINE)	//exchange param if it is needed
	{
		if (table.x>table.w)
		{
			table.x ^= table.w;
			table.w ^= table.x;
			table.x ^= table.w;
		}
		if (table.y>table.h)
		{
			table.y ^= table.h;
			table.h ^= table.y;
			table.y ^= table.h;
		}
	}
	switch(table.type)
	{
		default:
		case RAD_PUSHBUTTON:
		case RAD_CHECKBUTTON:
		case RAD_POINTBUTTON:
		case RAD_MENU:
		case RAD_STRING:
		case RAD_LINE:
		case RAD_BOX:
		case RAD_RECT:
		case RAD_EDITBOX1:
		case RAD_EDITBOX2:
		case RAD_EDITBOX3:
		case RAD_SLIDEBAR:
		case RAD_LISTBOX:
			X =	table.x-2;
			Y =	table.y-2;
			break;
		case RAD_CIRCLE:
		case RAD_FILLCIRCLE:
			X =	table.x-table.w-2;
			Y =	table.y-table.w-2;
			break;
	}
	switch(table.type)
	{
		default:
		case RAD_PUSHBUTTON:
		case RAD_BOX:
		case RAD_RECT:
			W =	table.w+4;
			H =	table.h+4;
			break;
		case RAD_EDITBOX1:
		case RAD_EDITBOX2:
		case RAD_EDITBOX3:
			W =	table.w + table.h +4;
			H =	21+4;
			break;
		case RAD_CHECKBUTTON:
		case RAD_POINTBUTTON:
			var = 24;
		case RAD_STRING:
			if (prj->font) a = set_font(prj->font-1);
			W = var + strlen(table.name)*fontw +4;
			H = fonth+4;
			if (a != -1) set_font(a);
			break;
		case RAD_LINE:
			W =	table.w+4-table.x;
			H =	table.h+4-table.y;
			break;
		case RAD_LISTBOX:
			H = table.h*table.hh+4;
			W = table.w*table.ww+4;
			break;
		case RAD_SLIDEBAR:
			H = 16+4;
			W =	(table.h-table.w)/table.key+60+4;
			break;
		case RAD_MENU:
			W = strlen(table.name)*8 + 8 +4;
			H = 18+4;
			break;
		case RAD_CIRCLE:
		case RAD_FILLCIRCLE:
			W =	table.w*2+1+4;
			H =	table.w*2+1+4;
			break;
	}
}

void SelectCurrent(Wind *w)
{
	int X2,Y2,W2,H2;
	AssignSize(w->table[w->current], X2,Y2,W2,H2);
	Select(w->form, X2,Y2,W2,H2); // clear old
}

//
// Test for clicking to item
//
int Projekt::ClickTest(int x, int y, Wind *w)
{
	int i, X,Y,W,H;
	if (w->items==0) return 0;
	for (i=0; i<w->items; i++)
	{
		if (w->table[i].type == RAD_MENU) continue;
		AssignSize(w->table[i], X, Y, W, H);
		if (x>=X && y>=Y)
			if (x<X+W && y<Y+H)
				break;
	}
	if (i == w->items) return 0;	// not found
	if (w->current == i) return 2; // the same
	if (w->current != -1)
	{
		SelectCurrent(w);
	}
	Select(w->form, X,Y,W,H);
	w->current = i;
	if (lBox->GetSize()) lBox->SetToItem(i);
	return 1;
}

static Accel *movedAccel;

static void	DrawShape(int, int, int w, int h)
{
	int	a =	set_ppop(_GNOT),X,Y,W,H;
	Window *wn = Window::GetCurrent();
	
	AssignSize(*movedAccel, X, Y, W, H);
	wn->WindowBox(X+w, Y+h, W-1, H-1);
	set_ppop(a);
}

void Projekt::proc(GuiEvent *p)
{
	int	x, y, x1, y1, i;
	static Accel *cAccel;
	Wind *w;
	Accel *tab;
	
	for(i=0; i<prj->nwin; i++)	// find current window
	{
		if (p->wnd==prj->Okno[i].form)
		{
			break;
		}
	}
	if (i==prj->nwin) assert(0); // not found ?
	w = prj->Okno + i;
	tab = w->table;
	
	switch(p->Type())
	{
		case STARTDRAGLEFTEVENT:	// MOVE CONTROLS AT THE NEW POSITION
			if (prj->ClickTest(p->GetX(), p->GetY(), w))	// DRAG CONTROL
			{
				GuiEvent::SetDragShape(DrawShape);
				movedAccel = &tab[w->current];
			}
			break;
		case DRAGLEFTEVENT:	// MOVE CONTROLS AT THE NEW POSITION
			GuiEvent::SetDragShape(0);
			GuiEvent::GetDragVector(x, y, x1, y1);
			if (prj->ClickTest(x, y, w))	// DRAG CONTROL
			{
				int a =	tab[w->current].x;
				int b =	tab[w->current].y;

				if (a+x1<0 || b+y1<0 ||	a+x1>=w->form->GetWW() || b+y1>=w->form->GetHW()) break;
				tab[w->current].x += x1;
				tab[w->current].y += y1;
				if (tab[w->current].type == RAD_LINE)
				{
					tab[w->current].w += x1;
					tab[w->current].h += y1;
				}
				if (dlgWnd)	// if dialog is show
				{
					eb5->ChangeItem(&tab[w->current].x);
					eb6->ChangeItem(&tab[w->current].y);
					if (tab[w->current].type == RAD_LINE)
					{
						eb7->ChangeItem(&tab[w->current].w);
						eb8->ChangeItem(&tab[w->current].h);
					}
				}
				int tmp = w->current;
				prj->Redraw(w);
				w->current = tmp;
				SelectCurrent(w);
		}
			break;
		case LOSTFOCUSEVENT:
			if (w->current != -1)
			{
				SelectCurrent(w);
				w->current = -1;
			}
			break;
		case CLICKLEFTEVENT:
			if (prj->curr!=i)
			{
				lBox2->SetToItem(i);
				prj->curr = i;
				prj->Update();
				prj->Redraw(w);
			}
			if (prj->ClickTest(p->GetX(), p->GetY(), w) == 2 && (cAccel != &tab[lBox->GetCurrent()] || !dlgWnd)) // the same
			{
				change_only = 1;
				int tmp = w->current;
				ShowDialog((RadType)0, cAccel = &tab[lBox->GetCurrent()]);
				w->current = tmp;
				SelectCurrent(w);
			}
			else Puk();
			break;
		case RESIZEEVENT:
			w->w = p->wnd->GetW();
			w->h = p->wnd->GetH();
			eb3->ChangeItem(&w->w);
			eb4->ChangeItem(&w->h);
			prj->Redraw(w);
			break;
		case WINDOWMOVEEVENT:
			w->x = p->wnd->GetX();
			w->y = p->wnd->GetY();
			eb1->ChangeItem(&w->x);
			eb2->ChangeItem(&w->y);
			break;
		case KEYEVENT:
		case MOVEEVENT:
			mWnd->SendToWindow(p);
			break;
	}
}

//
// redraw 'i' window
//
void Projekt::Redraw(Wind *w)
{
	static char *tmpBmp=0;
	int i;
	if (w->form) delete w->form;
	w->current = -1;
	while(w->widgets--)
	{
		if (w->widget_type[w->widgets] == RAD_LISTBOX) delete ((ListBox *)(w->widget_ptr[w->widgets]));
	}
	w->widgets = 0;
	w->form = new Window(&w->form, w->x,w->y,w->w,w->h,w->name,proc,w->ink,w->paper,(w->flags|WSIZEABLE)& ~WMODAL);
	for (i=0; i<w->items; i++)
		DrawWidget(w, i);
	for(i=16; i<256; i++) if (paleta[i*4]) // if color is used
	{
		cApp->farby->CreateColor(paleta[i*4+1], paleta[i*4+2], paleta[i*4+3], i);
	}
	else cApp->farby->CreateColor(0,0,0,i);
	if (tmpBmp) delete tmpBmp;
	tmpBmp = new char [w->w * w->h];
	get_block(w->x, w->y, w->w, w->h, tmpBmp);
	w->form->RemoveControls();
	put_block(w->x, w->y, w->w, w->h, tmpBmp);
}

Projekt::~Projekt()
{
	int i;
	for (i=0; i<MAX_WND;i++) if (Okno[i].form) delete Okno[i].form;
	Save();
	for (i=0; i<MAX_WND;i++)
	while(Okno[i].widgets--)
	{
		if (Okno[i].widget_type[Okno[i].widgets] == RAD_LISTBOX) delete ((ListBox *)(Okno[i].widget_ptr[Okno[i].widgets]));
	}
}

void Projekt::DrawAll(int delFlag)
{
	for (int i=0; i<nwin; i++)
	{
		if (delFlag && Okno[i].form) delete	Okno[i].form;
		Okno[i].form = 0;
		Redraw(Okno+i);
	}
}

void Projekt::Init(void)
{
	prj = this;
	memset(this, 0, sizeof(Projekt));
	Okno[0]=windx;
	nwin = 1;
	version = VERSION;
	magic = 21081973;
	video_mode = 3;
	app_altx = 1;
	app_cfg = 1;
	sprintf(prjname, "%s.wnd", wind()->name);
}

Projekt::Projekt(char *name)
{
	FILE *fp=fopen(name,"rb");
	if (fp)
	{
		fread(this, sizeof(Projekt), 1, fp);
		fclose(fp);
		prj = this;
		if (magic != 21081973) Init();
	}
	else Init();
	strcpy(prjname, name);
	DrawAll();
}

Projekt::Projekt()
{
	Init();
}

void Projekt::AddToWidgets(void *p, RadType typ)
{
	int widgets = Okno[curr].widgets;
	if (widgets>=MAX_WIDGETS) return; // full !!!
	Okno[curr].widget_ptr[widgets] = p;
	Okno[curr].widget_type[widgets]= typ;
	Okno[curr].widgets++;
}

void Projekt::DeleteItem(void)
{
	int item = lBox->GetCurrent(), items = Items();
	if (items==0) return;
	if (item < items && items>1)
		memmove(table()+item, table()+item+1, sizeof(Accel)*(items-item-1));
	items = --Okno[curr].items;
	lBox->Resize(-1);
	set_colors(0,CGRAY2);
	mWnd->printf(464,4,"List of %3d Objects\n", items);
	Redraw(&prj->Okno[prj->curr]);
}

// prehodi aktualny prvok o jeden dalej
void Projekt::Forward(void)
{
	Accel a;
	int poloha = lBox->GetCurrent();
	if (poloha == lBox->GetSize()-1) return;
	memcpy(&a, table()+poloha, sizeof(a));
	memcpy(table()+poloha, table()+poloha+1, sizeof(a));
	memcpy(table()+poloha+1, &a, sizeof(a));
	lBox->SetToItemRel(1);
	lBox->draw();
	Redraw(&prj->Okno[prj->curr]);
}

// prehodi aktualny prvok o jeden naspat
void Projekt::Backward(void)
{
	Accel a;
	int poloha = lBox->GetCurrent();
	if (poloha == 0) return;
	memcpy(&a, table()+poloha-1, sizeof(a));
	memcpy(table()+poloha-1, table()+poloha, sizeof(a));
	memcpy(table()+poloha, &a, sizeof(a));
	lBox->SetToItemRel(-1);
	lBox->draw();
	Redraw(&prj->Okno[prj->curr]);
}

// zdvoji aktualny prvok
void Projekt::Clone(void)
{
	int poloha = lBox->GetCurrent(), items = Items();
	if (items==0 || items>=MAX_ACCEL) return;
	memcpy(table()+items, table()+poloha, sizeof(Accel));
	Okno[curr].items++;
	lBox->Resize(1);
	lBox->draw();
	set_colors(0,CGRAY2);
	mWnd->printf(464,4,"List of %3d Objects\n", items);
	Redraw(&prj->Okno[prj->curr]);
}

void Projekt::AddWindow(void)
{
	if (nwin<MAX_WND)
	{
		Okno[nwin] = windx;
		curr = nwin;
		nwin++;
		Update();
		Redraw(Okno+curr);
	}
}

void Projekt::DuplicateWindow(void)
{
	static int duplicate=1;
	
	if (nwin<MAX_WND)
	{
		Wind *w = &Okno[curr];
		Okno[nwin] = *w;
		curr = nwin;
		w = &Okno[curr];
		w->form = 0;
		w->x += 16;
		w->y += 16;
		w->widgets = 0;
		sprintf(w->name, "%s %d", w->name, duplicate++);
		nwin++;
		Update();
		Redraw(w);
	}
}

void Projekt::DeleteWindow(void)
{
	if (nwin>1)
	{
		delete prj->form();
		if (nwin-1 > curr) memmove(Okno+curr, Okno+curr+1, sizeof(Wind));
		else curr--;
		nwin--;
		memset(Okno+nwin, 0, sizeof(Wind));
		Update();
		Redraw(Okno+curr);
	}
}

void Projekt::Up(void)
{
	if (curr)
	{
		lBox2->Up();
		curr--;
		Update();
		Redraw(Okno+curr);
	}
}

void Projekt::Down(void)
{
	if (curr<nwin-1)
	{
		lBox2->Down();
		curr++;
		Update();
		Redraw(Okno+curr);
	}
}


