 /*
   **  Smart Directory - ver. 1.0, 2.0, 3.0, 4.0 & 5.0 (16.2.1998)
   **
   **  DATE: 16.X.1995 - RUMSOFT
 */


#include <ctype.h>
#include <string.h>
#include <malloc.h>
#include <stdio.h>
#include <time.h>
#include <stdlib.h>

#include <fastgl.h>
#include <widgets.h>

#define NAMESIZE  30
#define ADDRSIZE  30
#define CITYSIZE  20
#define ZIPSIZE   10
#define STATESIZE 12
#define PHONESIZE 16
#define INETSIZE  16
#define MEMOSIZE  37+4

#define POLOZIEK 9
#define MAXADDR 9999
#define REVISION 1

#define ENGLISH

#pragma pack(4)

extern "C"
{
	enum
	{
		OLD_DECODE = 0, OLD_ENCODE = 1, NEW_CRYPT = 2
	};
	void SetCryptKeys(char *Password);
	void Crypt(void *Data, unsigned long Count, int Method);
}

struct
{
	long items;
	char password;
	char pattern[MEMOSIZE + 1];
	long curr;
	char revision;
	char stuff[146];
}
header;

typedef struct
{
	time_t vznik;
	time_t zmena;
}
CASY;

typedef struct
{
	char name[NAMESIZE + 1], addr[ADDRSIZE + 1], city[CITYSIZE + 1], zip[ZIPSIZE + 1],
	  state[STATESIZE + 1], phone[PHONESIZE + 1], fax[PHONESIZE + 1], inet[INETSIZE + 1],
	  memo[MEMOSIZE + 1];
}
ADRESA;

typedef struct
{
	char nazov[13];
	int dlzka;
	int offset;					/* posun oproti zaciatku */
	int riadok;
	int stlpec;
	int key;
	int farba;
}
POLOZKA;

static short Sounds;

static ADRESA *adresar, defaultaddr;

#ifdef ENGLISH
static POLOZKA polozky[POLOZIEK] =
{
	{"    Name :", NAMESIZE, 0, 2, 1, 0, CRED},
	{" Address :", ADDRSIZE, NAMESIZE + 1, 3, 1, 0, CBLUE},
	{"    City :", CITYSIZE, NAMESIZE + ADDRSIZE + 2, 4, 1, 0, CBLUE},
	{"     ZIP :", ZIPSIZE, NAMESIZE + ADDRSIZE + CITYSIZE + 3, 5, 1, 0, CBLUE},
	{"   State :", STATESIZE, NAMESIZE + ADDRSIZE + CITYSIZE + ZIPSIZE + 4, 6, 1, 0, CBLUE},

	{"   Phone :", PHONESIZE, NAMESIZE + ADDRSIZE + CITYSIZE + ZIPSIZE + STATESIZE + 5, 6, 38, 0, CYELLOW},
	{"     Fax :", PHONESIZE, NAMESIZE + ADDRSIZE + CITYSIZE + ZIPSIZE + STATESIZE + PHONESIZE + 6, 7, 38, 0, CYELLOW},
	{"Internet :", INETSIZE, NAMESIZE + ADDRSIZE + CITYSIZE + ZIPSIZE + STATESIZE + PHONESIZE + PHONESIZE + 7, 8, 38, 0, CYELLOW},

	{"    Memo :", MEMOSIZE, NAMESIZE + ADDRSIZE + CITYSIZE + ZIPSIZE + STATESIZE + PHONESIZE + PHONESIZE + INETSIZE + 8, 11, 1, 0, CGREEN}};
static char snf[] = "String not found !";
#else
static POLOZKA polozky[POLOZIEK] =
{
	{"    Meno :", NAMESIZE, 0, 2, 1, 0, CRED},
	{"  Adresa :", ADDRSIZE, NAMESIZE + 1, 3, 1, 0, CBLUE},
	{"   Mesto :", CITYSIZE, NAMESIZE + ADDRSIZE + 2, 4, 1, 0, CBLUE},
	{"     PSC :", ZIPSIZE, NAMESIZE + ADDRSIZE + CITYSIZE + 3, 5, 1, 0, CBLUE},
	{"    Stat :", STATESIZE, NAMESIZE + ADDRSIZE + CITYSIZE + ZIPSIZE + 4, 6, 1, 0, CBLUE},

	{" Telefon :", PHONESIZE, NAMESIZE + ADDRSIZE + CITYSIZE + ZIPSIZE + STATESIZE + 5, 6, 38, 0, CYELLOW},
	{"     Fax :", PHONESIZE, NAMESIZE + ADDRSIZE + CITYSIZE + ZIPSIZE + STATESIZE + PHONESIZE + 6, 7, 38, 0, CYELLOW},
	{"Internet :", INETSIZE, NAMESIZE + ADDRSIZE + CITYSIZE + ZIPSIZE + STATESIZE + PHONESIZE + PHONESIZE + 7, 8, 38, 0, CYELLOW},

	{"   Obkec :", MEMOSIZE, NAMESIZE + ADDRSIZE + CITYSIZE + ZIPSIZE + STATESIZE + PHONESIZE + PHONESIZE + INETSIZE + 8, 11, 1, 0, CGREEN}};
static char snf[] = "Vymysli si nieco ine - take cosi som tu este nevidel";
#endif

static int fcurr, curr, maxitem, items, isize, offset, cp, compr = 0, entire = 1;
static int type = 1, range, inAdd;

static unsigned size = sizeof(ADRESA), change;

static char pattern[MEMOSIZE + 1], fname[55], s[80], password[11];
static Window *w1, *w2, *w3, *w5, *w6, *wc, *w7;
static EditBox *editboxy[POLOZIEK];
static PushButton *bt1, *bt2;
static Control *w7c1, *w7c2, *w7c3, *w7c4, *w7c5;
static CASY *casy;
static PCHARFNC fdlgproc;
static char findspc[20];
static ButtonGroup *grp;

#pragma pack()

void loadcfg(void);
void end(void);
void savefile2(char *sname);
void _x5(void);
void Confirm(char *s,Widget,Widget);

/**************************************************************/


void jedna(ADRESA * a, int cispol);

char *processname(char *s)
{
	char n[50];
	int i;

	memset(n, ' ', 49);
	for (i = 0; i < 45; i++)
	{
		if ((s[i] == '.') || (s[i] == ' ') || (!s[i]))
			break;
		n[i] = s[i];
	}
	n[i] = 0;
	strcat(n, ".smd");
	strcpy(s, n);
	return s;
}

void center(int line, char *s)
{
	w2->printf(295 - (strlen(s) * 4), line * 16, s);
}

void EditHandler(void)
{
	change = 1;
	if (inAdd)
	{
		if (inAdd == POLOZIEK)
			inAdd = 0;
		else
			editboxy[inAdd]->ClickUp(1);
		inAdd++;
	}
}

void EBoxy(void)
{
	int a = POLOZIEK;
	POLOZKA *p;

	while (a)
	{
		p = &polozky[a - 1];
		editboxy[a - 1] = w1->AddEditBox(p->stlpec * 8 + 16, p->riadok * 24 - 8, 13 * 8, p->dlzka * 8, p->nazov, p->key, (char *) (&adresar[curr]) + p->offset, EditHandler);
//		editboxy[a - 1]->SetInk(p->farba);
		a--;
	}
}

void show2(ADRESA * s1)
{
	int a = POLOZIEK;

	while (a)
		jedna(s1, --a);
}

void info(void)
{
	char s[100];
#ifdef ENGLISH
	sprintf(s, "Free: %04u from %04u items                        Current item: %04u", maxitem - items, maxitem, curr);
#else
	sprintf(s,"Volne: %04u z %04u poloziek                   Aktualna pozicia: %04u", maxitem - items, maxitem, curr);
#endif
	w1->WindowStatusBar(20,s,CREDLIGHT);
}

void show(void)
{
	show2(adresar + curr);
	info();
}

void desktop(void)
{
	EBoxy();
	info();
	show();
	sprintf(s, "Smart Directory - %s", fname);
	w1->SetName(s);
}

void passProc(GuiEvent * e)
{
	if (e->Type() == INPUTEVENT2)
		delete w6;

	if (e->Type() == INPUTEVENT1)
	{
		savefile2(fname);
		delete w6;
	}
}

void Password(void)
{
	if (w6)
		return;
	new Window(&w6, 100, 100, 300, 60, "", passProc, CBLUE, CWHITE, WMODAL | WUSELAST);
	w6->AddEditBox(12, 20, 13 * 8, 12 * 8, "Password: ", 0, password)->ClickUp(1);
}

void passProc2(GuiEvent * e)
{
	if (e->Type() == INPUTEVENT2)
		delete w6;

	if (e->Type() == INPUTEVENT1)
	{
		SetCryptKeys(password);
		Crypt(adresar, items * sizeof(ADRESA), OLD_DECODE);
		show();
		change = offset = 0;
		sprintf(s, "Smart Directory - %s", fname);
		if (w1)
			w1->SetName(s);
		delete w6;
	}
}

void Password2(void)
{
	if (w6)
		return;
	new Window(&w6, 100, 100, 300, 60, "", passProc2, CBLUE, CWHITE, WMODAL | WUSELAST);
	w6->AddEditBox(12, 20, 13 * 8, 12 * 8, "Password: ", 0, password)->ClickUp(1);
}

void savefile2(char *sname)
{
	FILE *a;
	int c;

	if ((a = fopen(sname, "wb")) != 0)
	{
		header.items = items;
		header.curr = fcurr = curr;
		header.revision = REVISION;
		strcpy(header.pattern, pattern);
		if (*password)
			header.password = 1;
		else
			header.password = 0;
		fwrite(&header, sizeof(header), 1, a);
		if (*password)
		{
			SetCryptKeys(password);
			Crypt(adresar, items * sizeof(ADRESA), OLD_ENCODE);
		}
		for (c = 0; c < items; c++)
		{
			fwrite(adresar + c, sizeof(ADRESA), 1, a);
		}
		if (header.revision)
			for (c = 0; c < items; c++)
			{
				fwrite(casy + c, sizeof(CASY), 1, a);
			}
		if (*password)
		{
			SetCryptKeys(password);
			Crypt(adresar, items * sizeof(ADRESA), OLD_DECODE);
		}
		fclose(a);
		change = 0;
	}
	else
		IError("Can`t open file for write!", 0);
	sprintf(s, "Smart Directory - %s", fname);
	if (w1)
		w1->SetName(s);
}

void savefile(char *s)
{
	char sname[50];

	if (s)
	{
		strcpy(sname, s);
		if (*sname == ' ')
			strcpy(sname, fname);
		processname(sname);
		strcpy(fname, sname);
		password[0] = 0;
	}
	if (compr)
	{
		Password();
		return;
	}
	savefile2(fname);
}

void svf(void)
{
	savefile(0);
	App::AppDone();
}

void nosvf(void)
{
	App::AppDone();
}

void end(void)
{
	if (change)
	{
#ifdef ENGLISH
		Confirm("Save the file ?",svf,nosvf);
#else
		Confirm("Ulozit zmeny v subore ?",svf,nosvf);
#endif
	}
	else App::AppDone();
}

void additem(void)
{
	if (items == maxitem) return;
	curr = items++;
	show();
	memcpy((void *) (adresar + curr), (void *) &defaultaddr, size);
	casy[curr].vznik = casy[curr].zmena = time(NULL);
	inAdd = 1;
	editboxy[inAdd - 1]->ClickUp(1);
}

void loadfile(char *x)
{
	FILE *a;
	char sname[55];
	int c;

	strcpy(sname, x);
	processname(sname);
	if (*sname == ' ')
		strcpy(sname, fname);
	if ((a = fopen(sname, "rb")) != NULL)
	{
		fread(&header, sizeof(header), 1, a);	// nacitaj hlavicku

		items = (int) header.items;
		fcurr = curr = (int) header.curr;
		strcpy(pattern, header.pattern);
		for (c = 0; c < items; c++)
		{
			fread(adresar + c, sizeof(ADRESA), 1, a);
		}
		if (header.revision)
			for (c = 0; c < items; c++)
			{
				fread(casy + c, sizeof(CASY), 1, a);
			}
		fclose(a);
		strcpy(fname, sname);
		if (header.password)
		{
			Password2();
			return;
			SetCryptKeys(password);
			Crypt(adresar, items * sizeof(ADRESA), OLD_DECODE);
		}
	}
	else IError("not found",0);
	change = offset = 0;
	sprintf(s, "Smart Directory - %s", fname);
	if (w1)	w1->SetName(s);
}

void mergefile(char *n)
{
	FILE *a;
	char sname[55];
	int items2, c;

	strcpy(sname, n);
	processname(sname);
	if ((a = fopen(sname, "rb")) != NULL)
	{
		fread(&header, sizeof(header), 1, a);	// nacitaj hlavicku

		items2 = (int) header.items;
		for (c = 0; c < items2; c++)
		{
			fread(adresar + c + items, sizeof(ADRESA), 1, a);
		}
		if (header.revision)
			for (c = 0; c < items2; c++)
			{
				fread(casy + c + items, sizeof(CASY), 1, a);
			}
		fclose(a);
		if (header.password)
		{
			Password();
			SetCryptKeys(password);
			Crypt(adresar + items, items2 * sizeof(ADRESA), OLD_DECODE);
		}
	}
	else
		return;
	if (items2 + items <= maxitem)
		items = items2 + items;
	else
	{
		IError("Out of space !", 0);
		return;
	}
	change = 1;
	offset = 0;
}

static   void cfHand(GuiEvent *e)
{
	switch(e->Type())
	{
		case ACCELEVENT:
			delete e->wnd;
			break;
	}
}

// ret 1 if yes

void Confirm(char *s,Widget yes, Widget no)
{
	new Window(&wc, 200,150,240,90,"Confirmation",cfHand,CRED,CGRAY3,WMODAL|WNOPICTO|WFRAMED|WTITLED);
	wc->WindowText(10, 10, s, CBLACK);
#ifdef ENGLISH
	wc->AddPushButton(30, 30, 65, 21, "Yes", 'Y', yes);
	wc->AddPushButton(140, 30, 65, 21, "No",  'N', no);
#else
	wc->AddPushButton(30, 30, 65, 21, "Ano", 'A', yes);
	wc->AddPushButton(140, 30, 65, 21, "Nie", 'N', no);
#endif
}

void deleteitem2(void)
{
	items -= 1;
	int a = items - curr;
	memcpy(adresar + curr, adresar + (curr + 1), a * size);
	memset(adresar + items, size, 0);
	memcpy(casy + curr, casy + (curr + 1), a * sizeof(CASY));
	memset(casy + items, 0, sizeof(CASY));
	if (curr == items)
		if (curr)
			--curr;
	change = 1;
	show();
}

static void deleteitem(void)
{
#ifdef ENGLISH
	Confirm("Delete this address ?",deleteitem2,0);
#else
	Confirm("Zmazat tuto polozku ?",deleteitem2,0);
#endif
}

static void novy2(void)
{
	change = items = curr = fcurr = 0;
	memset(adresar, size * maxitem, 0);
	memset(casy, sizeof(CASY) * maxitem, 0);
	strcpy(fname, "noname.smd");
	int last = 0;

	memset(adresar, ' ', size);
	for (int i = 0; i < POLOZIEK; i++)
		*(((char *) adresar) + polozky[i].dlzka + last) = 0, last = polozky[i].dlzka + 1 + last;
	show();
}

static void novy(void)
{
#ifdef ENGLISH
	Confirm("Delete all items ???",novy2,0);
#else
	Confirm("Zmazat vsetko ???",novy2,0);
#endif
}

int _memcmp(unsigned char *from, unsigned char *co, unsigned kolko, unsigned l)
{
	unsigned char *p, c1, c2;
	unsigned i;

	while (kolko--)
	{
		if (toupper(*from) == toupper(*co))
		{
			p = from;
			for (i = 0; i < l; i++)
			{
				c1 = toupper(p[i]);
				c2 = toupper(co[i]);
				if (c1 != c2)
					break;
			}
			if (i == l)
				return 0;
		}
		from++;
	}
	return 1;
}

int _find(int from)
{
	int a, b, c;
	char *p;

	b = strlen(pattern);
	for (a = from; a < items; ++a)
	{
		if (entire)
		{
			if (!_memcmp((unsigned char *) (adresar + a),(unsigned char *) pattern, size, b))
			{
				fcurr = curr = a;
				return 1;
			}
		}
		else
		{
			for (c = strlen(p = (char *) (adresar + a) + offset); c >= b; --c)
			{
				if (!strnicmp(p++, pattern, b))
				{
					fcurr = curr = a;
					return 1;
				}
			}
		}
	}
	return 0;
}

void FindHandler(GuiEvent * e)
{
	char *p, *s = findspc;

	if (e->Type() == INPUTEVENT2)
		delete w5;

	if (e->Type() == INPUTEVENT1)
	{
		if ((!s) || (*s == ' '))
			return;
		p = s + sizeof(findspc) - 1;
		while (*p < '!')
			*p-- = '\0';
		strcpy(pattern, s);
		fcurr = 0;
		delete w5;

		if (_find(fcurr))
		{
			show();
			info();
			return;
		}
		IError(snf, 0);
	}
}

void find2(void)
{
	if (_find(fcurr + 1))
	{
		return;
	}
	fcurr = -1;
	IError(snf, 0);
}

void find(void)
{
	if (items < 2 || w5)
		return;

	new Window(&w5, 100, 100, 300, 60, "", FindHandler, CBLUE, CWHITE, WMODAL | WUSELAST);
#ifdef ENGLISH
	w5->AddEditBox(12, 20, 15 * 8, 18 * 8, "Looking for:", 0, findspc)->ClickUp(1);
#else
	w5->AddEditBox(12, 20, 15 * 8, 18 * 8, "Hladam co ?:", 0, findspc)->ClickUp(1);
#endif
}

void savecfg(void)
{
	int i;
	FILE *a;
	char path[80];
	char *p = (char *) &defaultaddr;

	if ((a = fopen("sd.ini", "wb")) != 0)
	{
		for (i = size; i != 0; i--)
			fputc(*p++, a);
	}
	fclose(a);
}

void loadcfg(void)
{
	int i = sizeof(ADRESA);
	FILE *a;
	char *p = (char *) &defaultaddr;

	compr = cfg->ReadInt("crypted");
	entire= cfg->ReadInt("find_everywhere");
	Sounds= cfg->ReadInt("sounds");

	a = fopen("sd.ini", "rb");
	if (a != 0)
	{
		while (i--)
			*p++ = fgetc(a);
		fclose(a);
	}
	else
	{
		int last = 0;

		memset(&defaultaddr, ' ', sizeof(defaultaddr));
		for (i = 0; i < POLOZIEK; i++)
			*(((char *) &defaultaddr) + polozky[i].dlzka + last) = 0, last = polozky[i].dlzka + 1 + last;
		compr = 0;
		entire = 1;
		Sounds = 1;
		savecfg();
	}
}

void delW2(GuiEvent * e)
{
	if (e->Type() == ACCELEVENT)
	    delete w2;

}

#ifdef ENGLISH
void help(void)
{
	if (w2)
		return;
	new Window(&w2, 1000, 1000, 590, 300, "Help Page", delW2, CWHITED, CBLACK, WSTANDARD | WUSELAST);
	set_colors(w2->GetInk(), w2->GetPaper());
	w2->printf(8,  0, "Arrow keys                          Mouse control");
	w2->printf(16, 16, "UP ......... go to start           click to the right button to cancel");
	w2->printf(16, 32, "DOWN ....... go to end");
	w2->printf(16, 48, "RIGHT ...... show next item        click to the left button to :");
	w2->printf(16, 64, "LEFT ....... show last item           1) item to edit them");
	w2->printf(16, 80, "ALT+X ...... exit to dos              2) the menu to execute command");
	w2->printf(16, 96, "PgDOWN ..... current += 10");
	w2->printf(16, 112, "PgUP ....... current -= 10");
	w2->printf(16, 128, "Delete ..... delete current item");
	w2->printf(16, 144, "Tab ........ find next");

	set_fcolor(CGREENLIGHT);
	center(12, "Smart Directory   -   Version 5.0\n");
	center(13, "RUMSOFT 1995, 98  Marian Krivos\n");
	center(15, "FreeWare \n");
	w2->AddPushButton(330, 130, 22 * 8, 24, "Press ENTER ...", CR);
}
#else
void help(void)
{
	if (w2)
		return;
	new Window(&w2, 1000, 1000, 590, 300, "POMOCNA STRANKA", delW2, CWHITED, CBLACK, WSTANDARD | WUSELAST);
	set_colors(w2->GetInk(), w2->GetPaper());
	w2->printf(8,  0, "Sipkove kurzory                    MYSIE OVLADANIE\n");
	w2->printf(16, 16, "HORE ....... chod na zaciatok       Prave tlacitko rusi operaciu\n");
	w2->printf(16, 32, "DOLE ....... chod na koniec\n");
	w2->printf(16, 48, "VPRAVO ..... nasledujuca adresa     Lave tlacitko :\n");
	w2->printf(16, 64, "VLAVO ...... minula adresa            1) edituje polozku adresy\n");
	w2->printf(16, 80, "ALT+X ...... koniec                   2) spusta prikazy z menu ponuky\n");
	w2->printf(16, 96, "PgDOWN ..... skok o 10 vpred\n");
	w2->printf(16, 112, "PgUP ....... skok o 10 nazad\n");
	w2->printf(16, 128, "Delete ..... zmaz aktualnu adresu\n");
	w2->printf(16, 144, "Tab ........ najdi inu\n");

	set_fcolor(CGREENLIGHT);
	center(12, "Smart Directory   -   Verzia 5.0\n");
	center(13, "RUMSOFT 1995, 98  Marian Krivos\n");
	center(15, "FreeWare \n");
	w2->AddPushButton(330, 130, 22 * 8, 24, "Stlac ENTER ...", CR);
}
#endif

void _o1(void)
{
	compr = !compr;
}

void _o2(void)
{
	entire = !entire;
}

void options(void)
{
	CheckButton *p,*z;

	MenuWindow *w4 = new MenuWindow(GetMouseX(), GetMouseY(), 160, 47, "Options");
#ifdef ENGLISH
	p = w4->AddCheckButton("Crypted", 'C', &compr, 0);
	z = w4->AddCheckButton("Find everywhere", 'F', &entire, 0);
#else
	p = w4->AddCheckButton("Kryptovanie", 'K', &compr, 0);
	z = w4->AddCheckButton("Hladat vsade", 'H', &entire, 0);
#endif
	p->SetTrigger(compr);
	z->SetTrigger(entire);
}

void reduce(void)
{
	short a;

	curr = 0;
	while (curr < items)
	{
		if (!memcmp(adresar + curr, adresar + curr + 1, sizeof(ADRESA)))
		{
			items -= 1;
			a = items - curr;
			memcpy(adresar + curr, adresar + (curr + 1), a * size);
			memset(adresar + items, size, 0);
			memcpy(casy + curr, casy + (curr + 1), a * sizeof(CASY));
			memset(casy + items, 0, sizeof(CASY));
			change = 1;
		}
		else
			curr++;
	}
}

extern "C"
{
	void __crt0_load_environment_file(char *)
	{
	}
	char **__crt0_glob_function(char *)
	{
		return 0;
	}
}

void myexit()
{
	end();
}

void init(void)
{
	int i;

	adresar = (ADRESA *)calloc(MAXADDR * (size + 1), 1);
	casy = (CASY *)malloc(MAXADDR * sizeof(CASY));
	for (i = 0; i < MAXADDR; i++)
		casy[i].vznik = casy[i].zmena = (time_t) 0;
	maxitem = MAXADDR;
	curr = fcurr = items = change = 0;
}

void jedna(ADRESA * a, int cispol)
{
	POLOZKA *p = &polozky[cispol];
	char *s;
	editboxy[cispol]->ChangeItem((char *) (&adresar[curr]) + p->offset);

	if (items)
	{
		set_fcolor(CGRAY1);
		w1->move(40, 180);
		s = ctime(&casy[curr].vznik);
		s[24] = 0;
		strcpy(s + 11, s + 20);
#ifdef ENGLISH
		w1->printf(" Created : %s\n", s + 4);
#else
		w1->printf("  Zaznam : %s\n", s + 4);
#endif
		w1->move(40, 204);
		s = ctime(&casy[curr].zmena);
		s[24] = 0;
		strcpy(s + 11, s + 20);
#ifdef ENGLISH
		w1->printf("Modified : %s\n", s + 4);
#else
		w1->printf("   Zmena : %s\n", s + 4);
#endif
	}
}

void WndProc(GuiEvent * e)
{
	switch (e->Type())
	{
		case ACCELEVENT:
			if (e->Key() == bt1->GetId())
			{
				if (curr)
					--curr;
				break;
			}
			if (e->Key() == bt2->GetId())
			{
				if (curr < items - 1)
					++curr;
				break;
			}
			break;
		case KEYEVENT:
			switch (e->Key())
			{
				case KRIGHT:
					if (curr < items - 1)
						++curr;
					break;
				case KLEFT:
					if (curr)
						--curr;
					break;
				case KUP:
					curr = 0;
					break;
				case KDOWN:
					curr = items ? items - 1 : items;
					break;
				case PGUP:
					if (curr>=10) curr -= 10; else curr = 0;
					break;
				case PGDOWN:
					if ((curr+10) <= (items-1)) curr += 10; else curr=items-1;
					break;
				case DEL:
					if (items)
						deleteitem();
					break;
				case TAB:
					find2();
					break;
			}
			break;
		case TERMINATEEVENT:
			myexit();
			break;
		case QUITEVENT:
			if (w2)
				delete w2;

			if (w3)
				delete w3;

			break;
		default:
			return;
	}
	show();
	info();
}

int AppProc(GuiEvent * e)
{
	switch (e->Type())
	{
		case QUITEVENT:
			if (w2)
				delete w2;

			if (w3)
				delete w3;

			break;
	}
	return 1;
}

void fileproc(char * namespc)
{
	fdlgproc(namespc);
	info();
	show();
}

void load(void)
{
	fdlgproc = loadfile;
	new FileDialog(fileproc, ".", ".smd", "File Open", FDIALOG_OPEN|FDIALOG_MODAL);
}

void save(void)
{
	fdlgproc = savefile;
	new FileDialog(fileproc, ".", ".smd", "File Save", FDIALOG_SAVE|FDIALOG_MODAL);
}

void merge(void)
{
	fdlgproc = mergefile;
	new FileDialog(fileproc, ".", ".smd", "File Merge", FDIALOG_OPEN|FDIALOG_MODAL);
}

void w7Hand(GuiEvent *p)
{
	switch(p->Type())
	{
		case KEYEVENT:
			if (p->Key()==ESC) 
			{
				delete w7;
				w7 = 0;
			}
			break;
		case ACCELEVENT:
			if (p->Key() == w7c5->GetId())
			{
				_x5();
				delete w7;
				w7 = 0;
			}
			else if (p->Key() == w7c4->GetId()) range = !range;
			else if (p->Key()>=w7c1->GetId() && p->Key()<=w7c3->GetId())
			{
				type = p->Key() - w7c1->GetId() + 1;
			}
			break;
	}
}

void _x5(void)
{
	int od, po, cur;
	ADRESA *p;
	if (type == 0) return;
	FILE * printer = fopen("sdw.prn","w");
	if (range)
	{
		od = 0;
		po = items;
	}
	else
	{
		od = curr;
		po = curr + 1;
	}
	for (cur = od; cur < po; cur++)
	{
		p = (adresar + cur);
		fprintf(printer, "-   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -\n");
		switch (type)
		{
			case 1:
				fprintf(printer, "          %s\n", p->name);
				fprintf(printer, "          %s\n", p->addr);
				fprintf(printer, "%-10s%s\n", p->zip, p->city);
				fprintf(printer, "          %s\n", p->state);
				break;
			case 2:
				fprintf(printer, "          %s tel :%s\n", p->name, p->phone);
				fprintf(printer, "          %s fax :%s\n", p->addr, p->fax);
				fprintf(printer, "%-10s%s           inet:%s\n", p->zip, p->city, p->inet);
				fprintf(printer, "          %s                   %s\n", p->state, p->memo);
				break;
			case 3:
				fprintf(printer, "%-30s       %s (%s)\n", p->name, p->phone, p->fax);
				break;
		}
	}
	fputc('\n', printer);
	fclose(printer);
}

void print(void)
{
	if (!items || w7)
		return;
#ifdef ENGLISH
	new Window(&w7, GetMouseX(), GetMouseY(), 180, 170, "Select report",w7Hand,IM,PM,WSTANDARD|WMODAL);
	w7c1 = w7->AddPointButton(10,10,"Normal Report", 'N');
	w7c2 = w7->AddPointButton(10,30,"Full Report", 'F');
	w7c3 = w7->AddPointButton(10,50,"Telephone List", 'T');
	w7c4 = w7->AddCheckButton(10,80,"Whole Database", 'W');
	w7c5 = w7->AddPushButton(40,110,80,21,"Print", 'P');
#else
	new Window(&w7, GetMouseX(), GetMouseY(), 180, 170, "Zvol format",w7Hand,IM,PM,WSTANDARD|WMODAL);
	w7c1 = w7->AddPointButton(10,10,"Tradicny", 'T');
	w7c2 = w7->AddPointButton(10,30,"Vsetky polozky", 'V');
	w7c3 = w7->AddPointButton(10,50,"Telefonny zoznam", 'T');
	w7c4 = w7->AddCheckButton(10,80,"Vsetky zaznamy", 'Z');
	w7c5 = w7->AddPushButton(40,110,80,21,"Tlac", 'T');
#endif	
	type = 2;
	w7c4->SetTrigger(1); range = 1;
	grp = new ButtonGroup;
	grp->AddToGroup(w7c1);
	grp->AddToGroup(w7c2, 1);
	grp->AddToGroup(w7c3);
}

int comp(const void *a, const void *b)
{
	return stricmp((char*)a+offset, (char*)b+offset);
}

void sort(void)
{
	if (items<2) return;
	offset = 0;
//	if (!Select(adresar+curr)) break;
	qsort((void*)adresar, items, size, comp);
	change=1;
}

int main(int argc, char **argv)
{
	App MyApp(2, argc, argv, CDARK, APP_ENABLEALTX);
	char *file;

	if (argc >= 2)
		strcpy(fname, argv[1]);
	else
		strcpy(fname, "noname.smd");

	processname(fname);
	init();

	new Window(&w1, 20, 20, 600, 440, "Smart Directory for 32 bit DOS, QNX, LINUX ..", WndProc, CBLACK, CGRAY3, WUNMOVED | WFRAMED|WTITLED | WMENU | WSTATUSBAR);

#ifdef ENGLISH
	w1->AddBaseMenu("Save ", 'S', save);
	w1->AddBaseMenu("Load ", 'L', load);
	w1->AddBaseMenu("Merge ", 'M', merge);
	w1->AddBaseMenu("Add ", 'A', additem);
    w1->AddBaseMenu("Sort ",'O', sort);
	w1->AddBaseMenu("Find ", 'F', find);
	w1->AddBaseMenu("New ", 'N', novy);
	w1->AddBaseMenu("Print ", 'P', print);
	w1->AddBaseMenu("Option ", 'T', options);
	w1->AddBaseMenu("Help ", 'H', help);
#else
	w1->AddBaseMenu("Uloz ", 'U', save);
	w1->AddBaseMenu("Nahraj ", 'N', load);
	w1->AddBaseMenu("Pripoj ", 'R', merge);
	w1->AddBaseMenu("Pridaj ", 'P', additem);
    w1->AddBaseMenu("Sort ",'O', sort);
	w1->AddBaseMenu("Hladaj ", 'H', find);
	w1->AddBaseMenu("Novy ", 'N', novy);
	w1->AddBaseMenu("Tlac ", 'T', print);
	w1->AddBaseMenu("Volby ", 'V', options);
	w1->AddBaseMenu("Help", 'E', help);
#endif
	bt1 = w1->AddPushButton(430, 312, 64, 21, "<<<", '<');
	bt2 = w1->AddPushButton(500, 312, 64, 21, ">>>", '>');
	w1->WindowRect(16, 16, w1->GetWW() - 32, w1->GetHW() - 32, CBLUELIGHT);
	curr = fcurr = change = 0;
	if (strcmp(fname, "noname.smd"))
	{
		loadfile(fname);
	}
	loadcfg();
	desktop();

	MyApp.Run(AppProc);

	if (change) myexit();
	cfg->WriteInt("crypted",compr);
	cfg->WriteInt("find_everywhere",entire);
	cfg->WriteInt("sounds", Sounds);
 	end();
	if (w1) delete w1;
	return 0;
}
