;--------------------------------------------------------------------------
; This is file VDRHEAD.ASM
;
; Copyright (C) 1991 DJ Delorie, 24 Kirsten Ave, Rochester NH 03867-2954
; Copyright (C) 1992 Csaba Biegl, 820 Stirrup Dr, Nashville, TN 37221
; Copyright (C) 1993 Grzegorz Mazur, gbm@ii.pw.edu.pl
;
; This file is distributed under the terms listed in the document
; "copying.dj", available from DJ Delorie at the address above.
; A copy of "copying.dj" should accompany this file; if not, a copy
; should be available from where this file was obtained.  This file
; may not be distributed without a verbatim copy of "copying.dj".
;
; This file is distributed WITHOUT ANY WARRANTY; without even the implied
; warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
;--------------------------------------------------------------------------

;
; Modified version of the standard small model Turbo C assembly
; output segment directives. Forces everything into a single segment
;
_TEXT	segment byte public 'CODE'
_TEXT	ends
DGROUP  group	_TEXT,_DATA,_BSS			;; added _TEXT
	assume  cs:_TEXT,ds:DGROUP
_DATA	segment word public 'DATA'
d@	label	byte
d@w	label	word
_DATA	ends
_BSS	segment word public 'BSS'
b@	label	byte
b@w	label	word
_BSS	ends
_TEXT	segment byte public 'CODE'
	assume  cs:_TEXT,ds:DGROUP

include grdriver.inc

;--------------------------------------------------------------------------
; DRIVER HEADER
;  The following entries MUST match the structure and constant
;  declarations in the file 'grdriver.h' of the GRX graphics library
;  The mode word should contain the following bitfields:
;     - the GRD_NEW_DRIVER bit set for any new format driver
;     - the adapter type field should be specified
;     - the memory size field should be specified
;     - the paging mode field should be specified
;  The mode set routine will OR in the plane bitfield as it will
;  change when different color number modes are requested.
;--------------------------------------------------------------------------

_driver_header:
	;; ".GRD" fields:
	dw	offset _mode_set_routine	; text/graphics mode set routine
	dw	offset _paging_routine		; video memory paging routine
	dw	GRD_NEW_DRIVER			; driver flags (init func sets other bits)
	dw	80				; default text width
	dw	25				; default text height
	dw	640				; default graphics width
	dw	480				; default graphics height
	;; ".GRN" fields:
	dw	16				; default graphics colors
	dw	offset _driver_init_routine	; driver init func
	dw	offset _text_mode_table		; ptr to supported text modes
	dw	offset _graphics_mode_table	; ptr to supported graphics modes
	dw	0				; pageflip fn (obsolete)
	;; ".VDR" fields (hard-coded):
	db	'.VDR driver',0			; VDR format 'magic' string
	dw	offset _driver_name		; pointer to driver name
	dw	offset _set_screen_start	; scroll/pageflip routine
	;; fields configured once by GO32 after driver is loaded
	dw	0				; flags for real-mode paing, fast 256 mode, etc..
	;; fields filled out by the driver init routine
	dw	0				; video adapter memory size in 4 kByte units
	;; fields read/written by both the driver and GO32 during every mode set
	dw	0,0				; requested/actual virtual resolution
	dd	0				; real/prot mode VESA paging function
	;; fields configured by the driver after every mode set
	dw	0				; line offset in this graphics mode
	dw	0a000h,0			; start paragraph of the write and read pages
	db	4				; log2 of page size/4kB
	db	0				; log2 of page size/granularity
	db	0,0, 0,0, 0,0, 0,0		; pixel format descriptors (r, g, b, fill)
	;; fields for future memory mapping and paging extensions
	dd	0				; extended memory (linear) address
	dw	0				; map this many 4 kByte pages at above addr
	dw	0				; 32-bit callable paging function

	extrn	_mode_set_routine:near
	extrn	_paging_routine:near
	extrn	_driver_init_routine:near
	extrn	_text_mode_table:near
	extrn	_graphics_mode_table:near
	extrn	_set_screen_start:near
	extrn	_driver_name:near

	public  _driver_header			; for C code to access header info

_TEXT	ends
	end

