/*** SOURCE3.C - Creates a .3DV file with the definition of 2 curves
	     by Lenimar N. Andrade, ccendm03@brufpb.bitnet
      Dep. of Mathematics - Universidade Federal da Paraba - Brazil ***/

#include <stdio.h>
#include <math.h>
#include <conio.h>
#include <stdlib.h>
#include <time.h>

unsigned nu = 500;
FILE *arq;

/* Parametric equations of the curves */
float f1(float t) { return 2*sin(2*t); }
float f2(float t) { return 2*sin(t)*cos(2*t); }
float f3(float t) { return 2*cos(t)*cos(2*t); }

float g1(float t) { return 1.5*sin(2*t); }
float g2(float t) { return 1.5*sin(t)*cos(2*t); }
float g3(float t) { return 1.5*cos(t)*cos(2*t); }

/* ------------------------------------------------------------------------- */

void CalcPoints2(float umin, float umax) {

  float u, incrU;
  unsigned i;

  incrU = (umax - umin)/nu;

  fprintf(arq, "%u\n", 2*(nu + 1));
  for (u = umin; u < umax + incrU/2; u+= incrU)
    fprintf(arq, "%6.3f %6.3f %6.3f\n", f1(u), f2(u), f3(u));
  for (u = umin; u < umax + incrU/2; u+= incrU)
    fprintf(arq, "%6.3f %6.3f %6.3f\n", g1(u), g2(u), g3(u));

  fprintf(arq, "%u\n", 2*(nu + 1));
  for (i = 1; i <= nu + 1; i++) {
    fprintf(arq, "%u %u\n", i, 0);
    fprintf(arq, "%u %u\n", i + nu + 1, 1 + random(15));
  }
}

/* ------------------------------------------------------------------------- */

void PrintMsg(void) {

  fprintf(arq, "\n%s", "Segments linking f(t) = (2*sin(2*t), "
				   "2*sin(t)*cos(2*t), 2*cos(t)*cos(2*t))");
  fprintf(arq, "\n%s", "             and g(t) = (1.5*sin(2*t),"
			       "1.5*sin(t)*cos(2*t),1.5*cos(t)*cos(2*t))");
  fprintf(arq, "\n%s", "Lenimar Nunes de Andrade, ccendm03@brufpb.bitnet\n");
}

/* ------------------------------------------------------------------------- */

void main(void) {

  time_t x;

  srand((unsigned) time(&x));
  randomize();

  if ((arq = fopen("demo3.3dv", "wt")) == NULL) return;
  CalcPoints2(0, 6.2832);
  PrintMsg();
  fclose(arq);
}

/* ------------------------------------------------------------------------- */

/*** END OF "SOURCE3.C" ***/
