/*** SOURCE1.C - Creates a .3DV file with the definition of a surface
	     by Lenimar N. Andrade, ccendm03@brufpb.bitnet
      Dep. of Mathematics - Universidade Federal da Paraba - Brazil ***/

#include <stdio.h>
#include <math.h>
#include <conio.h>

unsigned nu = 25, nv = 25;
FILE *arq;

/* Parametric equations that define the surface */
float f1(float u, float v) { return sin(v)*cosh(u); }
float f2(float u, float v) { return cos(v)*cosh(u); }
float f3(float u, float v) { return sinh(u); }

/* ------------------------------------------------------------------------- */

void CalcPoints(float umin, float umax, float vmin, float vmax) {

  float u, v, incrU, incrV;
  unsigned i, j;

  incrU = (umax - umin)/nu;
  incrV = (vmax - vmin)/nv;

  fprintf(arq, "%u\n", (nu + 1)*(nv + 1));
  for (v = vmin; v < vmax + incrV/2; v += incrV)
    for (u = umin; u < umax + incrU/2; u+= incrU)
      fprintf(arq, "%6.3f %6.3f %6.3f\n", f1(u, v), f2(u, v), f3(u, v));

  fprintf(arq, "%u\n", 2*(nu + 1)*(nv + 1));
  for (i = 1; i <= (nu + 1)*(nv + 1); i++)
    if (i % (nu + 1) == 1)
      fprintf(arq, "%u %u\n", i, 0);
    else
      fprintf(arq, "%u %u\n", i, DARKGRAY);
  for (i = 1; i <= nu + 1; i++)
    for (j = 0; j <= nv; j++)
      if (j == 0)
	fprintf(arq, "%u %u\n", i + j*(1 + nu), 0);
      else
	fprintf(arq, "%u %u\n", i + j*(1 + nu), RED);
}

/* ------------------------------------------------------------------------- */

void PrintMsg(void) {

  fprintf(arq, "\n%s", "Hyperboloid of one sheet, F(u, v) = (sin(v)*cosh(u), "
						 "cos(v)*cosh(u), sinh(u))");
  fprintf(arq, "\n%s", "Lenimar Nunes de Andrade, ccendm03@brufpb.bitnet\n");
}

/* ------------------------------------------------------------------------- */

void main(void) {

  if ((arq = fopen("demo1.3dv", "wt")) == NULL) return;
  CalcPoints(-2, 2, -3.1416, 3.1416);
  PrintMsg();
  fclose(arq);
}

/* ------------------------------------------------------------------------- */

/*** END OF "SOURCE1.C" ***/
