/* Version 1.00
   September 4, 1995
   clearid.c
   Written by Jerry James
   Compiled with:
      Borland C++ 3.0 (small memory model)
      GCC 2.6.3 (DJGPP 1.12.maint4)

   This program will clear out the ID field for individuals in a PAF 2.x
   database.  Note that each individual record is 92 bytes long.  The ID
   field begins at the 80th byte, and takes up 10 bytes.
*/

#include <stdio.h>
#include <stdlib.h>

char blank_id[10] = { '\0','\0','\0','\0','\0','\0','\0','\0','\0','\0' };

int main()
{
   char ascii_size[12];
   FILE *data;
   register unsigned int i;
   unsigned int size;

   if ((data = fopen("INDIV2.DAT", "r+b")) == NULL)
      {
         fprintf(stderr,
            "Error #%d trying to open \"INDIV2.DAT\" for writing!", errno);
         return EXIT_FAILURE;
      }

   /* Get the size of INDIV2.DAT */
   if (fread(ascii_size, 1, 11, data) < 11)
      {
         fprintf(stderr,
            "Error #%d trying to read the header of \"INDIV2.DAT\"!", errno);
         return EXIT_FAILURE;
      }
   size = atoi(ascii_size);

   /* Set the file pointer to the end of the ID field of 'RIN 0'. */
   if (fseek(data, 90, SEEK_SET) != 0)
      {
         fprintf(stderr,
            "Error #%d trying to seek to RIN 1 of \"INDIV2.DAT\"!", errno);
         return EXIT_FAILURE;
      }

   /* Set all the ID fields to blank */
   for (i = 1; i <= size; i++)
      {
         if (fseek(data, 82, SEEK_CUR) != 0)
            {
               fprintf(stderr,
                  "Error #%d trying to seek to RIN %d of \"INDIV2.DAT\"!",
                  errno, i);
               break;
            }
         if (fwrite(blank_id, 1, 10, data) != 10)
            {
               fprintf(stderr,
                  "Error #%d trying to clear ID of RIN %d of \"INDIV2.DAT\"!",
                  errno, i);
               break;
            }
      }

   fclose(data);
   return EXIT_SUCCESS;
}
