\ STRING SUPPORT LIBRARY PART 1
\ Contents Copyright (C) 1995 by Thomas Almy

\ Permission is granted to registered users of ForthCMP to sell or distribute
\ computer programs incorporating the compiled contents of this file.

\ This file must be loaded BEFORE the application program.
\ Then load STRINGS2.4TH before FORTHLIB.

\ When separate code and data segments are used, beware that
\ string literals are in the code segment.  Use STR>DSEG
\ to move to string buffer ( in DSEG ).


.( Loading STRINGS ) CR
10 DECIMAL

FIND StringSize [IF] DROP [ELSE]

1024 CONSTANT StringSize  \ alter if desired.

\ For instance, to have a 512 byte buffer instead of the default 1024, start
\ the source file "xxx MSDOS  512 CONSTANT StringSize  INCLUDE STRINGS1".

[THEN]

DSEG

0 VALUE STRBUF 
0 VALUE strend

FIND strbufr [IF] DROP [ELSE]

FIND CHAIN-INI [IF] DROP 
0 VALUE strbufr
ASSEMBLER CSEG HERE chIN @ ?DUP [IF] CALL [THEN] chIN ! DSEG FORTH 
\ Automatic dynamic positioning of buffer when CHAIN-INI is used
0 0 IN/OUT : strinit HERE DUP TO strbufr DUP TO STRBUF TO strend 
 StringSize ALLOT ;
[ELSE]
CREATE strbufr  StringSize ALLOT
[THEN]
\ you might also want to put strbufr at some arbitrary high constant
\ location so that the size of the COM/EXE file is not increased:
\   PSIZE StringSize - 1000 ( size of stacks ) - CONSTANT strbufr
\ placed before INCLUDEing this file

strbufr TO STRBUF 
strbufr TO strend

1 0 IN/OUT NEED +STRBUF
2 2 IN/OUT NEED STR>DSEG
2 0 IN/OUT NEED STRCPY
2 1 IN/OUT NEED STRPCK
1 1 IN/OUT NEED ASCIIZ
1 1 IN/OUT NEED -ASCIIZ
2 2 IN/OUT NEED -PATH
2 1 IN/OUT NEED -EXT
2 1 IN/OUT NEED +EXT
0 1 IN/OUT NEED argc
2 1 IN/OUT NEED -ASCIIZL
1 1 IN/OUT NEED argv
2 1 IN/OUT NEED getenv

16 = [IF] HEX [THEN]
