ECHO OFF
ECHO                Move Capital Gainz Data Files
ECHO This batch file moves your data files to another directory.
ECHO You should be in the Capital Gainz directory where you want to
ECHO move the data files from, and should have specified the 
ECHO directory that you want to move the data files to as the lone
ECHO argument. For instance:
ECHO   CD \CAPGNZ
ECHO   CGMOVDAT \CAPGNZ\MYDATA
ECHO It's a good idea to backup your data files first in case a hard 
ECHO drive failure affects the transfer.
ECHO.

IF "%1" == "" GOTO FAIL

ECHO Copy Capital Gainz data files to %1 ? [Y/N]
YESNO
IF ERRORLEVEL 2 GOTO ENDSKIP

ECHO Copy files to %1 ...
REM Try to create dir, in case it does not exist.
MKDIR %1
COPY *.DAT %1
COPY *.K01 %1
COPY CG.STY %1
REM
ECHO Remove original Capital Gainz data files ? [Y/N]
YESNO
IF ERRORLEVEL 2 GOTO END
ECHO Removing original files ...
DEL *.DAT
DEL *.K01
REM The following lines aren't necessary, but it's good to keep copies of
REM these files in the original directory.
COPY %1%\ERROR.DAT .
COPY %1%\PASSWD.DAT .
COPY %1%\PASSWD.K01 .
COPY %1%\CG.STY .
ECHO.
ECHO              Capital Gainz data files moved.
ECHO
ECHO To set the data directory in Capital Gainz, use the Config pulldown
ECHO menu to bring up the System Configuration Form.
ECHO
GOTO END

:FAIL
ECHO You must specify the directory to move the files to.

:END
