ECHO OFF

REM CAPGNZBU.BAT - backup Capital Gainz data files
REM Simple batch file to backup Capital Gainz data files.
REM The data files can be restored with CAPGNZRS.BAT.
REM Single parameter - letter of drive (A or B) to copy files to.

IF "%1" == "" GOTO FAIL

ECHO Backup data files from current directory to drive %1 ? [Y/N]
YESNO
IF ERRORLEVEL 2 GOTO END

IF "%1" == "a" GOTO BACKUPA
IF "%1" == "A" GOTO BACKUPA
IF "%1" == "a:" GOTO BACKUPA
IF "%1" == "A:" GOTO BACKUPA

IF "%1" == "b" GOTO BACKUPB
IF "%1" == "B" GOTO BACKUPB
IF "%1" == "b:" GOTO BACKUPB
IF "%1" == "B:" GOTO BACKUPB

GOTO FAIL

:BACKUPA
REM Delete any existing data files.
IF EXIST A:*.DAT DEL A:*.DAT
IF EXIST A:*.K01 DEL A:*.K01
IF EXIST A:CG.STY DEL A:CG.STY

REM If you run out of disk space, you can replace the COPY commands
REM below with commands that use a data compressor, such as PKZIP:
REM  PKZIP -U A:CGDATA.ZIP *.DAT *.K01 CG.STY

COPY *.DAT A:
COPY *.K01 A:
COPY CG.STY A:
GOTO ENDOK

:BACKUPB
REM Delete any existing data files.
IF EXIST B:*.DAT DEL B:*.DAT
IF EXIST B:*.K01 DEL B:*.K01
IF EXIST B:CG.STY DEL B:CG.STY

REM If you run out of disk space, you can replace the COPY commands
REM below with commands that use a data compressor, such as PKZIP:
REM  PKZIP -U B:CGDATA.ZIP *.DAT *.K01 CG.STY

COPY *.DAT B:
COPY *.K01 B:
COPY CG.STY B:
GOTO ENDOK

:ENDOK
ECHO Backup Succeeded !
PAUSE
GOTO END

:FAIL
ECHO Backup Failed - Can only backup to Drive A or B.
PAUSE

:END
