/*
 * Decompiled with CFR 0.152.
 */
package net.n3.nanoxml;

import java.io.CharArrayReader;
import java.io.IOException;
import java.io.Reader;
import net.n3.nanoxml.IXMLEntityResolver;
import net.n3.nanoxml.IXMLReader;
import net.n3.nanoxml.XMLParseException;
import net.n3.nanoxml.XMLValidationException;

class XMLUtil {
    static void skipComment(IXMLReader iXMLReader, IXMLEntityResolver iXMLEntityResolver) throws IOException, XMLParseException {
        if (iXMLReader.read() != '-') {
            XMLUtil.skipTag(iXMLReader, '\u0000', iXMLEntityResolver);
            return;
        }
        int n = 0;
        block4: while (true) {
            char c = iXMLReader.read();
            switch (c) {
                case '-': {
                    ++n;
                    continue block4;
                }
                case '>': {
                    if (n != 2) break;
                    return;
                }
            }
            n = 0;
        }
    }

    static void skipTag(IXMLReader iXMLReader, char c, IXMLEntityResolver iXMLEntityResolver) throws IOException, XMLParseException {
        int n = 1;
        while (n > 0) {
            char c2 = XMLUtil.read(iXMLReader, null, c, iXMLEntityResolver);
            switch (c2) {
                case '<': {
                    ++n;
                    break;
                }
                case '>': {
                    --n;
                    break;
                }
            }
        }
    }

    static String scanPublicID(StringBuffer stringBuffer, IXMLReader iXMLReader, char c, IXMLEntityResolver iXMLEntityResolver) throws IOException, XMLParseException {
        if (!XMLUtil.checkLiteral(iXMLReader, c, iXMLEntityResolver, "UBLIC")) {
            return null;
        }
        XMLUtil.skipWhitespace(iXMLReader, c, null, null);
        stringBuffer.append(XMLUtil.scanString(iXMLReader, c, false, iXMLEntityResolver));
        XMLUtil.skipWhitespace(iXMLReader, c, null, null);
        return XMLUtil.scanString(iXMLReader, c, false, iXMLEntityResolver);
    }

    static String scanSystemID(IXMLReader iXMLReader, char c, IXMLEntityResolver iXMLEntityResolver) throws IOException, XMLParseException {
        if (!XMLUtil.checkLiteral(iXMLReader, c, iXMLEntityResolver, "YSTEM")) {
            return null;
        }
        XMLUtil.skipWhitespace(iXMLReader, c, null, null);
        return XMLUtil.scanString(iXMLReader, c, false, iXMLEntityResolver);
    }

    static String scanIdentifier(IXMLReader iXMLReader, char c, IXMLEntityResolver iXMLEntityResolver) throws IOException, XMLParseException {
        char c2;
        StringBuffer stringBuffer = new StringBuffer();
        while ((c2 = XMLUtil.read(iXMLReader, null, c, iXMLEntityResolver)) == '_' || c2 == ':' || c2 == '-' || c2 == '.' || c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z' || c2 >= '0' && c2 <= '9' || c2 > '~') {
            stringBuffer.append(c2);
        }
        iXMLReader.unread(c2);
        return stringBuffer.toString();
    }

    static String scanString(IXMLReader iXMLReader, char c, boolean bl, IXMLEntityResolver iXMLEntityResolver) throws IOException, XMLParseException {
        StringBuffer stringBuffer = new StringBuffer();
        boolean[] blArray = new boolean[1];
        char c2 = XMLUtil.read(iXMLReader, null, c, iXMLEntityResolver);
        if (c2 != '\'' && c2 != '\"') {
            XMLUtil.errorExpectedInput(iXMLReader.getSystemID(), iXMLReader.getLineNr(), "delimited string");
        }
        while (true) {
            char c3 = XMLUtil.read(iXMLReader, blArray, c, iXMLEntityResolver);
            if (!blArray[0] && c3 == c) {
                iXMLReader.startNewStream(XMLUtil.scanEntity(blArray, iXMLReader, c, iXMLEntityResolver));
                c3 = iXMLReader.read();
            }
            if (!blArray[0] && c3 == c2) break;
            if (bl && c3 < ' ') {
                stringBuffer.append(' ');
                continue;
            }
            stringBuffer.append(c3);
        }
        return stringBuffer.toString();
    }

    static Reader scanEntity(boolean[] blArray, IXMLReader iXMLReader, char c, IXMLEntityResolver iXMLEntityResolver) throws IOException, XMLParseException {
        char c2 = iXMLReader.read();
        StringBuffer stringBuffer = new StringBuffer();
        while (c2 != ';') {
            stringBuffer.append(c2);
            c2 = iXMLReader.read();
        }
        String string = stringBuffer.toString();
        if (string.charAt(0) == '#') {
            if (blArray != null) {
                blArray[0] = true;
            }
            char[] cArray = new char[]{string.charAt(1) == 'x' ? (char)Integer.parseInt(string.substring(2), 16) : (char)Integer.parseInt(string.substring(1), 10)};
            return new CharArrayReader(cArray);
        }
        Reader reader = iXMLEntityResolver.getEntity(iXMLReader, string);
        if (reader == null) {
            XMLUtil.errorInvalidEntity(iXMLReader.getSystemID(), iXMLReader.getLineNr(), string);
        }
        return reader;
    }

    static void skipWhitespace(IXMLReader iXMLReader, char c, StringBuffer stringBuffer, boolean[] blArray) throws IOException {
        char c2;
        if (stringBuffer == null) {
            while ((c2 = iXMLReader.read()) == ' ' || c2 == '\t' || c2 == '\n' || c2 == '\r') {
            }
        } else {
            while ((c2 = iXMLReader.read()) == ' ' || c2 == '\t' || c2 == '\n' || c2 == '\r') {
                stringBuffer.append(c2);
            }
        }
        iXMLReader.unread(c2);
        if (blArray != null) {
            blArray[0] = c2 == c;
        }
    }

    static char read(IXMLReader iXMLReader, boolean[] blArray, char c, IXMLEntityResolver iXMLEntityResolver) throws IOException, XMLParseException {
        char c2 = iXMLReader.read();
        if (blArray != null) {
            blArray[0] = false;
        }
        if (c2 == c) {
            boolean[] blArray2 = new boolean[1];
            iXMLReader.startNewStream(XMLUtil.scanEntity(blArray2, iXMLReader, c, iXMLEntityResolver));
            if (blArray2[0]) {
                c2 = iXMLReader.read();
                if (blArray != null) {
                    blArray[0] = true;
                }
            } else {
                c2 = XMLUtil.read(iXMLReader, null, c, iXMLEntityResolver);
            }
        }
        return c2;
    }

    static boolean checkLiteral(IXMLReader iXMLReader, char c, IXMLEntityResolver iXMLEntityResolver, String string) throws IOException, XMLParseException {
        int n = 0;
        while (n < string.length()) {
            char c2 = XMLUtil.read(iXMLReader, null, c, iXMLEntityResolver);
            if (c2 != string.charAt(n)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    static void errorExpectedInput(String string, int n, String string2) throws XMLParseException {
        throw new XMLParseException(string, n, "Expected: " + string2);
    }

    static void errorInvalidEntity(String string, int n, String string2) throws XMLParseException {
        throw new XMLParseException(string, n, "Invalid entity: `&" + string2 + ";'");
    }

    static void errorInvalidInput(String string, int n, String string2) throws XMLParseException {
        throw new XMLParseException(string, n, "Invalid input: " + string2);
    }

    static void errorWrongClosingTag(String string, int n, String string2, String string3) throws XMLParseException {
        throw new XMLParseException(string, n, "Closing tag does not match opening tag: `" + string3 + "' != `" + string2 + "'");
    }

    static void errorClosingTagNotEmpty(String string, int n) throws XMLParseException {
        throw new XMLParseException(string, n, "Closing tag must be empty");
    }

    static void errorMissingElement(String string, int n, String string2, String string3) throws XMLValidationException {
        throw new XMLValidationException(1, string, n, string3, null, null, "Element " + string2 + " expects to have a " + string3);
    }

    static void errorUnexpectedElement(String string, int n, String string2, String string3) throws XMLValidationException {
        throw new XMLValidationException(2, string, n, string3, null, null, "Unexpected " + string3 + " in a " + string2);
    }

    static void errorMissingAttribute(String string, int n, String string2, String string3) throws XMLValidationException {
        throw new XMLValidationException(3, string, n, string2, string3, null, "Element " + string2 + " expects an attribute named " + string3);
    }

    static void errorUnexpectedAttribute(String string, int n, String string2, String string3) throws XMLValidationException {
        throw new XMLValidationException(4, string, n, string2, string3, null, "Element " + string2 + " did not expect an attribute " + "named " + string3);
    }

    static void errorInvalidAttributeValue(String string, int n, String string2, String string3, String string4) throws XMLValidationException {
        throw new XMLValidationException(5, string, n, string2, string3, string4, "Invalid value for attribute " + string3);
    }

    static void errorMissingPCData(String string, int n, String string2) throws XMLValidationException {
        throw new XMLValidationException(6, string, n, null, null, null, "Missing #PCDATA in element " + string2);
    }

    static void errorUnexpectedPCData(String string, int n, String string2) throws XMLValidationException {
        throw new XMLValidationException(7, string, n, null, null, null, "Unexpected #PCDATA in element " + string2);
    }

    static void validationError(String string, int n, String string2, String string3, String string4, String string5) throws XMLValidationException {
        throw new XMLValidationException(0, string, n, string3, string4, string5, string2);
    }

    XMLUtil() {
    }
}

