/**************************************************************************
 *
 *      Program name : READK.C
 *
 *	Written By : Eng-Huat Ong and Kian-Mong Low.
 *
 *      This program reads the ON and DC arrays from keyboard input and
 *      stores them in an ASCII file "in.dat".
 *
 * --------------------------------------------------------------------------
 *	Copyright (c) 1992. All Rights Reserved. Nanyang Technological
 *	University.
 *
 *	You are free to use, copy and distribute this software and its
 *	documentation providing that:
 *
 *		NO FEE IS CHARGED FOR USE, COPYING OR DISTRIBUTION.
 *
 *		IT IS NOT MODIFIED IN ANY WAY.
 *
 *		THE COPYRIGHT NOTICE APPEAR IN ALL COPIES.
 *
 *	This program is provided "AS IS" without any warranty, expressed or
 *	implied, including but not limited to fitness for any particular
 *	purpose.
 *
 *	If you find NTUMIN fast, easy, and useful, a note or comment would be
 *	appreciated. Please send to:
 *
 *		Boon-Tiong Tan or Othman Bin Ahmad
 *		School of EEE
 *		Nanyang Technological University
 *		Nanyang Avenue
 *		Singapore 2263
 *		Republic of Singapore
 *
 ***************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

void           readk(ondc,n)
unsigned char  ondc, n;

{
   unsigned short  i=0, p;
   unsigned char   *cube, error, j;
   void            errsound();
   FILE            *in;


   if (ondc == 0)                                      /* ON array */
      {
	 if ((in = fopen("in.dat", "w+")) == NULL)     /* open input file */
	    {
	       printf("Error opening file, in.dat.\n");
	       printf("Program terminated\n");
	       exit(0);
	    }
	 fprintf(in, "%d\n", n);                       /* print to file */
      }
   else                                                /* DC array */
      if ((in = fopen("in.dat", "a")) == NULL)   /* open input file as 'append' */
	 {
	    printf("Error opening file, in.dat.\n");
	    printf("Program terminated\n");
	    exit(0);
	 }

   printf("Enter number of cubes -> ");
   scanf("%d", &p);                            /* read cubes from keyboard */
   fprintf(in, "%d\n", p);                     /* and print to input file */

   cube = (unsigned char *) malloc(n+10);      /* space for cube + 10 */
   if (cube==0)
      {
	 printf("Out of memory -- READK, *cube \n");
	 printf("Program terminated - 1\n");
	 exit(0);
      }

   while (++i <= p)                             /* do for all cubes */
      {
	 error = 0;                             /* reset to no error */
	 printf("Enter cube number %d -> ", i);
	 scanf("%s", cube);                     /* get cube from keyboard */

	 if (strlen(cube) != n)                 /* wrong no. of var */
	    {
	       errsound();
	       printf("Invalid number of variables !\n");
	       i--;
	       error = 1;                      /* set error status */
	    }

	 else
	    {
	       for (j=0; j<n; j++)               /* check fo valid char */
		  {
		     if (*(cube+j)!='1' && *(cube+j)!='0' && *(cube+j)!='x' && *(cube+j)!='X')
			{
			   errsound();
			   printf("Invalid character(s) in input !\n");
			   i--;
			   error = 1;            /* set error status */
			   break;
			}
		  }
	    }

	 if (!error)                        /* no error, print to file */
	 fprintf(in, "%s\n", cube);
      }

   free(cube);                /* free pointer */
   fclose(in);                /* close file */
}
