{ this is a set of utilities (procedures) used by PAINT.
    Window (num, MenuItem)
    ResetWin (num)
    ClrWin (num)
    flash (prompt)
    getchar (prompt) --> char
    verify (MenuItem) --> boolean

    dab (x,y, brush)
    wpage (width, height)
    boxpage (width, height)
}

procedure window ( num : WinID; message : MenuItem);
    { write a message on the next line of the indicated window }
    begin
        GoToXY (RIGHT-WinWidth, linecount [num]);
        write (message);
        linecount [num] := linecount[num] +1;
    end;

procedure ResetWin (num : WinID);
    begin
        if num=1 then linecount [1] := 1
            else      linecount [2] := WinHite + 1;
    end;

procedure ClrWin (num : WinID);
    var    x,y, ymin,ymax : integer;
    begin
        if num=1 then begin  ymin:=1; ymax:=WinHite;  end
           else   begin  ymin:=WinHite+1; ymax:=25;  end;
        for y:=ymin to ymax do
        begin
            GoToXY (RIGHT-WinWidth, y);
            for x:=1 to WinWidth do  write (' ');
        end;
        linecount [2] := WinHite + 1;
    end;

procedure flash (msg : prompt);
  { show a 5-line message in window 2 for  3 seconds }
    var    i : integer;
    begin
        ClrWin (2);
        for i:=1 to 5 do
            window (2, msg [i]);
        delay (3000);
        ClrWin (2);
    end;

function getchar (msg : prompt) : char;
  { puts a 5-line prompt on the screen, then waits for keystroke }
  { returns the result of the keystroke  }
    var    i : integer;
           inchar : char;
    begin
        ClrWin (2);
        ErrMsg := msg [1];  (* will be displayed by "blink" *)
        window (2, '');
        for i:=2 to 5 do
            window (2, msg [i]);
        blink;
        read (kbd, inchar);
        getchar := inchar;
    end;

function verify (msg : MenuItem) : boolean;
    var    inchar : char;
    begin
        ClrWin (2);
        window (2, msg);
        window (2, '  (Y/N)');
        read (kbd, inchar);
        if (inchar='y') or (inchar='Y') then verify := TRUE
                                        else verify := FALSE;
        ClrWin (2);
    end;


procedure dab (x,y,brush : integer);
    type   brushes = array [0..MAXBRUSH, 0..2] of byte;
           mask  =  array [0..1] of byte;
    const  b_palette : brushes = ((0,0,0),     (* brush = 0  *)
                                (0,0,0),     (*   "   " 1  *)
                                (8,0,2),     (*         2  *)
                                (10,5,10),   (*         3  *)
                                (7,11,13),   (*         4  *)
                                (15,15,15),  (*         5  *)
                                (0,0,0),     (*         6  *)
                                (0,0,0),     (*         7  *)
                                (0,0,0),     (*         8  *)
                                (0,0,0),     (*         9  *)
                                (2,2,2),     (*  10 = |    *)
                                (0,15,0),    (*  11 = -    *)
                                (2,15,2),    (*  12 = +    *)
                                (8,6,1),     (*  13 = \    *)
                                (1,6,8),     (*  14 = /    *)
                                (9,6,9));     (*  15 = X    *)
           half : mask = ($F0, $0F);
           shifter : mask = (16,1);
           PIXBASE = $B800;
    var    xodd, yodd, bytA : integer;
           xmap, ymap : integer;
           j : integer;
           point : ^byte;
    begin
        ymap := y*ycell;   (* ymap = row of raster *)
        xmap := x div 2;   (* xmap = byte in x-raster *)
        xodd := x mod 2;   (* left or right half of byte *)
        for j:=0 to 2 do
        begin
            (* get a pointer to the byte to be modified *)
            yodd := ymap mod 2;
            bytA := ymap div 2 * 80  +  yodd * 8192  +  xmap;
            point := ptr (PIXBASE, bytA);

            (* now write the palette entry into the half-byte *)
            point^ := (point^ and half [1-xodd]) or
                        (b_palette [brush, j] * shifter [xodd]);
            ymap := ymap + 1;    (* bump the line counter *)
        end;
    end;

procedure wpage (width, hite : integer);
    { wpage whites out the page for background color }
    const  PIXBASE = $B800;
    var    x,y : integer;
           bytA : ^byte;
    begin
        for x:=0 to (width div 8) do
            for y:=0 to (hite div 2) do
            begin
                bytA:=ptr(PIXBASE, y*80 + x);
                bytA^:=255;
                bytA:=ptr(PIXBASE, $2000 + y*80 +x);
                bytA^:=255;
            end;
    end;

procedure boxpage (width, hite : integer);
    { boxpage takes a black-bkgnd page and outlines it }
    var    x,y : integer;
    begin
        for x:=0 to (width-1) do
        begin
            pixel (x, 0, 1);
            pixel (x, hite-1, 1);
        end;
        for y:=0 to (hite-1) do
        begin
            pixel (0, y, 1);
            pixel (width-1, y, 1);
        end;
    end;

