/* Copyright (C) Stephen Chung, 1991-1993.  All rights reserved. */

#include "jwp.h"

#include "idm.h"

#include <dir.h>
#include <sys/stat.h>

static long int percent, ohpercent;
static int HeaderNum;
static BOOL LeftRight;

static char *filespec = NULL;
static KANJI far *criteria[NRSUMMARIES] = { NULL, NULL, NULL, NULL, NULL };
static char *FileInfoName;

extern BOOL Dialogs3D;

#define PARENTDIR   "<Go Up>"
#define DRIVECHAR   '['
#define FILENAMELEN 15
#define NRQUICKFILE 4

#define NRPROGS     4


static char *QuickFiles[NRQUICKFILE];

#define TPLBLOCKSIZE    5

typedef struct {
    char far *filename;
    KANJI far *desc;
} TPLFILE;

char far *TplChosen = NULL;
static TPLFILE far *Templates = NULL;
static int nr_templates = 0;



BOOL FAR PASCAL StatisticsProc (HWND hwnd, WORD message, WORD wParam, LONG lParam)
{
    long int allocated, requests, hits, usage, overhead;
    long int len;
	int      num;
	HWND	 barhwnd;
	RECT     rect;
	HDC      hdc;
    char     buffer[BUFSIZE];

    switch (message) {

        case WM_INITDIALOG:
            FontCacheStatistics (&num, &usage, &requests, &hits);
            sprintf(buffer, "%d Font Cache%s:", num, (num > 1) ? "s" : "");
            SetDlgItemText(hwnd, 4201, buffer);
            if (requests > 0L) {
                sprintf(buffer, "%ld / %ld  (%d%%)  %ld cached",
                            hits, requests, (int) (100.0 * ((double) hits) / ((double) requests)), usage);
			} else {
				sprintf(buffer, "%ld cached", usage);
            }
            SetDlgItemText(hwnd, 4202, buffer);

            ConvCacheStatistics (&usage, &requests, &hits);
            if (requests > 0L) {
                sprintf(buffer, "%ld / %ld  (%d%%)  %ld cached",
                            hits, requests, (int) (100.0 * ((double) hits) / ((double) requests)), usage);
            } else {
                sprintf(buffer, "%ld cached", usage);
            }
            SetDlgItemText(hwnd, 4212, buffer);

            if (global.active != NULL) {
                sprintf(buffer, "%ld character%s", global.active->nr_bytes,
							(global.active->nr_bytes > 1L) ? "s" : "");
                SetDlgItemText(hwnd, 4221, buffer);

                if (global.active->undolevels > 0) {
                    sprintf(buffer, "%d change%s retained", global.active->undolevels,
                            (global.active->undolevels > 1) ? "s" : "");
                } else {
                    strcpy(buffer, "No changes retained");
                }
                SetDlgItemText(hwnd, 4222, buffer);
            } else {
                SetDlgItemText(hwnd, 4221, "No active file");
			}

            CountMemoryUsage(&allocated, &usage, &overhead);

            sprintf(buffer,"Memory Usage Efficiency (%ldK Allocated):", (allocated / 1024L) + 1);
            SetDlgItemText(hwnd, 4231, buffer);

            percent = (((usage + overhead) * 100L) / allocated) + 1L;
            if (percent > 100L) percent = 100L;

            ohpercent = ((usage * 100L) / allocated) + 1L;
            if (ohpercent > 100L) ohpercent = 100L;

			sprintf(buffer,"%ld%%", percent);
            SetDlgItemText(hwnd, 4233, buffer);

            CenterDialogBox(hwnd);

			return (TRUE);

        case WM_PAINT:
            barhwnd = GetDlgItem(hwnd, 4232);
			GetClientRect(barhwnd, &rect);

			len = (rect.right - 4) * percent / 100L;

			hdc = GetDC(barhwnd);
			SelectObject(hdc, GetStockObject(GRAY_BRUSH));
			Rectangle(hdc, 2, 2, len + 2, rect.bottom - 2);

            len = (rect.right - 4) * ohpercent / 100L;
            if (Dialogs3D) {
                SelectObject(hdc, GetStockObject(BLACK_BRUSH));
            } else {
                SelectObject(hdc, GetStockObject(LTGRAY_BRUSH));
            }
			Rectangle(hdc, 2, 2, len + 2, rect.bottom - 2);
			ReleaseDC(barhwnd, hdc);
			break;

        case WM_KEYDOWN:
            switch (wParam) {
                case VK_ESCAPE: SendMessage(hwnd, WM_COMMAND, IDOK, 0L);
                                return (TRUE);
            }
            break;

        case WM_COMMAND:
            switch (wParam) {
                case IDOK:
                case IDCANCEL:  EndDialog(hwnd, 0); return (TRUE);
            }
            break;
    }

    return (FALSE);
}



BOOL FAR PASCAL SummaryProc (HWND hwnd, WORD message, WORD wParam, LONG lParam)
{
    switch (message) {
		case WM_INITDIALOG: {
			int i, len;
			FILEOPTIONS *f, *f1;
			KANJI buffer[MAXLINELEN];

			/* Set the type and mode-change icon of the Jedit controls */

			f1 = global.active;

			for (i = 0; i < NRSUMMARIES; i++) {
				SendDlgItemMessage(hwnd, 4201 + i, EM_SETRECT, GetDlgItem(hwnd, 4211), 0L);
				f = (FILEOPTIONS *) SendDlgItemMessage(hwnd, 4201 + i, EM_GETHANDLE, 0, 0L);

				if (f1 != NULL && f1->summary[i] != NULL) {
					kanjicpy(buffer, f1->summary[i]);
					SendDlgItemMessage(hwnd, 4201 + i, EM_REPLACESEL, 0, (LONG) buffer);
                } else {
                    buffer[0] = 0;
                }
				if (i == 0) {
                    len = kanjilen(buffer);
                    SendDlgItemMessage(hwnd, 4211, EM_SETHANDLE, f->hwnd, 0L);  /* icon-change */
                }
			}

			if (len > 0) SendDlgItemMessage(hwnd, 4201, EM_SETSEL, len, MAKELONG(0, len - 1));
			SetFocus(GetDlgItem(hwnd, 4201));
            CenterDialogBox(hwnd);
            return (TRUE);
        }

		case WM_PAINT: {
			int i;
            HDC hdc;
			PAINTSTRUCT ps;

			hdc = BeginPaint(hwnd, &ps);

            for (i = 0; i < NRSUMMARIES; i++) DrawBoundingBox(hwnd, hdc, 4201 + i);

            EndPaint(hwnd, &ps);
			return (TRUE);
		}

        case WM_COMMAND: {
			int i, j, len;
			KANJI far *kp;
			UNIT far *up;

            switch (wParam) {
                case IDOK:
                    if (global.active != NULL) {
                        for (i = 0; i < NRSUMMARIES; i++) {
                            up = (UNIT far *) SendDlgItemMessage(hwnd, 4201 + i, EM_GETLINE, 0, 0L);
                            len = unitlen(up);

                            if (len <= 0) {
								if (global.active->summary[i] != NULL) {
                                    FreeBlock(global.active->summary[i]);
                                    global.active->summary[i] = NULL;
                                }
                            } else {
                                kp = global.active->summary[i];
                                if (kp == NULL) {
                                    kp = (KANJI far *) BlockAlloc((len + 5) * sizeof(KANJI));
                                } else if ((SegHeapGetSize(kp) / sizeof(KANJI)) < len + 5) {
                                    FreeBlock(kp);
                                    kp = (KANJI far *) BlockAlloc((len + 5) * sizeof(KANJI));
                                }
                                for (j = 0; up[j].kanji; j++) kp[j] = up[j].kanji;
								kp[j] = 0;
                                global.active->summary[i] = kp;
                            }
                        }
                    }
                    EndDialog(hwnd, TRUE);
                    return (TRUE);

                case IDCANCEL:
                    EndDialog(hwnd, FALSE);
                    return (TRUE);
            }
            break;
		}
    }
    return (FALSE);
}



BOOL FAR PASCAL EditHeaderProc (HWND hwnd, WORD message, WORD wParam, LONG lParam)
{
    switch (message) {
		case WM_INITDIALOG: {
            int i, len;
            FILEOPTIONS *f;
            KANJI far *kp;

            if (LeftRight) {
                switch (HeaderNum) {
                    case 0: SetWindowText(hwnd, "Edit Left Page Header"); break;
                    case 1: SetWindowText(hwnd, "Edit Right Page Header"); break;
                    case 2: SetWindowText(hwnd, "Edit Left Page Footer"); break;
                    case 3: SetWindowText(hwnd, "Edit Right Page Footer"); break;
                }
            } else {
                switch (HeaderNum) {
                    case 1:
                    case 0: SetWindowText(hwnd, "Edit Header"); break;
                    case 3:
                    case 2: SetWindowText(hwnd, "Edit Footer"); break;
                }
            }

            /* Set the type and mode-change icon */
            for (i = 0; i < NRHEADERS; i++) {
                SendDlgItemMessage(hwnd, 4201 + i, EM_SETRECT, GetDlgItem(hwnd, 4211), 0L);
                kp = global.active->header[HeaderNum][i];
                if (kp != NULL) {
                    SendDlgItemMessage(hwnd, 4201 + i, EM_REPLACESEL, 0, (LONG) kp);
                    len = kanjilen(kp);
                    if (i == 0 && len > 0) {
                        SendDlgItemMessage(hwnd, 4201, EM_SETSEL, len, MAKELONG(0, len - 1));
                    }
                }
            }

            f = (FILEOPTIONS *) SendDlgItemMessage(hwnd, 4201, EM_GETHANDLE, 0, 0L);
            SendDlgItemMessage(hwnd, 4211, EM_SETHANDLE, f->hwnd, 0L);  /* Mode-change icon */
            SetFocus(GetDlgItem(hwnd, 4201));

            CenterDialogBox(hwnd);
            return (TRUE);
        }

        case WM_PAINT: {
            int i;
            HDC hdc;
			PAINTSTRUCT ps;

			hdc = BeginPaint(hwnd, &ps);

            for (i = 0; i < NRHEADERS; i++) DrawBoundingBox(hwnd, hdc, 4201 + i);

            EndPaint(hwnd, &ps);
			return (TRUE);
		}

        case WM_COMMAND:
            switch (wParam) {
                case IDOK: {
                    int i, j, len;
                    UNIT far *up;
                    KANJI far *kp;

                    for (i = 0; i < NRHEADERS; i++) {
                        up = (UNIT far *) SendDlgItemMessage(hwnd, 4201 + i, EM_GETLINE, 0, 0L);
                        len = unitlen(up);

                        if (len <= 0) {
                            if (global.active->header[HeaderNum][i] != NULL) {
                                FreeBlock(global.active->header[HeaderNum][i]);
                                global.active->header[HeaderNum][i] = NULL;
                            }
                        } else {
                            kp = global.active->header[HeaderNum][i];
                            if (kp == NULL) {
                                kp = (KANJI far *) BlockAlloc((len + 5) * sizeof(KANJI));
                            } else if ((SegHeapGetSize(kp) / sizeof(KANJI)) < len + 5) {
                                FreeBlock(kp);
                                kp = (KANJI far *) BlockAlloc((len + 5) * sizeof(KANJI));
                            }
                            for (j = 0; up[j].kanji; j++) kp[j] = up[j].kanji;
                            kp[j] = 0;
                            global.active->header[HeaderNum][i] = kp;
                        }
                    }

                    EndDialog(hwnd, TRUE);
                    return (TRUE);
                }

                case IDCANCEL:
                    EndDialog(hwnd, FALSE);
                    return (TRUE);
            }
            break;
    }
    return (FALSE);
}



BOOL FAR PASCAL HeaderProc (HWND hwnd, WORD message, WORD wParam, LONG lParam)
{
    switch (message) {
		case WM_INITDIALOG: {
            if (global.active->lrheader) {
                LeftRight = TRUE;

                SendDlgItemMessage(hwnd, 4211, LB_ADDSTRING, 0, (LONG) "Left Header");
                SendDlgItemMessage(hwnd, 4211, LB_ADDSTRING, 0, (LONG) "Right Header");
                SendDlgItemMessage(hwnd, 4211, LB_ADDSTRING, 0, (LONG) "Left Footer");
                SendDlgItemMessage(hwnd, 4211, LB_ADDSTRING, 0, (LONG) "Right Footer");
            } else {
                LeftRight = FALSE;

                SendDlgItemMessage(hwnd, 4211, LB_ADDSTRING, 0, (LONG) "Header");
                SendDlgItemMessage(hwnd, 4211, LB_ADDSTRING, 0, (LONG) "Footer");
            }

            SendDlgItemMessage(hwnd, 4211, LB_SETCURSEL, 0, 0L);

            CheckDlgButton(hwnd, 4221, global.active->lrheader);
            CheckDlgButton(hwnd, 4222, global.active->nofirstpage);

            CenterDialogBox(hwnd);
            return (TRUE);
        }

        case WM_COMMAND:
            switch (wParam) {
				case 4211:
                    if (HIWORD(lParam) == LBN_DBLCLK) {
                        SendMessage(hwnd, WM_COMMAND, 4201, MAKELONG(GetDlgItem(hwnd, 4201), BN_CLICKED));     /* Edit button */
                    }
                    return (TRUE);

                case 4221:      /* Left/Right headers */
                    if (LeftRight != IsDlgButtonChecked(hwnd, 4221)) {
                        LeftRight = IsDlgButtonChecked(hwnd, 4221);

                        SendDlgItemMessage(hwnd, 4211, WM_SETREDRAW, FALSE, 0L);
                        SendDlgItemMessage(hwnd, 4211, LB_RESETCONTENT, 0, 0L);
                        if (LeftRight) {
                            SendDlgItemMessage(hwnd, 4211, LB_ADDSTRING, 0, (LONG) "Left Header");
                            SendDlgItemMessage(hwnd, 4211, LB_ADDSTRING, 0, (LONG) "Right Header");
                            SendDlgItemMessage(hwnd, 4211, LB_ADDSTRING, 0, (LONG) "Left Footer");
                            SendDlgItemMessage(hwnd, 4211, LB_ADDSTRING, 0, (LONG) "Right Footer");
                        } else {
                            SendDlgItemMessage(hwnd, 4211, LB_ADDSTRING, 0, (LONG) "Header");
                            SendDlgItemMessage(hwnd, 4211, LB_ADDSTRING, 0, (LONG) "Footer");
                        }
                        SendDlgItemMessage(hwnd, 4211, LB_SETCURSEL, 0, 0L);
                        SendDlgItemMessage(hwnd, 4211, WM_SETREDRAW, TRUE, 0L);
                        InvalidateRect(hwnd, NULL, TRUE);
                    }
                    return (TRUE);

                case 4201: {    /* Edit */
                    int i;

                    i = SendDlgItemMessage(hwnd, 4211, LB_GETCURSEL, 0, 0L);
                    if (i == LB_ERR) {
                        MessageBeep(0);
                        return (TRUE);
                    }

                    if (LeftRight) {
                        HeaderNum = i;
                    } else {
                        HeaderNum = i * 2;
                    }

                    i = DialogBox (hInstance, "EditHeader", hwnd, EditHeaderProc);

					if (i) ShowWindow(GetDlgItem(hwnd, IDCANCEL), SW_HIDE);

                    return (TRUE);
                }

                case IDOK:
                    global.active->lrheader = IsDlgButtonChecked(hwnd, 4221);
                    global.active->nofirstpage = IsDlgButtonChecked(hwnd, 4222);
                    EndDialog(hwnd, FALSE);
                    return (TRUE);

                case IDCANCEL:
                    EndDialog(hwnd, TRUE);
                    return (TRUE);
            }
            break;
    }

    return (FALSE);
}



static int SearchForFiles (HWND hwnd, KANJI *buffer, BOOL recurrsive)
{
    int i, k, n, len, fd;
    int num = 0, dirs = 0;
    char *cp;
    BOOL hascriteria = FALSE;
    OFSTRUCT of;
    struct ffblk ffblk;
	FILEHEADER header;


    for (i = 0; i < NRSUMMARIES; i++) {
        if (criteria[i] != NULL) hascriteria = TRUE;
    }

    /* Get sub-directories */

    if (recurrsive && findfirst("*.*", &ffblk, FA_RDONLY | FA_DIREC) == 0) {
        do {
            if (ffblk.ff_name[0] == '.') continue;
            if (!(ffblk.ff_attrib & FA_DIREC)) continue;
            dirs++;
        } while (findnext(&ffblk) == 0);

        if (dirs > 0) {
            i = 0;
            cp = (char *) MemAlloc(dirs * FILENAMELEN);

            findfirst("*.*", &ffblk, FA_RDONLY | FA_DIREC);

            do {
                if (ffblk.ff_name[0] == '.') continue;
                if (!(ffblk.ff_attrib & FA_DIREC)) continue;
                strcpy(cp + i * FILENAMELEN, ffblk.ff_name);
                i++;
            } while (findnext(&ffblk) == 0);
        }
    }


    /* Get files */

    if (findfirst(filespec == NULL ? "*.*" : filespec, &ffblk, FA_RDONLY) == 0) {
        do {
            if (ffblk.ff_name[0] == '.') continue;
            if (ffblk.ff_attrib & FA_DIREC) continue;

            fd = OpenFile(ffblk.ff_name, &of, OF_READ);
            if (fd < 0) continue;

            StatusMessage(of.szPathName);

            if (hascriteria) {
                lseek(fd, 0L, 0);
                read (fd, &header, sizeof(FILEHEADER));
                if (header.magic == MAGIC && header.summary) {
                    for (i = 0; i < NRSUMMARIES; i++) {
                        read(fd, &n, sizeof(int));
                        if (n > 0) read(fd, (char *) buffer, n * sizeof(KANJI));
                        if (criteria[i] == NULL) continue;

                        len = kanjilen(criteria[i]);
                        if (n < len) break;
                        for (k = 0; k < n - len; k++) {
                            if (!kanjincmp(criteria[i], buffer + k, len)) break;
                        }
                        if (k >= n - len) break;
                    }

                    if (i >= NRSUMMARIES) {
                        SendMessage(hwnd, LB_ADDSTRING, 0, (LONG) ((char far *) &of.szPathName));
                        num++;
                    }
                    }
            } else {
                SendMessage(hwnd, LB_ADDSTRING, 0, (LONG) ((char far *) &of.szPathName));
                num++;
            }
            close(fd);
        } while (findnext(&ffblk) == 0);
    }


    /* Recurrse into sub-directories */

    if (dirs > 0) {
        for (i = 0; i < dirs; i++) {
            if (chdir(cp + i * FILENAMELEN) < 0) continue;
            num += SearchForFiles(hwnd, buffer, TRUE);
            chdir("..");
        }

        FreeMem(cp);
    }

    return (num);
}



BOOL FAR PASCAL CriteriaProc (HWND hwnd, WORD message, WORD wParam, LONG lParam)
{
	switch (message) {
		case WM_INITDIALOG: {
			int i;
			FILEOPTIONS *f;

			/* Set the type and mode-change icon of the Jedit controls */

            SendDlgItemMessage(hwnd, 4211, EM_LIMITTEXT, 120, 0L);
			if (filespec != NULL) SetDlgItemText(hwnd, 4211, filespec);

			for (i = 0; i < NRSUMMARIES; i++) {
				SendDlgItemMessage(hwnd, 4201 + i, EM_SETRECT, GetDlgItem(hwnd, 4221), 0L);
				f = (FILEOPTIONS *) SendDlgItemMessage(hwnd, 4201 + i, EM_GETHANDLE, 0, 0L);

                if (criteria[i] != NULL) {
                    SendDlgItemMessage(hwnd, 4201 + i, EM_REPLACESEL, 0, (LONG) criteria[i]);
				}
                if (i == 0) {
                    SendDlgItemMessage(hwnd, 4221, EM_SETHANDLE, f->hwnd, 0L);  /* icon-change */
                }
			}

			SetFocus(GetDlgItem(hwnd, 4211));
            CenterDialogBox(hwnd);
			return (TRUE);
		}

        case WM_PAINT: {
            int i;
            HDC hdc;
			PAINTSTRUCT ps;

			hdc = BeginPaint(hwnd, &ps);

			for (i = 0; i < NRSUMMARIES; i++) DrawBoundingBox(hwnd, hdc, 4201 + i);

            EndPaint(hwnd, &ps);
			return (TRUE);
		}

        case WM_COMMAND:
            switch (wParam) {
				case IDOK: {
					int i, j, len;
					UNIT far *up;
					KANJI far *kp;
					char far *cbufp;
					KANJI buffer[MAXLINELEN];


					cbufp = (char far *) buffer;
					GetDlgItemText(hwnd, 4211, cbufp, 120);

					/* Trims spaces */

					for (i = _fstrlen(cbufp) - 1; i >= 0 && cbufp[i] <= ' '; i--);
					cbufp[i+1] = '\0';
                    for (i = 0; cbufp[i] && cbufp[i] <= ' '; i++);
                    if (!cbufp[i]) {
						if (filespec != NULL) FreeMem(filespec);
						filespec = NULL;
					} else {
						if (filespec != NULL) FreeMem(filespec);
						filespec = (char *) MemAlloc(_fstrlen(cbufp + i) + 5);
						_fstrcpy(filespec, cbufp + i);
					}

					/* Get the summary criteria */

					for (i = 0; i < NRSUMMARIES; i++) {
                        up = (UNIT far *) SendDlgItemMessage(hwnd, 4201 + i, EM_GETLINE, 0, 0L);
                        len = unitlen(up);

						if (len <= 0) {
                            if (criteria[i] != NULL) {
                                FreeBlock(criteria[i]);
                                criteria[i] = NULL;
                            }
                        } else {
                            kp = criteria[i];
                            if (kp == NULL) {
                                kp = (KANJI far *) BlockAlloc((len + 5) * sizeof(KANJI));
                            } else if ((SegHeapGetSize(kp) / sizeof(KANJI)) < len + 5) {
                                FreeBlock(kp);
                                kp = (KANJI far *) BlockAlloc((len + 5) * sizeof(KANJI));
                            }
							for (j = 0; up[j].kanji; j++) kp[j] = up[j].kanji;
                            kp[j] = 0;
                            criteria[i] = kp;
                        }
                    }
                    EndDialog(hwnd, TRUE);
                    return (TRUE);
                }

				case IDCANCEL:
                    EndDialog(hwnd, FALSE);
                    return (TRUE);
            }
            break;
    }

    return (FALSE);
}



BOOL FAR PASCAL FileInfoProc (HWND hwnd, WORD message, WORD wParam, LONG lParam)
{
    switch (message) {
        case WM_INITDIALOG: {
            int i, n, fd;
            struct ffblk ffblk;
            struct stat statbuf;
            OFSTRUCT of;
            FILEHEADER header;
            char buffer[MAXLINELEN];

            SetDlgItemText(hwnd, 4211, FileInfoName);
            if (findfirst(FileInfoName, &ffblk, FA_RDONLY) != 0) return (TRUE);

            /* File date and time */

            if (stat(FileInfoName, &statbuf) == 0) {
                SetDlgItemText(hwnd, 4212, ctime(&statbuf.st_ctime));
                SetDlgItemText(hwnd, 4213, ctime(&statbuf.st_mtime));
                sprintf(buffer, "%ld bytes, %4.2lf K", statbuf.st_size, ((double) statbuf.st_size / 1024.0));
                SetDlgItemText(hwnd, 4214, buffer);
            }

            /* File type */

            fd = OpenFile(FileInfoName, &of, OF_READ);
            if (fd < 0) return (TRUE);

            lseek(fd, 0L, 0);
            read (fd, &header, sizeof(FILEHEADER));

            if (header.magic == MAGIC) {
                strcpy(buffer, PROGNAME " File");
            } else {
                strcpy(buffer, "DOS file");
            }

            if (ffblk.ff_attrib & FA_DIREC) {
                if (buffer[0]) strcat(buffer, ", ");
                strcat(buffer, "Directory");
            }
            if (ffblk.ff_attrib & FA_RDONLY) {
                if (buffer[0]) strcat(buffer, ", ");
                strcat(buffer, "Read-Only");
            }
            if (ffblk.ff_attrib & FA_ARCH) {
                if (buffer[0]) strcat(buffer, ", ");
                strcat(buffer, "Archive bit set");
            }

            SetDlgItemText(hwnd, 4215, buffer);

            /* Summary? */

            if (header.magic == MAGIC && header.summary) {
                for (i = 0; i < NRSUMMARIES; i++) {
                    read(fd, &n, sizeof(int));
                    if (n <= 0) continue;
                    if (n > 0) read(fd, buffer, n * sizeof(KANJI));
                    SendDlgItemMessage(hwnd, 4201 + i, EM_REPLACESEL, 0, (LONG) buffer);
                }
            }

            close(fd);
            CenterDialogBox(hwnd);
            return (TRUE);
        }

        case WM_COMMAND:
            switch (wParam) {
                case IDOK:
                    EndDialog(hwnd, TRUE);
                    return (TRUE);
            }
            break;

        case WM_KEYDOWN:
            switch (wParam) {
                case VK_ESCAPE: SendMessage(hwnd, WM_COMMAND, IDOK, 0L);
                                return (TRUE);
            }
            break;
    }

    return (FALSE);
}



static int FillDirectories (HWND ListBoxHwnd, HWND TextHwnd)
{
    int i, n = 0;
    struct ffblk ffblk;
    char buffer[MAXPATH];

    if (getcwd(buffer, MAXPATH) == NULL) {
		if (chdir("\\") < 0) return (-1);
		strcpy(buffer, "\\");
    }

    /* Fill the directory combo box */

    SendMessage(ListBoxHwnd, WM_SETREDRAW, FALSE, 0L);
    SendMessage(ListBoxHwnd, LB_RESETCONTENT, 0, 0L);

    if (strcmp(buffer + 2, "\\")) {
        SendMessage(ListBoxHwnd, LB_ADDSTRING, 0, (LONG) ((char far *) PARENTDIR));
        n++;
        strcat(buffer, "\\*.*");
    } else {
        strcat(buffer, "*.*");
    }

    if (findfirst(buffer, &ffblk, FA_RDONLY | FA_DIREC) == 0) {
        do {
            if (!(ffblk.ff_attrib & FA_DIREC)) continue;
            if (ffblk.ff_name[0] == '.') continue;

            n++;
            SendMessage(ListBoxHwnd, LB_ADDSTRING, 0, (LONG) ((char far *) ffblk.ff_name));
        } while (findnext(&ffblk) == 0);
    }

    /* Fill the drives */

	for (i = 0; i < 26; i++) {
		if (i == getdisk()) continue;
        switch (GetDriveType(i)) {
			case DRIVE_REMOVABLE:
                sprintf(buffer, "%c %c: floppy drive ]", DRIVECHAR, 'A' + i);
                break;

            case DRIVE_REMOTE:
                sprintf(buffer, "%c %c: network drive ]", DRIVECHAR, 'A' + i);
                break;

            case DRIVE_FIXED:
                sprintf(buffer, "%c %c: hard drive ]", DRIVECHAR, 'A' + i);
                break;

            default: continue;
        }
        SendMessage(ListBoxHwnd, LB_ADDSTRING, 0, (LONG) ((char far *) buffer));
    }

    if (SendMessage(ListBoxHwnd, LB_GETCOUNT, 0, 0L) > 0) {
        SendMessage(ListBoxHwnd, LB_SETCURSEL, 0, 0L);
    }

    getcwd(buffer, MAXPATH);
    SetWindowText(TextHwnd, buffer);

    SendMessage(ListBoxHwnd, WM_SETREDRAW, TRUE, 0L);
	InvalidateRect(ListBoxHwnd, NULL, TRUE);

    return (n);
}


BOOL FAR PASCAL FileFindProc (HWND hwnd, WORD message, WORD wParam, LONG lParam)
{
    switch (message) {
        case WM_INITDIALOG:
            FillDirectories(GetDlgItem(hwnd, 4221), GetDlgItem(hwnd, 4222));

            /* Default to search only the current path */

            SendDlgItemMessage(hwnd, 4231, BM_SETCHECK, TRUE, 0L);
            EnableWindow(GetDlgItem(hwnd, 4201), FALSE);
            EnableWindow(GetDlgItem(hwnd, 4202), FALSE);

            CenterDialogBox(hwnd);
            return (TRUE);

        case WM_COMMAND:
            switch (wParam) {
                case 4211:      /* Files list */
                    switch (HIWORD(lParam)) {
                        case LBN_DBLCLK:
                            SendMessage(hwnd, WM_COMMAND, 4201, 0L);    /* Open */
                            return (TRUE);
                    }
                    return (TRUE);

                case 4221: {    /* Directories */
                    int i;
                    char buffer[MAXPATH];

                    switch (HIWORD(lParam)) {
						case LBN_DBLCLK:
							i = SendDlgItemMessage(hwnd, 4221, LB_GETCURSEL, 0, 0L);
							if (i == LB_ERR) {
								MessageBeep(0);
								return (TRUE);
							}
							SendDlgItemMessage(hwnd, 4221, LB_GETTEXT, i, (LONG) ((char far *) buffer));
							if (!strcmp(buffer, PARENTDIR)) {
								chdir("..");
							} else if (buffer[0] == DRIVECHAR) {
                                setdisk(buffer[2] - 'A');
							} else {
								chdir(buffer);
							}
							FillDirectories(GetDlgItem(hwnd, 4221), GetDlgItem(hwnd, 4222));
							return (TRUE);
					}
					return (TRUE);
				}

                case 4231:      /* Current path */
                    if (IsDlgButtonChecked(hwnd, 4231)) {
                        EnableWindow(GetDlgItem(hwnd, 4221), TRUE);
                        EnableWindow(GetDlgItem(hwnd, 4222), TRUE);
                    }
                    return (TRUE);

                case 4232:      /* All subdirectories */
                    if (IsDlgButtonChecked(hwnd, 4232)) {
                        EnableWindow(GetDlgItem(hwnd, 4221), TRUE);
                        EnableWindow(GetDlgItem(hwnd, 4222), TRUE);
                    }
                    return (TRUE);

                case 4233:      /* Entire disk */
                    if (IsDlgButtonChecked(hwnd, 4233)) {
                        EnableWindow(GetDlgItem(hwnd, 4221), FALSE);
                        EnableWindow(GetDlgItem(hwnd, 4222), FALSE);
                    }
                    return (TRUE);

                case 4234:      /* All drives */
                    if (IsDlgButtonChecked(hwnd, 4234)) {
                        EnableWindow(GetDlgItem(hwnd, 4221), FALSE);
                        EnableWindow(GetDlgItem(hwnd, 4222), FALSE);
                    }
                    return (TRUE);

                case 4201: {    /* Open */
                    int i;
					char buffer[MAXPATH];

                    i = SendDlgItemMessage(hwnd, 4211, LB_GETCURSEL, 0, 0L);
                    if (i == LB_ERR) return (TRUE);
                    SendDlgItemMessage(hwnd, 4211, LB_GETTEXT, i, (LONG) ((char far *) buffer));
                    if (!DoFileOpen(buffer)) return (TRUE);

                    EndDialog(hwnd, TRUE);
                    return (TRUE);
                }

                case 4202: {    /* Info */
                    int i;
					char buffer[MAXPATH];

                    i = SendDlgItemMessage(hwnd, 4211, LB_GETCURSEL, 0, 0L);
                    if (i == LB_ERR) return (TRUE);
                    SendDlgItemMessage(hwnd, 4211, LB_GETTEXT, i, (LONG) ((char far *) buffer));
                    FileInfoName = buffer;

                    DialogBox(hInstance, "FileInfo", hwnd, FileInfoProc);
                    return (TRUE);
				}

				case IDOK: {    /* Search */
                    BOOL Doit;
                    HCURSOR hcursor;

                    Doit = DialogBox(hInstance, "SearchCriteria", hwnd, CriteriaProc);

					if (Doit) {
                        int i, n, OldDrive = -1;
						BOOL Recurrsive = FALSE;
                        char OldPath[MAXPATH] = "";
						KANJI buffer[MAXLINELEN];

                        if (IsDlgButtonChecked(hwnd, 4232)) {   /* Sub-directories */
                            Recurrsive = TRUE;
                        }
						if (IsDlgButtonChecked(hwnd, 4233)) {   /* Entire disk */
                            getcwd(OldPath, MAXPATH);
							chdir("\\");
							Recurrsive = TRUE;
						}
                        if (IsDlgButtonChecked(hwnd, 4234)) {   /* All disks */
                            OldDrive = getdisk();
							Recurrsive = TRUE;
						}

                        hcursor = SetCursor(LoadCursor(NULL, IDC_WAIT));
                        ShowCursor(TRUE);
                        SendDlgItemMessage(hwnd, 4211, LB_RESETCONTENT, 0, 0L);

                        if (IsDlgButtonChecked(hwnd, 4234)) {
                            for (n = i = 0; i < 26; i++) {
                                switch (GetDriveType(i)) {
                                    default:
                                    case DRIVE_REMOVABLE: break;

                                    case DRIVE_REMOTE:
                                    case DRIVE_FIXED:
                                        setdisk(i);
                                        if (getdisk() != i) break;

                                        getcwd(OldPath, MAXPATH);
                                        chdir("\\");
                                        n += SearchForFiles (GetDlgItem(hwnd, 4211), buffer, TRUE);
                                        chdir(OldPath);
                                        break;
                                }
                            }
                            OldPath[0] = '\0';
                        } else {
                            n = SearchForFiles (GetDlgItem(hwnd, 4211), buffer, Recurrsive);
                        }

                        if (n <= 0) {
                            ShowCursor(FALSE);
                            SetCursor(hcursor);
                            StatusMessage("");
                            ErrorMessage (hwnd, "No files found!");
                            EnableWindow(GetDlgItem(hwnd, 4201), FALSE);
                            EnableWindow(GetDlgItem(hwnd, 4202), FALSE);
						} else {
                            ShowCursor(FALSE);
                            SetCursor(hcursor);
                            sprintf((char *) buffer, "%d file%s found.", n, (n > 1) ? "s" : "");
                            StatusMessage((char *) buffer);
							SendDlgItemMessage(hwnd, 4211, LB_SETCURSEL, 0, 0L);
                            EnableWindow(GetDlgItem(hwnd, 4201), TRUE);
                            EnableWindow(GetDlgItem(hwnd, 4202), TRUE);
							SetFocus(GetDlgItem(hwnd, 4211));
						}

                        if (OldDrive >= 0) setdisk(OldDrive);

                        if (OldPath[0] != '\0') {
                            chdir(OldPath);
							FillDirectories(GetDlgItem(hwnd, 4221), GetDlgItem(hwnd, 4222));
                        }
					}

					return (TRUE);
                }

				case IDCANCEL:  /* Cancel */
					EndDialog(hwnd, FALSE);
                    return (TRUE);
            }
            break;
    }

    return (FALSE);
}



void UpdateQuickFiles (void)
{
    int i, j, n;
    char buffer[MAXLINELEN];

    for (i = j = 0; i < NRQUICKFILE; i++) {
        if (QuickFiles[i] != NULL) j++;
        DeleteMenu(hmenu, IDM_FILE1 + i, MF_BYCOMMAND);
    }

    /* Find the last file menu item */

    for (n = GetMenuItemCount(hmenu) - 1; n >= 0; n--) {
        if (GetMenuItemID(GetSubMenu(hmenu, n), 0) == IDM_FILENEW) break;
    }

    if (n < 0) return;

    for (i = GetMenuItemCount(GetSubMenu(hmenu, n)) - 1; i >= 0; i--) {
        if (GetMenuItemID(GetSubMenu(hmenu, n), i) == IDM_FILEEXIT) break;
    }

    if (i >= 0) DeleteMenu(GetSubMenu(hmenu, n), i+1, MF_BYPOSITION);

    if (j > 0) {
        InsertMenu(GetSubMenu(hmenu, n), i+1, MF_BYPOSITION | MF_SEPARATOR, 0, "");

        for (i = 0; i < NRQUICKFILE && QuickFiles[i] != NULL; i++) {
            sprintf(buffer, "&%d %s", i + 1, QuickFiles[i]);
            InsertMenu(GetSubMenu(hmenu, n), -1, MF_BYPOSITION | MF_UNCHECKED | MF_ENABLED | MF_STRING, IDM_FILE1 + i, buffer);
        }
    }
}



void PutQuickFile (char *pathname)
{
    int i, j;

    for (i = 0; i < NRQUICKFILE; i++) {
        if (!stricmp(QuickFiles[i], pathname)) {
            FreeMem(QuickFiles[i]);
            for (j = i+1; j < NRQUICKFILE; j++) QuickFiles[j-1] = QuickFiles[j];
            QuickFiles[NRQUICKFILE-1] = NULL;
        }
    }

    if (QuickFiles[NRQUICKFILE-1] != NULL) FreeMem(QuickFiles[NRQUICKFILE-1]);

    for (i = NRQUICKFILE - 1; i > 0; i--) QuickFiles[i] = QuickFiles[i-1];

    QuickFiles[0] = MemAlloc(strlen(pathname) + 5);
    strcpy(QuickFiles[0], pathname);

	UpdateQuickFiles();
	OptionsChanged = TRUE;
}


char *GetQuickFile (int n)
{
    return (QuickFiles[n]);
}



BOOL FAR PASCAL RunProc (HWND hwnd, WORD message, WORD wParam, LONG lParam)
{
    switch (message) {
        case WM_INITDIALOG: {
            int i;

            for (i = 0; i < NRPROGS; i++) {
                SendDlgItemMessage(hwnd, 4201 + i, BM_SETCHECK, (i == 0), 0L);
            }

            CenterDialogBox(hwnd);
			return (TRUE);
		}

        case WM_COMMAND:
            switch (wParam) {
                case IDOK: {
                    int len;
                    char *cp;
                    char pathname[MAXLINELEN];

                    GetWindowsDirectory(pathname, MAXLINELEN);
                    len = strlen(pathname);
                    if (pathname[len-1] == '\\') pathname[len-1] = '\0';

                    if (IsDlgButtonChecked(hwnd, 4201)) {
                        strcat(pathname, "\\CONTROL.EXE");
                        cp = "Control Panel";
                    } else if (IsDlgButtonChecked(hwnd, 4202)) {
                        strcat(pathname, "\\WINFILE.EXE");
                        cp = "File Manager";
                    } else if (IsDlgButtonChecked(hwnd, 4203)) {
                        sprintf(pathname, "%sBTNMAD.EXE", global.jwppath);
                        cp = "Button Madness";
                    } else if (IsDlgButtonChecked(hwnd, 4204)) {
                        sprintf(pathname, "%sPUZZLE.EXE", global.jwppath);
                        cp = "Puzzle";
                    } else {
                        pathname[0] = '\0';
                        cp = NULL;
                    }

                    if (cp != NULL) {
                        if (WinExec(pathname, SW_SHOW) < 32)
                            ErrorMessage(hwnd, "Cannot run %s!", cp);
                    }
                    EndDialog(hwnd, TRUE);
                    return (TRUE);
                }

                case IDCANCEL:
                    EndDialog(hwnd, FALSE);
                    return (TRUE);

                case 4201:
                case 4202:
                case 4203:
                case 4204: {
                    int i;

                    for (i = 0; i < NRPROGS; i++)
                        SendDlgItemMessage(hwnd, 4201 + i, BM_SETCHECK, (4201 + i == wParam), 0L);

					if (HIWORD(lParam) == BN_DOUBLECLICKED) SendMessage(hwnd, WM_COMMAND, IDOK, 0L);
					return (TRUE);
                }
            }
            break;
    }

    return (FALSE);
}



static KANJI far *ConvertOffset (int id, LONG lParam, KANJI *buf)
{
	if (Templates == NULL) {
		buf[0] = 0;
		return (buf);
	}
	return (Templates[lParam].desc);
}



BOOL FAR PASCAL TemplateProc (HWND hwnd, WORD message, WORD wParam, LONG lParam)
{
    switch (message) {
        case WM_INITDIALOG: {
            int i, j, fd;
            OFSTRUCT of;
            FILEHEADER header;
            struct ffblk ffblk;
            KANJI tplname[MAXLINELEN];
            char buffer[MAXLINELEN];


            sprintf(buffer, "%s*%s", global.jwppath, FileExtensions[FF_TEMPLATE]);
            StatusMessage("Loading templates...");

            j = 0;

            if (findfirst(buffer, &ffblk, FA_RDONLY) == 0) {
                do {
                    fd = OpenFile(ffblk.ff_name, &of, OF_READ);
                    if (fd < 0) continue;

                    lseek(fd, 0L, 0);
                    read (fd, &header, sizeof(FILEHEADER));
                    if (header.magic != MAGIC) {
                        close(fd);
                        continue;
                    }

                    if (!header.summary) {
                        for (i = 0; ffblk.ff_name[i]; i++) tplname[i] = ffblk.ff_name[i];
                        tplname[i] = 0;
                    } else {
                        read(fd, &i, sizeof(int));
						if (i > 0) read(fd, (char *) tplname, i * sizeof(KANJI));
                        else {
                            for (i = 0; ffblk.ff_name[i]; i++) tplname[i] = ffblk.ff_name[i];
                            tplname[i] = 0;
                        }
                    }

                    close(fd);

                    if (Templates == NULL) {
                        Templates = (TPLFILE far *) BlockAlloc(TPLBLOCKSIZE * sizeof(TPLFILE));
                    } else if (j % TPLBLOCKSIZE == 0) {
                        Templates = (TPLFILE far *) BlockRealloc(Templates, (j + TPLBLOCKSIZE) * sizeof(TPLFILE));
                    }
                    Templates[j].filename = (char far *) BlockAlloc(strlen(of.szPathName) + 5);
                    _fstrcpy(Templates[j].filename, of.szPathName);
                    Templates[j].desc = (KANJI far *) BlockAlloc((kanjilen(tplname) + 5) * sizeof(KANJI));
                    kanjicpy(Templates[j].desc, tplname);

                    SendDlgItemMessage(hwnd, 4201, LB_ADDSTRING, 0, (LONG) j);
                    j++;
                } while (findnext(&ffblk) == 0);
            }

			StatusMessage("");

            if (j <= 0) {
                EndDialog(hwnd, -1);
                return (TRUE);
            }

            SendDlgItemMessage(hwnd, 4201, LB_SETCURSEL, 0, 0L);

            nr_templates = j;

            return (TRUE);
        }

        case WM_COMMAND: {
            int i, j = -5;

            switch (wParam) {
                case 4201:          /* Japanese list box */
                    if (HIWORD(lParam) == LBN_DBLCLK) {
                        SendMessage(hwnd, WM_COMMAND, IDOK, 0L);
                    }
                    return (TRUE);

                case IDOK:
                    j = SendDlgItemMessage(hwnd, 4201, LB_GETCURSEL, 0, 0L);
                    if (j == LB_ERR) {
                        j = -1;
                        if (TplChosen != NULL) TplChosen[0] = '\0';
                    } else {
                        j = SendDlgItemMessage(hwnd, 4201, LB_GETITEMDATA, j, 0L);
                        if (TplChosen == NULL) TplChosen = BlockAlloc(MAXPATH);
                        _fstrcpy(TplChosen, Templates[j].filename);
                    }
                    break;

                case IDCANCEL:
                    j = -2;
                    if (TplChosen != NULL) TplChosen[0] = '\0';
                    break;

                case 4211:
                    j = -1;
                    if (TplChosen != NULL) TplChosen[0] = '\0';
                    break;
            }

            if (j <= -5) return (FALSE);

            for (i = 0; i < nr_templates; i++) {
                FreeBlock(Templates[i].filename);
                FreeBlock(Templates[i].desc);
            }
            FreeBlock(Templates);
            Templates = NULL;
            EndDialog(hwnd, j);
            return (TRUE);
        }

        case WM_COMPAREITEM:
        case WM_DELETEITEM:
        case WM_DRAWITEM:
        case WM_MEASUREITEM:
            return (JlistProc(hwnd, message, wParam, lParam, TRUE, ConvertOffset));
    }

    return (FALSE);
}
