#include <stdio.h>
#include <dir.h>
#include <time.h>
#include <sys/stat.h>

#define JWPINI      "JWP.INI"

main()
{
    int i;
    char directory[1024];
    char line[1024];
    char windir[1024];
    char buffer[1024];
    time_t t;
    FILE *fp;
    struct stat sb;


    getcwd(directory, 1024);

    fprintf(stderr, "JWP directory = %s\n", directory);

    i = strlen(directory);
    if (directory[i-1] == '\\') directory[i-1] = '\0';

    /* Get Windows directory */

    fprintf(stderr, "\nWhat is the Windows directory? ");
    fgets(line, 1024, stdin);
    line[strlen(line) - 1] = '\0';

    windir[0] = '\0';
    sscanf(line, "%s", windir);
    i = strlen(windir);
    if (windir[i-1] == '\\') windir[i-1] = '\0';

    sprintf(buffer, "%s\\WIN.COM", windir);

    if (stat(buffer, &sb) != 0) {
        fprintf(stderr, "ERROR: %s is NOT the Windows directory!\n", line);
        fprintf(stderr, "       Please check carefully and run this program again.\n");
        exit(1);
    }


    /* Create the file */

    sprintf(buffer, "%s\\" JWPINI, windir);

	fp = fopen(buffer, "wt");
    if (fp == NULL) {
        fprintf(stderr, "ERROR: Cannot create initialization file %s!\n", buffer);
        exit(1);
    }

    fprintf(fp, "; JWP.INI - Initialization file for JWP\n");
    fprintf(fp, "; Version 1.1\n");
	time(&t);
    fprintf(fp, "; Last Modified %s", ctime(&t));

    fprintf(fp, "\n[File Names]\n");
    fprintf(fp, "JWP Directory=%s\\\n", directory);
    fprintf(fp, "Help File=%s\\JWP.HLP\n", directory);
	fprintf(fp, "Conversion Dictionary=%s\\WNN.DCT\n", directory);
	fprintf(fp, "Conversion Dictionary Index=%s\\WNN.IDX\n", directory);
	fprintf(fp, "User Conversion Dictionary=%s\\USERDICT.DCT\n", directory);
	fprintf(fp, "Conversion Cache=%s\\CNVCACHE.SAV\n", directory);
	fprintf(fp, "Japanese Dictionary=%s\\EDICT\n", directory);
	fprintf(fp, "Japanese Dictionary Index=%s\\EDICT.JDX\n", directory);
	fprintf(fp, "Kanji Info=%s\\KINFO.DAT\n", directory);
	fprintf(fp, "Kanji Info Index=%s\\KINFO.IDX\n", directory);
	fprintf(fp, "Global Glossary=%s\\GLOSSARY.DAT\n", directory);

    fprintf(fp, "\n[Page Setup]\n");
	fprintf(fp, "Measurement Unit=inches\n");
	fprintf(fp, "Margins=1.00 1.00 1.00 1.00\n");
	fprintf(fp, "Orientation=Landscape\n");
	fprintf(fp, "Long Text Justification=Justify\n");
	fprintf(fp, "Short Text Justification=Justify\n");

    fprintf(fp, "\n[Base ASCII Font]\n");
	fprintf(fp, "Face Name=Times New Roman\n");
	fprintf(fp, "Size=12.0\n");

    fprintf(fp, "\n[Kanji Fonts]\n");
    fprintf(fp, "Number of Kanji Fonts=3\n");
	fprintf(fp, "System Font=1\n");
	fprintf(fp, "Default Base Font=1\n");
    fprintf(fp, "Default Print Font=3\n");
    fprintf(fp, "Default Print Scale=1.000\n");
    fprintf(fp, "Font #1=%s\\K16X16.F00\n", directory);
    fprintf(fp, "Font #2=%s\\K24X24.F00\n", directory);
    fprintf(fp, "Font #3=%s\\K48X48.F00\n", directory);

    fprintf(fp, "\n[Glossary]\n");
	fprintf(fp, "Dynamic Glossary=Yes\n");
	fprintf(fp, "Glossary List Disappears=No\n");
	fprintf(fp, "Glossary List Visible=No\n");
	fprintf(fp, "Glossary List Position=490 80\n");
	fprintf(fp, "Glossary List Size=120 130\n");

    fprintf(fp, "\n[Undo]\n");
    fprintf(fp, "Number of Undo Levels=50\n");
    fprintf(fp, "Undo Levels Saved=All\n");

    fprintf(fp, "\n[Others]\n");
	fprintf(fp, "Program Position=Maximized\n");
	fprintf(fp, "Relax Margin for Punctuation=Yes\n");
	fprintf(fp, "Dynamic Conversion=No\n");
	fprintf(fp, "Conversion Bar Position=Bottom\n");
	fprintf(fp, "Conversion Bar Size=300 69\n");
	fprintf(fp, "Clipboard Format=EUC\n");
	fprintf(fp, "Draft View=No\n");
	fprintf(fp, "Show Special Symbols=No\n");
	fprintf(fp, "Show Iconbar=Yes\n");
	fprintf(fp, "Show Status Bar=Yes\n");
	fprintf(fp, "Show File Ruler=Yes\n");
    fprintf(fp, "3D Dialog Boxes=Yes\n");
    fprintf(fp, "NN Conversion=Yes\n");

    fprintf(fp, "\n[Quick Files]\n");
	fprintf(fp, "Number of Quick Files=0\n");

    fprintf(fp, "\n[Hot Keys]\n");
	fprintf(fp, "Create New File=^N\n");
	fprintf(fp, "Open File=^O\n");
	fprintf(fp, "Close File=^X\n");
	fprintf(fp, "Save File=F11\n");
	fprintf(fp, "Save as Something Else=F12\n");
	fprintf(fp, "Find File=^F\n");
	fprintf(fp, "Print File=+^F12\n");
	fprintf(fp, "Page Setup=None\n");
	fprintf(fp, "Printer Setup=None\n");
	fprintf(fp, "Edit File Summary=None\n");
	fprintf(fp, "Edit Header/Footer=None\n");
	fprintf(fp, "Toggle Kana/Text mode=F4\n");
	fprintf(fp, "Toggle Glossary List=^G\n");
	fprintf(fp, "Toggle Draft View=^F2\n");
	fprintf(fp, "Toggle Iconbar=None\n");
	fprintf(fp, "Toggle Status Bar=None\n");
	fprintf(fp, "Toggle File Ruler=None\n");
	fprintf(fp, "Toggle Special Symbols=None\n");
	fprintf(fp, "Toggle Dynamic Glossary=None\n");
	fprintf(fp, "Search for Text=^S\n");
	fprintf(fp, "Continue Search/Replace=F7\n");
	fprintf(fp, "Replace Text=^R\n");
	fprintf(fp, "Convert Kana to Kanji (L->R)=F2\n");
	fprintf(fp, "Convert Kana to Kanji (R->L)=+F2\n");
	fprintf(fp, "Kanji Lookup=^L\n");
	fprintf(fp, "Kanji Info=^K\n");
	fprintf(fp, "JIS Input=^J\n");
	fprintf(fp, "JIS Table=^T\n");
	fprintf(fp, "Set Options=None\n");
	fprintf(fp, "Change Hot Keys=None\n");
	fprintf(fp, "Maintain Kanji Fonts=None\n");
	fprintf(fp, "Show Statistics=None\n");
	fprintf(fp, "Dictionary=F6\n");
	fprintf(fp, "Edit Glossary=None\n");
	fprintf(fp, "Edit User Conversions=None\n");
	fprintf(fp, "Cascade File Windows=+F4\n");
	fprintf(fp, "Tile File Windows=+F5\n");
	fprintf(fp, "Close all File Windows=None\n");
    fprintf(fp, "Help=F1\n");

	fclose(fp);

    fprintf(stderr, "Initialization file created successfully.\n");
    return (0);
}
