REM Pimake converts pi text to data file. v1.0a PD 2001.
' define a byte
DIM Byte AS STRING * 1
' open input file
OPEN "pi_data.txt" FOR INPUT AS #1
' store output filename
Filename$="pi_data.dat"
' check file exists
IF DIR$(Filename$)<>"" THEN
   ' remove file
   KILL Filename$
END IF
' open file for output
OPEN Filename$ FOR BINARY AS #2
' display header
COLOR 15,0
PRINT "Pimake v1.0a"
COLOR 14,0
PRINT "Converting pi_data.txt to pi_data.dat:"
Position& = 0
' strip text file header
LINE INPUT #1, Strng$
LINE INPUT #1, Strng$
' read in entire file
DO WHILE NOT EOF(1)
   ' get next line
   LINE INPUT #1, Strng$
   ' search line
   FOR Count = 1 TO LEN(Strng$)
      ' display a dot
      GOSUB DisplayDot
      ' store byte
      Byte = MID$(Strng$, Count, 1)
      ' check digit
      IF Byte >= "0" AND Byte <= "9" THEN
         Position& = Position& + 1
         ' write to data file
         PUT 2, Position&, Byte
      END IF
   NEXT
LOOP
' clear dots
GOSUB ClearDots
' display trailer
PRINT "Conversion complete."
PRINT "Converted";Position&;"digits."
COLOR 7,0
PRINT "Returning to system."
END

' display a dot
DisplayDot:
 Dot.Count=Dot.Count+1
 IF Dot.Count=1024 THEN
    Dot.Count=0
    Dot.Kilo=Dot.Kilo+1
    IF Dot.Kilo>16 THEN
       Dot.Kilo=1
       Dot.Flag=NOT Dot.FLag
    END IF
    IF Dot.Flag THEN
       PRINT CHR$(29);" ";CHR$(29);
       Dots=Dots-1
    ELSE
       PRINT ".";
       Dots=Dots+1
    END IF
    LOCATE ,,1
 END IF
 RETURN

' clear a line of dots
ClearDots:
 FOR Dot.Count=1 TO Dots
    PRINT CHR$(29);" ";CHR$(29);
 NEXT
 RETURN
