REM Copyright (c) 2002 Startech Industries Inc. Sharware program only.
REM Program: Soltice2.bas displays earth/sun/moon/star chart.

' start program
DEFSNG A-Z
REM $DYNAMIC
SCREEN 8

' check timing over-ride
IF COMMAND$ = "/T" THEN
   timing = -1
END IF

' declare some variables
c = 2.3 ' screen scale correction factor.
cflag = -1 ' clock mode flag: true=simulation, false=real-time clock.

' seconds to update while in real-time:
dsec = 30 ' is 1/8 of 1 degree arc of zodiac.

pi = ATN(1) * 4 ' calcuate PI.

' begin: restart at midnight local time, or in reset mode.
5
CLS
COLOR 15, 0
PRINT "Zorastro Chart Northern Hemisphere:"
COLOR 14, 0
PRINT "[S]imulation/[C]alculation. <esc>=quit."
COLOR 5, 0
tlast = 0 ' reset check for change of day in clock mode
timlast = 0 ' simulation mode reset check

' check initialization error, minutes:
tmn! = TIMER / 240
dtm! = (tmn! / 8 - INT(tmn! / 8)) * .5   ' initialization error
lna = INT(tmn!)    ' local number ascension (local time, degrees zodiac)
tm! = TIMER + dsec    ' set next iteration period, 1/8 degree per shift

' read and convert date string:
yr$ = RIGHT$(DATE$, 4)
fyr$ = LEFT$(DATE$, 5)
mos$ = LEFT$(fyr$, 2)
mos = VAL(mos$)
day$ = RIGHT$(fyr$, 2)
day = VAL(day$)

' calculate days elapsed this year:
GOSUB yearco

' add galaxy time to local time, 10 days scale shift to dec 21; convert to
' fraction of year, convert to zodiac degrees, minus ninety days for
' scale shift to pisces point at 0.00 degrees

tgtm = ((day + days + 10.444) / yr) * 360
gtm = INT(tgtm) - 90
IF gtm <= 0 THEN gtm = gtm + 360
LOCATE 25, 62
PRINT gtm;   ' local galaxy time, due south, ecliptic; celestial
LOCATE 25, 67
PRINT "solar";   ' actually gtm is solar time; use for galaxy position fix

' temporary local number ascension, truncated to one degree intervals, and
' shifted for reference at noon = 00000 for add to galaxy time:

tlna = gtm + lna - 180

' add 40 to center screen: (note: gtm resets at midnight clock time)

na = tlna + 40    ' na = number ascension; left justified on screen

IF na <= 0 THEN na = na + 360   ' cycle limit check; initialize year cycle
IF na > 360 THEN na = na - 360

ishift = na - 10 * INT(na / 10)    ' line up numbers to increments; offset.*

' output debug data:

' days:   sum of days of month/s, truncated at month now                                     ' (new idea: Tmoon)
' day:    days so far this month
' mos:    months so far this year
' na:     ascension number, na, adjusted for screen left
' tlna:   temporary local number ascension: local zodiac time
'         (truncated at one degree intervals)
' gtm:    local solar time, on ecliptic, due south; noon local time

10    '  draw zodiac line and scale increments, moving/shifting
GOSUB moonclock
DO
   ' display degree lines
   FOR shift = 0 TO 79 STEP 1
      starshift = shift - 8 * INT(shift / 8)
      FOR ra = 81 TO -19 STEP -1
         pix = 8 * ra + shift + ishift * 8 + 4
         LINE (1, 100)-(640, 100)
         IF ra / 10 - INT(ra / 10) <> 0 THEN
            LINE (pix - 1, 97)-(pix - 1, 105), 0
            LINE (pix, 97)-(pix, 103)
         ELSE
            LINE (pix - 1, 94)-(pix - 1, 105), 0
            LINE (pix, 94)-(pix, 105)
         END IF
      NEXT
      LINE (324, 63)-(324, 79), 7
      LINE (324, 90)-(324, 109), 7
      LINE (324, 121)-(324, 137), 7
                     
      ' note: local time re-calculated here; simplify ??
      nrta = na - 40
      IF nrta <= 0 THEN nrta = nrta + 360
      LOCATE 24, 62
      PRINT "   ";
      LOCATE 24, 62
      PRINT nrta;
      LOCATE 24, 67
      PRINT "local";

      IF na < 80 THEN GOTO 11
      IF na - 80 < gtm <= na THEN GOSUB sundata
      GOTO 13
11    IF gtm <= na OR gtm > na + 360 - 80 THEN
         GOSUB sundata
         GOTO 13
      END IF
      sntna = na + 360
      IF sntna - 80 < gtm <= sntna THEN GOSUB sundata
13    IF na < 80 THEN GOTO 14
      IF na - 80 < monna <= na THEN GOSUB moondata
      GOTO 17
14    IF monna <= na OR monna > na + 360 - 80 THEN
         GOSUB moondata
         GOTO 17
      END IF
      montna = na + 360
      IF montna - 80 < monna <= montna THEN GOSUB moondata
17    LOCATE 18, 1
      COLOR 10, 0
      PRINT "(moon):"; monna;
      COLOR 5, 0
      ' display degree numbers
      IF shift / 8 - INT(shift / 8) <> 0 THEN GOTO 20
      FOR ra = 80 TO 0 STEP -10
         scr = ra - 10 + INT(shift / 8) + ishift
         IF na - ra <= 0 THEN
            tna = na + 360
         ELSE
            tna = na
         END IF
         IF scr > 1 AND scr < 76 THEN
            LOCATE 15, scr - 1
            PRINT "   ";
            LOCATE 15, scr
            intgr = 10 * INT((tna + (10 - ishift)) / 10) - ra
            IF intgr <= 0 THEN intgr = intgr + 360
            IF intgr > 360 THEN intgr = intgr - 360
            PRINT intgr;
            PRINT "    ";
         ELSE
            LOCATE 15, 1
            PRINT "    ";
            LOCATE 15, 76
            PRINT "   ";
         END IF
      NEXT
      GOSUB zodiac
      GOSUB starchart
      GOSUB sunclock
      GOTO 30
20
      GOSUB zodiac
      GOSUB starchart
      GOSUB sunclock
      IF shift / 8 - INT(shift / 8) = .875 THEN
         na = na + 1
         IF na = 361 THEN na = 1
      END IF
30
      tperiod = (INT((TIMER - timlast) * 100)) / 100
      IF TIMER - timlast < 0 THEN GOTO 5
      timlast = TIMER
      IF cflag = -1 THEN
         GOSUB daytime
         GOTO 40
      END IF
      LOCATE 25, 2
      PRINT "update";
     
      ' wait in real-time
      DO UNTIL TIMER > tm!
         tmr! = TIMER - tm! + dsec
         ttlast = tlast
         tlast = TIMER
         IF TIMER - ttlast < 0 THEN GOTO 5
         GOSUB daytime
         LOCATE 25, 9
         PRINT "    ";
         PRINT INT(dsec - tmr!);
         GOSUB modekeys
      LOOP
      tm! = tm! + dsec
      GOTO 45
40
      ' check timing flag
      IF timing THEN
         tim1 = TIMER
         DO
            tim2 = TIMER - tim1
            IF tim2 < 0 THEN
               tim2 = tim2 + 86400
            END IF
            IF tim2 >= .01 THEN
               EXIT DO
            END IF
         LOOP
      END IF
      GOSUB modekeys
45
   NEXT
LOOP
END

' plotting subroutines follow:

' local celestial time in hrs:min:sec
daytime:
IF cflag = -1 THEN ' if flag set, use simulation mode
   IF sflag = 1 THEN  ' if flag not set, use clock mode
      sflag = 0
      n0 = na
      min0 = min
      hr0 = hrs
   END IF
   nc = na - n0
   IF nc <= 0 THEN nc = nc + 360
   tmin = INT(nc * 8 * .5)
   thrs = tmin / 60
   min = tmin - 60 * INT(tmin / 60) + min0
   IF min >= 60 THEN min = min - 60
   hrs = INT(thrs - 24 * INT(thrs / 24) + hr0 + min0 / 60)
   IF hrs >= 24 THEN hrs = hrs - 24
   GOTO 123
END IF
tmc! = TIMER
mn! = tmc! / 60
hr! = mn! / 60
hrs = INT(hr!)
min = INT(mn! - 60 * INT(hr!))
sec = INT(tmc! - 60 * INT(mn!))
                  
123
COLOR 5, 0
LOCATE 2, 67
PRINT hrs;
LOCATE 2, 71
PRINT "hrs";
LOCATE 3, 67
PRINT min;
LOCATE 3, 71
PRINT "min";
IF cflag = -1 THEN
   LOCATE 4, 67
   PRINT "simulation"
   RETURN
END IF
LOCATE 4, 67
PRINT sec;
LOCATE 4, 71
PRINT "sec";
RETURN

' plot sun
sundata:
IF gtm >= 280 AND na < 80 THEN
   sna = na + 360   ' - gtm
ELSE
   sna = na
END IF
sdta = 8 * (sna - gtm) + starshift + 4
CIRCLE (sdta - 1, 100), 13, 0
CIRCLE (sdta, 100), 13, 15
RETURN

' plot moon
moondata:
IF monna >= 280 AND na < 80 THEN
   mna = na + 360   ' - monna
ELSE
   mna = na
END IF
mdta = 8 * (mna - monna) + starshift + 4
mony = 100 + 5.4 * c * SIN((monna + 269.2) * pi / 180)
CIRCLE (mdta - 1, mony), 11, 0
CIRCLE (mdta, mony), 11, 7
RETURN

' english language output:  day, month, year
sunclock:
GOSUB daytime
COLOR 9, 0
data$ = DATE$
month$ = LEFT$(data$, 2)
tday$ = LEFT$(data$, 5)
nday$ = RIGHT$(tday$, 2)
year$ = RIGHT$(data$, 4)
LOCATE 25, 34
PRINT nday$;
LOCATE 25, 37
month = VAL(month$)
SELECT CASE month
CASE 1
   PRINT "JAN";
CASE 2
   PRINT "FEB";
CASE 3
   PRINT "MAR";
CASE 4
   PRINT "APR";
CASE 5
   PRINT "MAY";
CASE 6
   PRINT "JUN";
CASE 7
   PRINT "JUL";
CASE 8
   PRINT "AUG";
CASE 9
   PRINT "SEP";
CASE 10
   PRINT "OCT";
CASE 11
   PRINT "NOV";
CASE 12
   PRINT "DEC";
END SELECT
LOCATE 25, 41
PRINT year$;
COLOR 5, 0
RETURN

' do some moon timing calculations
moonclock:
mn$ = DATE$
mnx$ = LEFT$(mn$, 5)
mnth = VAL(LEFT$(msx$, 2))
mndy = VAL(RIGHT$(msx$, 2))
mnyr = VAL(RIGHT$(mn$, 4))
GOSUB yearco
myrs = mnyr - 2001
mdys = days
sgmphi = gtm - 269.2
IF sgmphi < 0 THEN sgmphi = sgmphi + 360
mon = sgmphi / 29.538
monna = (mon - INT(mon)) * 360
RETURN

' plot earth soltice
zodiac:
FOR zna = 86 TO -14 STEP -1
   eqx = 8 * (zna) + ishift + 4
   eqn = na - zna
   eql = eqn - 1
   IF eqn < 1 THEN eqn = eqn + 360
   IF eql < 1 THEN eql = eql + 360
   eqtrn = 100 - (23.5 * c * SIN(pi * eqn / 180 + pi))
   eqtrm = 100 - (23.5 * c * SIN(pi * eql / 180 + pi))
   PSET (eqx - 8, eqtrm), 0
   PSET (eqx, eqtrn), 9
NEXT
RETURN

' plot stars
starchart:
fldna = 10 * INT(na / 10)
FOR sc = 80 TO 0 STEP -10
   scrn10 = fldna - sc
   IF scrn10 < 0 THEN
      scrn10 = scrn10 + 360
      stna = na + 360
   ELSEIF scrn10 = 0 THEN
      scrn10 = scrn10 + 360
      stna = na
   ELSE
      stna = na
   END IF
   zn = 100

   SELECT CASE scrn10

   CASE 10

   CASE 20
   ' aries-1:
   tdta = 8 * (stna - 29) + starshift + 4
   d = 9
   h = zn - (d * c)
   CIRCLE (tdta - 1, h), 1, 0
   CIRCLE (tdta, h), 1, 7
   
   ' aries point, old old equinox, vicinity  00 a.d.c.
   tdta = 8 * (stna - 29) + starshift + 4 - 5
   LINE (tdta - 1, 92)-(tdta - 1, 111), 0
   LINE (tdta, 92)-(tdta, 111), 4
  
   CASE 30
   ' aries-2:
   tdta = 8 * (stna - 33) + starshift + 4
   d = 11
   h = zn - (d * c)
   CIRCLE (tdta - 1, h), 1, 0
   CIRCLE (tdta, h), 1, 15

   CASE 40
   ' aries-3:
   tdta = 8 * (stna - 44) + starshift + 4
   d = 10
   h = zn - (d * c)
   CIRCLE (tdta - 1, h), 1, 0
   CIRCLE (tdta, h), 1, 7
    
   CASE 50

   CASE 60

   CASE 70
   ' rigel:
   d = -32
   h = zn - (d * c)
   tdta = 8 * (stna - 79) + starshift + 4
   CIRCLE (tdta - 1, h), 1, 0
   CIRCLE (tdta, h), 1, 9
   CIRCLE (tdta - 1, h), 2, 0
   CIRCLE (tdta, h), 2, 14
   
   ' capella:
   d = 23
   h = zn - (d * c)
   tdta = 8 * (stna - 79) + starshift + 4
   CIRCLE (tdta - 1, h), 1, 0
   CIRCLE (tdta, h), 1, 13
   CIRCLE (tdta - 1, h), 2, 0
   CIRCLE (tdta, h), 2, 9
   
   ' aldebaran:
   d = -6
   h = zn - (d * c)
   tdta = 8 * (stna - 70) + starshift + 4
   CIRCLE (tdta - 1, h), 1, 0
   CIRCLE (tdta, h), 1, 9
   CIRCLE (tdta - 1, h), 2, 0
   CIRCLE (tdta, h), 2, 15
  
   CASE 80
   ' orion's belt stars, 3:
   d = -24
   h = zn - (d * c)
   tdta = 8 * (stna - 83) + starshift + 4
   CIRCLE (tdta - 1, h), 1, 0
   CIRCLE (tdta, h), 1, 15
     
   d = -25
   h = zn - (d * c)
   tdta = 8 * (stna - 84) + starshift + 4
   CIRCLE (tdta - 1, h), 1, 0
   CIRCLE (tdta, h), 1, 15
     
   d = -26
   h = zn - (d * c)
   tdta = 8 * (stna - 85) + starshift + 4
   CIRCLE (tdta - 1, h), 1, 0
   CIRCLE (tdta, h), 1, 15
   
   ' betelgeux:   (latin sp??; german: betelgeus, english: betelgeuse)
   d = -20
   h = zn - (d * c)
   tdta = 8 * (stna - 89) + starshift + 4
   CIRCLE (tdta - 1, h), 1, 0
   CIRCLE (tdta, h), 1, 15
   CIRCLE (tdta - 1, h), 2, 0
   CIRCLE (tdta, h), 2, 14
   CIRCLE (tdta - 1, h), 3, 0
   CIRCLE (tdta, h), 3, 12
  
   CASE 90
   ' winter solstice:
   tdta = 8 * (stna - 90) + starshift + 4
   LINE (tdta - 1, 84)-(tdta - 1, 110), 0
   LINE (tdta, 84)-(tdta, 110), 13

   CASE 100
   ' sirius:
   d = -39
   h = zn - (d * c)
   tdta = 8 * (stna - 102) + starshift + 4
   CIRCLE (tdta - 1, h), 1, 0
   CIRCLE (tdta, h), 1, 15
   CIRCLE (tdta - 1, h), 2, 0
   CIRCLE (tdta, h), 2, 7
   CIRCLE (tdta - 1, h), 3, 0
   CIRCLE (tdta, h), 3, 14
   
   CASE 110
   ' procyon:
   d = -18
   h = zn - (d * c)
   tdta = 8 * (stna - 116) + starshift + 4
   CIRCLE (tdta - 1, h), 1, 0
   CIRCLE (tdta, h), 1, 15
   CIRCLE (tdta - 1, h), 2, 0
   CIRCLE (tdta, h), 2, 1

   ' castor:
   d = 8
   h = zn - (d * c)
   tdta = 8 * (stna - 114) + starshift + 4
   CIRCLE (tdta - 1, h), 1, 0
   CIRCLE (tdta, h), 1, 15
   
   ' pollux:
   d = 5
   h = zn - (d * c)
   tdta = 8 * (stna - 117) + starshift + 4
   CIRCLE (tdta - 1, h), 1, 0
   CIRCLE (tdta, h), 1, 15

   CASE 120

   CASE 130

   CASE 140
   ' hydra-*:
   d = -22
   h = zn - (d * c)
   tdta = 8 * (stna - 143) + starshift + 4
   CIRCLE (tdta - 1, h), 1, 0
   CIRCLE (tdta, h), 1, 15
  
   CASE 150
   ' regulus:
   d = 1
   h = zn - (d * c)
   tdta = 8 * (stna - 152) + starshift + 4
   CIRCLE (tdta - 1, h), 1, 0
   CIRCLE (tdta, h), 1, 1
   CIRCLE (tdta - 1, h), 2, 0
   CIRCLE (tdta, h), 2, 15

   ' leo-2:
   d = 10
   h = zn - (d * c)
   tdta = 8 * (stna - 155) + starshift + 4
   CIRCLE (tdta - 1, h), 1, 0
   CIRCLE (tdta, h), 1, 7

   CASE 160
   ' leo-3:
   d = 16
   h = zn - (d * c)
   tdta = 8 * (stna - 169) + starshift + 4
   CIRCLE (tdta - 1, h), 1, 0
   CIRCLE (tdta, h), 1, 7
    
   CASE 170
   ' leo-4:
   d = 14
   h = zn - (d * c)
   tdta = 8 * (stna - 178) + starshift + 4
   CIRCLE (tdta - 1, h), 1, 0
   CIRCLE (tdta, h), 1, 7
    
   CASE 180
   ' virgo point:
   tdta = 8 * (stna - 180) + starshift + 4
   LINE (tdta - 1, 87)-(tdta - 1, 96), 0
   LINE (tdta, 87)-(tdta, 96), 13
   LINE (tdta - 1, 98)-(tdta - 1, 102), 0
   LINE (tdta, 98)-(tdta, 102), 13
   LINE (tdta - 1, 104)-(tdta - 1, 110), 0
   LINE (tdta, 104)-(tdta, 110), 13
   
   CASE 190

   CASE 200
   ' spica:
   d = -2
   h = zn - (d * c)
   tdta = 8 * (stna - 202) + starshift + 4
   CIRCLE (tdta - 1, h), 1, 0
   CIRCLE (tdta, h), 1, 15
   CIRCLE (tdta - 1, h), 2, 0
   CIRCLE (tdta, h), 2, 1

   ' beta centauri:
   d = -28
   h = zn - (d * c)
   tdta = 8 * (stna - 207) + starshift + 4
   CIRCLE (tdta - 1, h), 1, 0
   CIRCLE (tdta, h), 1, 15
   CIRCLE (tdta - 1, h), 2, 0
   CIRCLE (tdta, h), 2, 9
   
   CASE 210
   ' arcturus:
   d = 33
   h = zn - (d * c)
   tdta = 8 * (stna - 214) + starshift + 4
   CIRCLE (tdta - 1, h), 1, 0
   CIRCLE (tdta, h), 1, 15
   CIRCLE (tdta - 1, h), 2, 0
   CIRCLE (tdta, h), 2, 12

   ' alpha centauri:
   d = -20
   h = zn - (d * c)
   tdta = 8 * (stna - 212) + starshift + 4
   CIRCLE (tdta - 1, h), 1, 0
   CIRCLE (tdta, h), 1, 15
   CIRCLE (tdta - 1, h), 2, 0
   CIRCLE (tdta, h), 2, 1
      
   CASE 220

   CASE 230

   CASE 240
   ' antares:
   d = -3
   h = zn - (d * c)
   tdta = 8 * (stna - 247) + starshift + 4
   CIRCLE (tdta - 1, h), 1, 0
   CIRCLE (tdta, h), 1, 14
   CIRCLE (tdta - 1, h), 2, 0
   CIRCLE (tdta, h), 2, 12

   CASE 250

   CASE 260
    
   CASE 270
   ' winter solstice:
   tdta = 8 * (stna - 270) + starshift + 4
   LINE (tdta - 1, 84)-(tdta - 1, 110), 0
   LINE (tdta, 84)-(tdta, 110), 13
   
   ' january point  (old solstice ja nu ar y :  yes new arc eve  c.1800)
   tdta = 8 * (stna - 279) + starshift + 4     ' 270 + 2.9 degree r.a.
   LINE (tdta - 1, 77)-(tdta - 1, 88), 0
   LINE (tdta, 77)-(tdta, 88), 1
   LINE (tdta - 1, 112)-(tdta - 1, 123), 0
   LINE (tdta, 112)-(tdta, 123), 1

   CASE 280
   ' vega:
   d = 61
   h = zn - (d * c)
   tdta = 8 * (stna - 280) + starshift + 4
   CIRCLE (tdta - 1, h), 1, 0
   CIRCLE (tdta, h), 1, 15
   CIRCLE (tdta - 1, h), 2, 0
   CIRCLE (tdta, h), 2, 14

   CASE 290
   ' altair:
   d = 29
   h = zn - (d * c)
   tdta = 8 * (stna - 298) + starshift + 4
   CIRCLE (tdta - 1, h), 1, 0
   CIRCLE (tdta, h), 1, 1
   CIRCLE (tdta - 1, h), 2, 0
   CIRCLE (tdta, h), 2, 15

   CASE 300

   CASE 310
   ' deneb:
   d = 65
   h = zn - (d * c)
   tdta = 8 * (stna - 311) + starshift + 4
   CIRCLE (tdta - 1, h), 1, 0
   CIRCLE (tdta, h), 1, 1
   CIRCLE (tdta - 1, h), 2, 0
   CIRCLE (tdta, h), 2, 7

   CASE 320

   CASE 330

   CASE 340
   ' fomalhaut:
   d = -23
   h = zn - (d * c)
   tdta = 8 * (stna - 344) + starshift + 4
   CIRCLE (tdta - 1, h), 1, 0
   CIRCLE (tdta, h), 1, 13
   CIRCLE (tdta - 1, h), 2, 0
   CIRCLE (tdta, h), 2, 7

   ' pisces-1:
   d = 7
   h = zn - (d * c)
   tdta = 8 * (stna - 350) + starshift + 4
   CIRCLE (tdta - 1, h), 1, 0
   CIRCLE (tdta, h), 1, 7
    
   CASE 350
   ' pisces-2:
   d = 8
   h = zn - (d * c)
   tdta = 8 * (stna - 356) + starshift + 4
   CIRCLE (tdta - 1, h), 1, 0
   CIRCLE (tdta, h), 1, 7
     
   CASE 360
   ' pisces point:
   tdta = 8 * (stna - 0) + starshift + 4
   LINE (tdta - 1, 70)-(tdta - 1, 78), 0
   LINE (tdta, 70)-(tdta, 78), 13
   LINE (tdta - 1, 88)-(tdta - 1, 110), 0
   LINE (tdta, 88)-(tdta, 110), 13
   LINE (tdta - 1, 120)-(tdta - 1, 133), 0
   LINE (tdta, 120)-(tdta, 133), 13
   
   ' pisces-3:
   d = 8
   h = zn - (d * c)
   tdta = 8 * (stna - 0) + starshift + 4
   CIRCLE (tdta - 1, h), 1, 0
   CIRCLE (tdta, h), 1, 7
   END SELECT
NEXT
RETURN

' calculate days past for some month
yearco:
yrs = VAL(yr$)
IF yrs / 4 - INT(yrs / 4) = .5 THEN
   yr = 366
   GOTO 110
ELSE
   yr = 365
END IF
SELECT CASE mos
  CASE 1
    days = 0
  CASE 2
    days = 31
  CASE 3
    days = 59
  CASE 4
    days = 90
  CASE 5
    days = 120
  CASE 6
    days = 151
  CASE 7
    days = 181
  CASE 8
    days = 212
  CASE 9
    days = 243
  CASE 10
    days = 272
  CASE 11
    days = 304
  CASE 12
    days = 334
END SELECT
RETURN
110
SELECT CASE mos
  CASE 1
    days = 0
  CASE 2
    days = 31
  CASE 3
    days = 60
  CASE 4
    days = 91
  CASE 5
    days = 121
  CASE 6
    days = 152
  CASE 7
    days = 182
  CASE 8
    days = 213
  CASE 9
    days = 244
  CASE 10
    days = 274
  CASE 11
    days = 305
  CASE 12
    days = 335
END SELECT
RETURN

' checks keyboard
modekeys:
   mode$ = INKEY$
   IF LEN(mode$) THEN
      SELECT CASE LEN(mode$)
      CASE 1
         xkey = ASC(mode$)
         SELECT CASE xkey
         CASE 27 ' escape
            COLOR 7, 0
            SCREEN 0
            CLS
            END
         CASE 67, 99  ' C or c
            dsec = 30
            cflag = 0
            GOTO 5
         CASE 83, 115 ' S or s
            dsec = .3
            sflag = 1
            cflag = -1
            GOTO 5
         END SELECT
      END SELECT
   END IF
RETURN
